/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.launch.IGetLaunchHandler;
import com.epam.ta.reportportal.core.widget.content.StatisticBasedContentLoader;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.statistics.ExecutionCounter;
import com.epam.ta.reportportal.database.entity.statistics.IssueCounter;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetLaunchHandler
extends StatisticBasedContentLoader
implements IGetLaunchHandler {
    private ProjectRepository projectRepository;
    private final LaunchRepository launchRepository;

    @Autowired
    public GetLaunchHandler(LaunchRepository launchRepository) {
        this.launchRepository = (LaunchRepository)Preconditions.checkNotNull((Object)launchRepository);
    }

    @Autowired
    public void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    public LaunchResource getLaunch(String launchId, String userName, String projectName) {
        Launch launch = this.validate(launchId, projectName);
        if (launch.getMode() == Mode.DEBUG) {
            Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
            Project.UserConfig userConfig = ProjectUtils.findUserConfigByLogin((Project)project, (String)userName);
            BusinessRule.expect((Object)userConfig.getProjectRole(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)ProjectRole.CUSTOMER))).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        return (LaunchResource)LaunchConverter.TO_RESOURCE.apply(launch);
    }

    public LaunchResource getLaunchByName(String project, Pageable pageable, Filter filter, String username) {
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, project, "project"));
        Page launches = this.launchRepository.findByFilter((Queryable)filter, pageable);
        BusinessRule.expect((Object)launches, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[0]);
        return (LaunchResource)LaunchConverter.TO_RESOURCE.apply(launches.iterator().next());
    }

    public Iterable<LaunchResource> getProjectLaunches(String projectName, Filter filter, Pageable pageable, String userName) {
        this.validateModeConditions(filter);
        filter = this.addLaunchCommonCriteria(Mode.DEFAULT, filter, projectName);
        Page launches = this.launchRepository.findByFilter((Queryable)filter, pageable);
        return (Iterable)PagedResourcesAssembler.pageConverter((Function)LaunchConverter.TO_RESOURCE).apply(launches);
    }

    public Iterable<LaunchResource> getDebugLaunches(String projectName, String userName, Filter filter, Pageable pageable) {
        filter = this.addLaunchCommonCriteria(Mode.DEBUG, filter, projectName);
        Page launches = this.launchRepository.findByFilter((Queryable)filter, pageable);
        return (Iterable)PagedResourcesAssembler.pageConverter((Function)LaunchConverter.TO_RESOURCE).apply(launches);
    }

    public com.epam.ta.reportportal.ws.model.Page<LaunchResource> getLatestLaunches(String projectName, Filter filter, Pageable pageable) {
        this.validateModeConditions(filter);
        this.addLaunchCommonCriteria(Mode.DEFAULT, filter, projectName);
        Page resources = this.launchRepository.findLatestLaunches((Queryable)filter, pageable).map(LaunchConverter.TO_RESOURCE::apply);
        return new com.epam.ta.reportportal.ws.model.Page((Collection)resources.getContent(), (long)resources.getSize(), (long)(resources.getNumber() + 1), resources.getTotalElements(), (long)resources.getTotalPages());
    }

    public List<String> getTags(String project, String value) {
        return this.launchRepository.findDistinctValues(project, value, "tags");
    }

    public List<String> getLaunchNames(String project, String value) {
        BusinessRule.expect((Object)(value.length() > 2 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Length of the launch name string '{}' is less than 3 symbols", (Object[])new Object[]{value})});
        return this.launchRepository.findValuesWithMode(project, value, "name", Mode.DEFAULT.name());
    }

    public List<String> getOwners(String project, String value, String field, String mode) {
        BusinessRule.expect((Object)(value.length() > 2 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Length of the filtering string '{}' is less than 3 symbols", (Object[])new Object[]{value})});
        return this.launchRepository.findValuesWithMode(project, value, field, mode);
    }

    public Map<String, List<ChartObject>> getLaunchesComparisonInfo(String projectName, String[] ids) {
        List launches = this.launchRepository.find(Arrays.asList(ids));
        ArrayList objects = new ArrayList(launches.size());
        launches.forEach(launch -> {
            ChartObject object = new ChartObject();
            object.setName(launch.getName());
            object.setStartTime(String.valueOf(launch.getStartTime().getTime()));
            object.setNumber(String.valueOf(launch.getNumber()));
            object.setId(launch.getId());
            IssueCounter issueCounter = launch.getStatistics().getIssueCounter();
            ImmutableMap issuesData = ImmutableMap.builder().put((Object)"statistics$defects$product_bug$total", (Object)issueCounter.getProductBugTotal()).put((Object)"statistics$defects$system_issue$total", (Object)issueCounter.getSystemIssueTotal()).put((Object)"statistics$defects$automation_bug$total", (Object)issueCounter.getAutomationBugTotal()).put((Object)"statistics$defects$to_investigate$total", (Object)issueCounter.getToInvestigateTotal()).put((Object)"statistics$defects$no_defect$total", (Object)issueCounter.getNoDefectTotal()).build();
            ExecutionCounter executionCounter = launch.getStatistics().getExecutionCounter();
            ImmutableMap executionData = ImmutableMap.builder().put((Object)"statistics$executions$failed", (Object)executionCounter.getFailed()).put((Object)"statistics$executions$passed", (Object)executionCounter.getPassed()).put((Object)"statistics$executions$skipped", (Object)executionCounter.getSkipped()).build();
            Map computedStatistics = this.computeFraction((Map)issuesData);
            computedStatistics.putAll(this.computeFraction((Map)executionData));
            object.setValues(computedStatistics);
            objects.add(object);
        });
        return Collections.singletonMap("result", objects);
    }

    public Map<String, String> getStatuses(String projectName, String[] ids) {
        return this.launchRepository.find(Arrays.asList(ids)).stream().filter(launch -> launch.getProjectRef().equals(projectName)).collect(Collectors.toMap(Launch::getId, launch -> launch.getStatus().toString()));
    }

    private Filter addLaunchCommonCriteria(Mode mode, Filter filter, String projectName) {
        if (null != filter) {
            filter.addCondition(new FilterCondition(Condition.EQUALS, false, mode.toString(), "mode"));
            filter.addCondition(new FilterCondition(Condition.EQUALS, false, projectName, "project"));
        }
        return filter;
    }

    private Map<String, String> computeFraction(Map<String, Integer> data) {
        int total = data.values().stream().mapToInt(Integer::intValue).sum();
        return data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.countPercentage(((Integer)entry.getValue()).intValue(), total)));
    }

    private String countPercentage(int value, int total) {
        if (total == 0) {
            return "0";
        }
        BigDecimal bigDecimal = new BigDecimal((double)value / (double)total * 100.0);
        return bigDecimal.setScale(2, 6).toString();
    }

    private void validateModeConditions(Filter filter) {
        BusinessRule.expect((Object)filter.getFilterConditions().stream().anyMatch(com.epam.ta.reportportal.commons.Preconditions.HAS_ANY_MODE), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{"Filters for 'mode' aren't applicable for project's launches."});
    }

    private Launch validate(String launchId, String projectName) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Specified launch with id '{}' not referenced to specified project '{}'", (Object[])new Object[]{launchId, projectName})});
        return launch;
    }
}

