/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.merge.strategy;

import com.epam.ta.reportportal.core.item.merge.strategy.AbstractSuiteMergeStrategy;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.TestItemType;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class TestMergeStrategy
extends AbstractSuiteMergeStrategy {
    @Autowired
    public TestMergeStrategy(TestItemRepository testItemRepository) {
        super(testItemRepository);
    }

    public TestItem mergeTestItems(TestItem itemTarget, List<TestItem> items) {
        return this.moveAllChildTestItems(itemTarget, items);
    }

    public boolean isTestItemAcceptableToMerge(TestItem item) {
        if (!item.getType().sameLevel(TestItemType.SUITE)) {
            return false;
        }
        List childItems = this.testItemRepository.findAllDescendants(item.getId());
        for (TestItem testItem : childItems) {
            if (testItem.getType().sameLevel(TestItemType.SUITE)) continue;
            return false;
        }
        return true;
    }
}

