/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.filter.ICreateUserFilterHandler;
import com.epam.ta.reportportal.core.filter.impl.UserFilterValidationService;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.entity.filter.ObjectType;
import com.epam.ta.reportportal.database.entity.filter.SelectionOrder;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.events.FiltersCreatedEvent;
import com.epam.ta.reportportal.ws.converter.builders.UserFilterBuilder;
import com.epam.ta.reportportal.ws.model.CollectionsRQ;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.filter.CreateUserFilterRQ;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class CreateUserFilterHandler
implements ICreateUserFilterHandler {
    @Autowired
    private UserFilterRepository filterRepository;
    @Autowired
    private Provider<UserFilterBuilder> userFilterBuilder;
    @Autowired
    private UserFilterValidationService userFilterService;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EntryCreatedRS> createFilter(String userName, String projectName, CollectionsRQ<CreateUserFilterRQ> createFilterRQ) {
        List filters = createFilterRQ.getElements().stream().map(rq -> {
            Set updatedEntries = this.userFilterService.validateUserFilterEntities(ObjectType.getTypeByName((String)rq.getObjectType()), rq.getEntities());
            rq.setEntities(updatedEntries);
            UserFilter userFilter = (UserFilter)((UserFilterBuilder)this.userFilterBuilder.get()).addCreateRQ(rq).addProject(projectName).addSharing(userName, projectName, rq.getDescription(), rq.getShare() == null ? false : rq.getShare()).build();
            userFilter.getSelectionOptions().getOrders().stream().map(SelectionOrder::getSortingColumnName).forEach(columnName -> this.userFilterService.validateSortingColumnName(userFilter.getFilter().getTarget(), columnName));
            return userFilter;
        }).collect(Collectors.toList());
        CreateUserFilterHandler createUserFilterHandler = this;
        synchronized (createUserFilterHandler) {
            Set filterNames = filters.stream().map(userFilter -> {
                this.userFilterService.isFilterNameUnique(userName, userFilter.getName().trim(), projectName);
                return userFilter.getName();
            }).collect(Collectors.toSet());
            BusinessRule.expect((Object)filterNames.size(), (Predicate)Predicates.equalTo((Object)filters.size())).verify(ErrorType.BAD_SAVE_USER_FILTER_REQUEST, new Object[0]);
            List saved = this.filterRepository.save(filters);
            this.eventPublisher.publishEvent((Object)new FiltersCreatedEvent(saved, userName, projectName));
        }
        return filters.stream().map(filter -> new EntryCreatedRS(filter.getId())).collect(Collectors.toList());
    }
}

