/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.externalsystem.handler.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.externalsystem.ExternalSystemStrategy;
import com.epam.ta.reportportal.core.externalsystem.StrategyProvider;
import com.epam.ta.reportportal.core.externalsystem.handler.IUpdateExternalSystemHandler;
import com.epam.ta.reportportal.core.externalsystem.handler.impl.UpdateExternalSystemHandler;
import com.epam.ta.reportportal.database.dao.ExternalSystemRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.AuthType;
import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.issue.ExternalSystemType;
import com.epam.ta.reportportal.events.ExternalSystemUpdatedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.externalsystem.UpdateExternalSystemRQ;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Predicate;
import org.jasypt.util.text.BasicTextEncryptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UpdateExternalSystemHandler
implements IUpdateExternalSystemHandler {
    @Autowired
    private StrategyProvider strategyProvider;
    @Autowired
    private ExternalSystemRepository externalSystemRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private BasicTextEncryptor simpleEncryptor;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public OperationCompletionRS updateExternalSystem(UpdateExternalSystemRQ request, String projectName, String id, String principalName) {
        Project project = this.projectRepository.findByName(projectName);
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        ExternalSystem exist = (ExternalSystem)this.externalSystemRepository.findOne((Serializable)((Object)id));
        BusinessRule.expect((Object)exist, (Predicate)Predicates.notNull()).verify(ErrorType.EXTERNAL_SYSTEM_NOT_FOUND, new Object[]{exist});
        String sysUrl = exist.getUrl();
        String sysProject = exist.getProject();
        String rpProject = exist.getProjectRef();
        if (null != request.getUrl()) {
            if (request.getUrl().endsWith("/")) {
                request.setUrl(request.getUrl().substring(0, request.getUrl().length() - 1));
            }
            exist.setUrl(request.getUrl());
        }
        if (null != request.getExternalSystemType()) {
            Optional type = ExternalSystemType.findByName((String)request.getExternalSystemType());
            BusinessRule.expect((Object)type.isPresent(), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.INCORRECT_EXTERNAL_SYSTEM_NAME, new Object[]{request.getExternalSystemType()});
            exist.setExternalSystemType((ExternalSystemType)type.get());
        }
        ExternalSystemStrategy externalSystemStrategy = this.strategyProvider.getStrategy(exist.getExternalSystemType().name());
        if (null != request.getProject()) {
            exist.setProject(request.getProject());
        }
        exist.setProjectRef(projectName);
        if (null != request.getFields()) {
            exist.setFields(request.getFields());
        }
        if (!(sysUrl.equalsIgnoreCase(exist.getUrl()) && sysProject.equalsIgnoreCase(exist.getProject()) && rpProject.equalsIgnoreCase(exist.getProjectRef()))) {
            ExternalSystem duplicate = this.externalSystemRepository.findByUrlAndProject(exist.getUrl(), exist.getProject(), exist.getProjectRef());
            BusinessRule.expect((Object)duplicate, (Predicate)Predicates.isNull()).verify(ErrorType.EXTERNAL_SYSTEM_ALREADY_EXISTS, new Object[]{request.getUrl() + " & " + request.getProject()});
        }
        if (null != request.getExternalSystemAuth()) {
            AuthType auth = AuthType.findByName((String)request.getExternalSystemAuth());
            BusinessRule.expect((Object)auth, (Predicate)Predicates.notNull()).verify(ErrorType.INCORRECT_AUTHENTICATION_TYPE, new Object[]{request.getExternalSystemAuth()});
            exist.setExternalSystemAuth(auth);
            switch (1.$SwitchMap$com$epam$ta$reportportal$database$entity$AuthType[auth.ordinal()]) {
                case 1: {
                    if (null == request.getUsername() || null == request.getPassword()) break;
                    exist = UpdateExternalSystemHandler.resetNTLMFields((ExternalSystem)exist);
                    exist = UpdateExternalSystemHandler.resetOAuthFields((ExternalSystem)exist);
                    exist.setUsername(request.getUsername());
                    String encryptedPass = this.simpleEncryptor.encrypt(request.getPassword());
                    exist.setPassword(encryptedPass);
                    break;
                }
                case 2: {
                    if (null == request.getUsername() || null == request.getPassword() || null == request.getDomain()) break;
                    exist = UpdateExternalSystemHandler.resetBasicFields((ExternalSystem)exist);
                    exist = UpdateExternalSystemHandler.resetOAuthFields((ExternalSystem)exist);
                    exist.setUsername(request.getUsername());
                    String encryptedPass = this.simpleEncryptor.encrypt(request.getPassword());
                    exist.setPassword(encryptedPass);
                    exist.setDomain(request.getDomain());
                    break;
                }
                case 3: {
                    if (null == request.getAccessKey()) break;
                    exist = UpdateExternalSystemHandler.resetBasicFields((ExternalSystem)exist);
                    exist = UpdateExternalSystemHandler.resetNTLMFields((ExternalSystem)exist);
                    exist.setAccessKey(request.getAccessKey());
                    break;
                }
                case 4: {
                    if (null == request.getAccessKey()) break;
                    exist = UpdateExternalSystemHandler.resetBasicFields((ExternalSystem)exist);
                    exist = UpdateExternalSystemHandler.resetNTLMFields((ExternalSystem)exist);
                    exist.setAccessKey(request.getAccessKey());
                    break;
                }
            }
            if (auth.requiresPassword()) {
                String decrypted = exist.getPassword();
                exist.setPassword(this.simpleEncryptor.decrypt(exist.getPassword()));
                BusinessRule.expect((Object)externalSystemStrategy.connectionTest(exist), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.UNABLE_INTERACT_WITH_EXTRERNAL_SYSTEM, new Object[]{projectName});
                exist.setPassword(decrypted);
            } else {
                BusinessRule.expect((Object)externalSystemStrategy.connectionTest(exist), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.UNABLE_INTERACT_WITH_EXTRERNAL_SYSTEM, new Object[]{projectName});
            }
        }
        try {
            this.externalSystemRepository.save((Object)exist);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during updating ExternalSystem", (Throwable)e);
        }
        this.eventPublisher.publishEvent((Object)new ExternalSystemUpdatedEvent(exist, principalName));
        return new OperationCompletionRS("ExternalSystem with ID = '" + id + "' is successfully updated.");
    }

    public OperationCompletionRS externalSystemConnect(String id, UpdateExternalSystemRQ updateRQ, String principalName) {
        ExternalSystem system = (ExternalSystem)this.externalSystemRepository.findOne((Serializable)((Object)id));
        BusinessRule.expect((Object)system, (Predicate)Predicates.notNull()).verify(ErrorType.EXTERNAL_SYSTEM_NOT_FOUND, new Object[]{id});
        Project project = this.projectRepository.findByName(system.getProjectRef());
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{system.getProjectRef()});
        ExternalSystemStrategy externalSystemStrategy = this.strategyProvider.getStrategy(updateRQ.getExternalSystemType());
        ExternalSystem details = new ExternalSystem();
        details.setUrl(updateRQ.getUrl());
        details.setProject(updateRQ.getProject());
        AuthType authType = AuthType.findByName((String)updateRQ.getExternalSystemAuth());
        BusinessRule.expect((Object)authType, (Predicate)Predicates.notNull()).verify(ErrorType.INCORRECT_AUTHENTICATION_TYPE, new Object[]{updateRQ.getExternalSystemAuth()});
        details.setExternalSystemAuth(authType);
        if (authType.requiresPassword()) {
            details.setUsername(updateRQ.getUsername());
            details.setPassword(updateRQ.getPassword());
            details.setDomain(updateRQ.getDomain());
            details.setAccessKey(updateRQ.getAccessKey());
        }
        BusinessRule.expect((Object)externalSystemStrategy.connectionTest(details), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.UNABLE_INTERACT_WITH_EXTRERNAL_SYSTEM, new Object[]{system.getProjectRef()});
        return new OperationCompletionRS("Connection to ExternalSystem with ID = '" + id + "' is successfully performed.");
    }

    private static ExternalSystem resetBasicFields(ExternalSystem input) {
        input.setUsername(null);
        input.setPassword(null);
        return input;
    }

    private static ExternalSystem resetNTLMFields(ExternalSystem input) {
        input.setUsername(null);
        input.setPassword(null);
        input.setDomain(null);
        return input;
    }

    private static ExternalSystem resetOAuthFields(ExternalSystem input) {
        input.setAccessKey(null);
        return input;
    }
}

