/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.externalsystem.handler.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.externalsystem.handler.IDeleteExternalSystemHandler;
import com.epam.ta.reportportal.database.dao.ExternalSystemRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.events.ExternalSystemDeletedEvent;
import com.epam.ta.reportportal.events.ProjectExternalSystemsDeletedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DeleteExternalSystemHandler
implements IDeleteExternalSystemHandler {
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private ExternalSystemRepository externalSystemRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public synchronized OperationCompletionRS deleteExternalSystem(String projectName, String id, String username) {
        Project project = this.projectRepository.findByName(projectName);
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        ExternalSystem exist = (ExternalSystem)this.externalSystemRepository.findOne((Serializable)((Object)id));
        BusinessRule.expect((Object)exist, (Predicate)Predicates.notNull()).verify(ErrorType.EXTERNAL_SYSTEM_NOT_FOUND, new Object[]{exist});
        if (!project.getConfiguration().getExternalSystem().contains(id)) {
            BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"BTS with ID='{}' doesn't project '{}' related", (Object[])new Object[]{id, projectName})});
        }
        try {
            this.externalSystemRepository.delete((Serializable)((Object)id));
            List externalSystemIds = project.getConfiguration().getExternalSystem();
            externalSystemIds.remove(id);
            project.getConfiguration().setExternalSystem(externalSystemIds);
            this.projectRepository.save(project);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during deleting ExternalSystem", (Throwable)e);
        }
        this.eventPublisher.publishEvent((Object)new ExternalSystemDeletedEvent(exist, username));
        return new OperationCompletionRS("ExternalSystem with ID = '" + id + "' is successfully deleted.");
    }

    public synchronized OperationCompletionRS deleteAllExternalSystems(String projectName, String username) {
        Project project = this.projectRepository.findByName(projectName);
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        List exist = this.externalSystemRepository.findByProjectRef(projectName);
        try {
            if (null != exist) {
                this.externalSystemRepository.delete((Iterable)exist);
            }
            this.projectRepository.clearExternalSystems(projectName);
            this.eventPublisher.publishEvent((Object)new ProjectExternalSystemsDeletedEvent((Iterable)exist, projectName, username));
        }
        catch (Exception e) {
            throw new ReportPortalException("Clean: error during deleting ExternalSystems", (Throwable)e);
        }
        return new OperationCompletionRS("All ExternalSystems for project '" + projectName + "' successfully removed");
    }
}

