/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.auth.UatClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.OAuth2ClientProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.web.client.RestTemplate;

@Configuration
public class ServicesConfiguration {
    @Autowired
    private OAuth2ClientProperties oauthClientProperties;

    @LoadBalanced
    @Bean
    public OAuth2RestTemplate rpInternalRestTemplate(OAuth2ProtectedResourceDetails resource, OAuth2ClientContext context) {
        ClientCredentialsResourceDetails clientCredentialsResourceDetails = new ClientCredentialsResourceDetails();
        clientCredentialsResourceDetails.setClientId(this.oauthClientProperties.getClientId());
        clientCredentialsResourceDetails.setClientSecret(this.oauthClientProperties.getClientSecret());
        clientCredentialsResourceDetails.setAccessTokenUri(resource.getAccessTokenUri());
        clientCredentialsResourceDetails.setScope(resource.getScope());
        return new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)clientCredentialsResourceDetails, context);
    }

    @Bean
    public UatClient uatClient(@Value(value="${rp.uat.serviceUrl}") String uatServiceUrl, @Qualifier(value="rpInternalRestTemplate") OAuth2RestTemplate restTemplate) {
        return new UatClient(uatServiceUrl, (RestTemplate)restTemplate);
    }
}

