/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.admin;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.admin.ServerAdminHandler;
import com.epam.ta.reportportal.database.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.database.entity.settings.AnalyticsDetails;
import com.epam.ta.reportportal.database.entity.settings.ServerEmailDetails;
import com.epam.ta.reportportal.database.entity.settings.ServerSettings;
import com.epam.ta.reportportal.util.email.EmailService;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.converter.ServerSettingsResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.settings.AnalyticsResource;
import com.epam.ta.reportportal.ws.model.settings.ServerEmailResource;
import com.epam.ta.reportportal.ws.model.settings.ServerSettingsResource;
import com.mongodb.WriteResult;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.mail.MessagingException;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class ServerAdminHandlerImpl
implements ServerAdminHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAdminHandlerImpl.class);
    @Autowired
    private BasicTextEncryptor simpleEncryptor;
    @Autowired
    private ServerSettingsRepository repository;
    @Autowired
    private ServerSettingsResourceAssembler settingsAssembler;
    @Autowired
    private MailServiceFactory emailServiceFactory;
    @Autowired
    private MongoOperations mongoOperations;

    public ServerSettingsResource getServerSettings(String profileId) {
        return this.settingsAssembler.toResource(this.findServerSettings(profileId));
    }

    public OperationCompletionRS saveEmailSettings(String profileId, ServerEmailResource request) {
        ServerSettings settings = this.findServerSettings(profileId);
        if (null != request) {
            ServerEmailDetails serverEmailConfig = new ServerEmailDetails();
            serverEmailConfig.setEnabled(Boolean.valueOf(request.isEnabled()));
            if (request.isEnabled()) {
                Optional.ofNullable(request.getHost()).ifPresent(arg_0 -> ((ServerEmailDetails)serverEmailConfig).setHost(arg_0));
                int port = Optional.ofNullable(request.getPort()).orElse(25);
                if (port <= 0 || port > 65535) {
                    BusinessRule.fail().withError(ErrorType.INCORRECT_REQUEST, new Object[]{"Incorrect 'Port' value. Allowed value is [1..65535]"});
                }
                serverEmailConfig.setPort(Integer.valueOf(port));
                serverEmailConfig.setProtocol(Optional.ofNullable(request.getProtocol()).orElse("smtp"));
                Optional.ofNullable(request.getAuthEnabled()).ifPresent(authEnabled -> {
                    serverEmailConfig.setAuthEnabled(authEnabled);
                    if (authEnabled.booleanValue()) {
                        Optional.ofNullable(request.getUsername()).ifPresent(arg_0 -> ((ServerEmailDetails)serverEmailConfig).setUsername(arg_0));
                        Optional.ofNullable(request.getPassword()).ifPresent(pass -> serverEmailConfig.setPassword(this.simpleEncryptor.encrypt(pass)));
                    } else {
                        serverEmailConfig.setUsername(null);
                        serverEmailConfig.setPassword(null);
                    }
                });
                serverEmailConfig.setStarTlsEnabled(Boolean.valueOf(Boolean.TRUE.equals(request.getStarTlsEnabled())));
                serverEmailConfig.setSslEnabled(Boolean.valueOf(Boolean.TRUE.equals(request.getSslEnabled())));
                Optional.ofNullable(request.getFrom()).ifPresent(arg_0 -> ((ServerEmailDetails)serverEmailConfig).setFrom(arg_0));
                try {
                    ((EmailService)this.emailServiceFactory.getEmailService(serverEmailConfig).get()).testConnection();
                }
                catch (MessagingException ex) {
                    LOGGER.error("Cannot send email to user", (Throwable)ex);
                    BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Email configuration is incorrect. Please, check your configuration. " + ex.getMessage()});
                }
            }
            ServerSettings update = new ServerSettings();
            update.setId(settings.getId());
            update.setActive(settings.getActive());
            update.setServerEmailDetails(serverEmailConfig);
            this.repository.partialUpdate((Object)update);
        }
        return new OperationCompletionRS("Server Settings with profile '" + profileId + "' is successfully updated.");
    }

    public OperationCompletionRS deleteEmailSettings(String profileId) {
        WriteResult result = this.mongoOperations.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)profileId)), Update.update((String)"serverEmailDetails", null), ServerSettings.class);
        BusinessRule.expect((Object)result.getN(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)0))).verify(ErrorType.SERVER_SETTINGS_NOT_FOUND, new Object[]{profileId});
        return new OperationCompletionRS("Server Settings with profile '" + profileId + "' is successfully updated.");
    }

    public OperationCompletionRS saveAnalyticsSettings(String profileId, AnalyticsResource analyticsResource) {
        String analyticsType = analyticsResource.getType();
        ServerSettings settings = this.findServerSettings(profileId);
        Map<String, AnalyticsDetails> serverAnalyticsDetails = Optional.ofNullable(settings.getAnalyticsDetails()).orElse(Collections.emptyMap());
        AnalyticsDetails analyticsDetails = Optional.ofNullable(serverAnalyticsDetails.get(analyticsType)).orElse(new AnalyticsDetails());
        analyticsDetails.setEnabled(Optional.ofNullable(analyticsResource.getEnabled()).orElse(false));
        serverAnalyticsDetails.put(analyticsType, analyticsDetails);
        settings.setAnalyticsDetails(serverAnalyticsDetails);
        this.repository.save((Object)settings);
        return new OperationCompletionRS("Server Settings with profile '" + profileId + "' is successfully updated.");
    }

    private ServerSettings findServerSettings(String profileId) {
        ServerSettings settings = (ServerSettings)this.repository.findOne((Serializable)((Object)profileId));
        BusinessRule.expect((Object)settings, (Predicate)Predicates.notNull()).verify(ErrorType.SERVER_SETTINGS_NOT_FOUND, new Object[]{profileId});
        return settings;
    }
}

