/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.activity.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.activity.IActivityHandler;
import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.converter.ActivityResourceAssembler;
import com.epam.ta.reportportal.ws.model.ActivityResource;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ActivityHandler
implements IActivityHandler {
    private final ActivityRepository activityRepository;
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final ProjectRepository projectRepository;
    private final ActivityResourceAssembler activityResourceAssembler;

    @Autowired
    public ActivityHandler(ActivityRepository activityRepository, TestItemRepository testItemRepository, LaunchRepository launchRepository, ProjectRepository projectRepository, ActivityResourceAssembler activityResourceAssembler) {
        this.activityRepository = activityRepository;
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.projectRepository = projectRepository;
        this.activityResourceAssembler = activityResourceAssembler;
    }

    public List<ActivityResource> getActivitiesHistory(String projectName, Filter filter, Pageable pageable) {
        BusinessRule.expect((Object)this.projectRepository.exists((Serializable)((Object)projectName)), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        return this.activityRepository.findActivitiesByProjectId(projectName, filter, pageable).stream().map(arg_0 -> ((ActivityResourceAssembler)this.activityResourceAssembler).toResource(arg_0)).collect(Collectors.toList());
    }

    public ActivityResource getActivity(String projectName, String activityId) {
        BusinessRule.expect((Object)activityId, (Predicate)Predicates.notNull()).verify(ErrorType.ACTIVITY_NOT_FOUND, new Object[]{activityId});
        Activity activity = (Activity)this.activityRepository.findOne((Serializable)((Object)activityId));
        BusinessRule.expect((Object)activity, (Predicate)Predicates.notNull()).verify(ErrorType.ACTIVITY_NOT_FOUND, new Object[]{activityId});
        BusinessRule.expect((Object)projectName, (Predicate)Predicates.equalTo((Object)activity.getProjectRef())).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{activityId});
        return this.activityResourceAssembler.toResource(activity);
    }

    public com.epam.ta.reportportal.ws.model.Page<ActivityResource> getItemActivities(String projectName, Filter filter, Pageable pageable) {
        BusinessRule.expect((Object)this.projectRepository.exists((Serializable)((Object)projectName)), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, projectName, "projectRef"));
        Page page = this.activityRepository.findByFilter((Queryable)filter, pageable);
        return this.activityResourceAssembler.toPagedResources(page);
    }

    public List<ActivityResource> getItemActivities(String projectName, String itemId, Filter filter, Pageable pageable) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)itemId));
        BusinessRule.expect((Object)testItem, (Predicate)Predicates.notNull()).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId});
        String projectRef = ((Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()))).getProjectRef();
        BusinessRule.expect((Object)projectName, (Predicate)Predicates.equalTo((Object)projectRef)).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId});
        return this.activityRepository.findActivitiesByTestItemId(itemId, filter, pageable).stream().map(arg_0 -> ((ActivityResourceAssembler)this.activityResourceAssembler).toResource(arg_0)).collect(Collectors.toList());
    }
}

