/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.acl.chain;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.acl.chain.ChainMessage;
import com.epam.ta.reportportal.core.acl.chain.IChainElement;
import com.epam.ta.reportportal.core.acl.chain.UserFilterChainElement;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import java.util.List;
import java.util.Objects;

abstract class ChainElement
implements IChainElement {
    private IChainElement nextChainElement;

    public ChainElement(IChainElement nextChainElement) {
        this.nextChainElement = nextChainElement;
    }

    public boolean process(ChainMessage message) {
        if (!Preconditions.NOT_EMPTY_COLLECTION.test(message.getElements())) {
            return false;
        }
        if (!this.isCanHandle(message.getElements())) {
            if (this.nextChainElement == null) {
                return false;
            }
            return this.nextChainElement.process(message);
        }
        message.getElements().stream().filter(Objects::nonNull).forEach(shareable -> AclUtils.modifyACL((Acl)shareable.getAcl(), (String)message.getProjectName(), (String)message.getUserName(), (boolean)message.isShare()));
        if (message.isSave()) {
            this.saveElements(message.getElements());
        }
        List nextIterationElements = this.getNextElements(message.getElements(), message.getUserName());
        if (this.nextChainElement == null) {
            return true;
        }
        if (this.nextChainElement instanceof UserFilterChainElement && !message.isShare()) {
            return true;
        }
        message.setElements(nextIterationElements);
        message.setSave(true);
        return this.nextChainElement.process(message);
    }

    public abstract boolean isCanHandle(List<? extends Shareable> var1);

    public abstract List<? extends Shareable> getNextElements(List<? extends Shareable> var1, String var2);

    public abstract void saveElements(List<? extends Shareable> var1);
}

