/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.acl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.sharing.AclEntry;
import com.epam.ta.reportportal.database.entity.sharing.AclPermissions;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

/*
 * Exception performing whole class analysis ignored.
 */
public class AclUtils {
    private AclUtils() {
    }

    public static void modifyACL(Acl acl, String projectName, String userModifier, boolean isShare) {
        if (!acl.getOwnerUserId().equals(userModifier)) {
            return;
        }
        if (isShare) {
            AclUtils.share((Acl)acl, (String)projectName);
        } else {
            AclUtils.monopolize((Acl)acl, (String)projectName);
        }
    }

    public static void monopolize(Acl acl, String projectName) {
        Set entries = acl.getEntries();
        Optional aclEntry = entries.stream().filter(Preconditions.hasACLPermission((String)projectName, (AclPermissions)AclPermissions.READ)).findFirst();
        if (aclEntry.isPresent()) {
            if (((AclEntry)aclEntry.get()).getPermissions().size() > 1) {
                ((AclEntry)aclEntry.get()).removePermission(AclPermissions.READ);
            } else {
                entries.remove(aclEntry.get());
            }
        }
    }

    public static void isAllowedToEdit(Acl acl, String userModifier, Map<String, ProjectRole> userProjects, String resourceName, UserRole userRole) {
        if (!UserRole.ADMINISTRATOR.equals((Object)userRole)) {
            BusinessRule.expect((Object)acl, Preconditions.isOwner((String)userModifier).or(AclUtils.hasProjectRole(userProjects, (ProjectRole)ProjectRole.PROJECT_MANAGER))).verify(ErrorType.UNABLE_MODIFY_SHARABLE_RESOURCE, new Object[]{Suppliers.formattedSupplier((String)"User {} isn't owner of {} resource.", (Object[])new Object[]{userModifier, resourceName})});
        }
    }

    public static boolean isAllowedToDeleteWidget(Acl dashboardAcl, Acl widgetAcl, String modifier, ProjectRole projectRole, UserRole userRole) {
        return widgetAcl.getOwnerUserId().equals(modifier) || !dashboardAcl.getOwnerUserId().equals(modifier) && (UserRole.ADMINISTRATOR.equals((Object)userRole) || ProjectRole.PROJECT_MANAGER.equals((Object)projectRole));
    }

    public static void isPossibleToRead(Acl acl, String userModifier, String projectName) {
        BusinessRule.expect((Object)acl, (Predicate)Predicates.or((Predicate[])new Predicate[]{Preconditions.isOwner((String)userModifier), Preconditions.isSharedTo((String)projectName)})).verify(ErrorType.UNABLE_MODIFY_SHARABLE_RESOURCE, new Object[]{Suppliers.formattedSupplier((String)"User '{}' isn't owner of resource and resource isn't shared to project '{}'.", (Object[])new Object[]{userModifier, projectName})});
    }

    public static boolean isPossibleToReadResource(Acl acl, String userModifier, String projectName) {
        if (!acl.getOwnerUserId().equalsIgnoreCase(userModifier)) {
            return !acl.getEntries().stream().noneMatch(Preconditions.hasACLPermission((String)projectName, (AclPermissions)AclPermissions.READ));
        }
        return true;
    }

    public static void share(Acl acl, String projectName) {
        Set entries = acl.getEntries();
        Optional entry = entries.stream().filter(Preconditions.hasACLPermission((String)projectName, null)).findFirst();
        if (entry.isPresent()) {
            ((AclEntry)entry.get()).addPermission(AclPermissions.READ);
        } else {
            AclEntry aclEntry = new AclEntry();
            aclEntry.setProjectId(projectName);
            aclEntry.addPermission(AclPermissions.READ);
            entries.add(aclEntry);
        }
    }

    private static Predicate<Acl> hasProjectRole(Map<String, ProjectRole> userProjects, ProjectRole role) {
        return acl -> acl.getEntries().stream().anyMatch(e -> userProjects.containsKey(e.getProjectId()) && ((ProjectRole)userProjects.get(e.getProjectId())).compareTo((Enum)role) >= 0);
    }
}

