/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.permissions;

import com.epam.ta.reportportal.auth.permissions.LookupPermission;
import com.epam.ta.reportportal.auth.permissions.Permission;
import com.epam.ta.reportportal.auth.permissions.ProjectAuthority;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import java.util.Collection;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component(value="assignedToProjectPermission")
@LookupPermission(value={"isAssignedToProject"})
class AssignedToProjectPermission
implements Permission {
    @Autowired
    private Provider<ProjectRepository> projectRepository;

    AssignedToProjectPermission() {
    }

    public boolean isAllowed(Authentication authentication, Object projectName) {
        String project = (String)projectName;
        return authentication.isAuthenticated() && (this.hasProjectAuthority(authentication.getAuthorities(), project) || ((ProjectRepository)this.projectRepository.get()).isAssignedToProject(project, authentication.getName()));
    }

    private boolean hasProjectAuthority(Collection<? extends GrantedAuthority> authorityList, String project) {
        return authorityList.stream().filter(a -> a instanceof ProjectAuthority).anyMatch(pa -> ((ProjectAuthority)pa).getProject().equals(project));
    }
}

