/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth;

import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class UserRoleHierarchy
implements RoleHierarchy {
    public static final String ROLE_COMPONENT = "ROLE_COMPONENT";
    private static final Logger logger = LoggerFactory.getLogger(UserRoleHierarchy.class);
    private Map<GrantedAuthority, Set<GrantedAuthority>> authoritiesMap = Arrays.stream(UserRole.values()).collect(Collectors.toMap(arg_0 -> this.asAuthority(arg_0), arg_0 -> this.findReachableRoles(arg_0)));

    public UserRoleHierarchy() {
        SimpleGrantedAuthority component = new SimpleGrantedAuthority(ROLE_COMPONENT);
        this.authoritiesMap.put(component, ImmutableSet.builder().add((Object)component).build());
    }

    public Collection<? extends GrantedAuthority> getReachableGrantedAuthorities(Collection<? extends GrantedAuthority> authorities) {
        if (authorities == null || authorities.isEmpty()) {
            return AuthorityUtils.NO_AUTHORITIES;
        }
        List reachableRoles = authorities.stream().filter(authority -> this.authoritiesMap.containsKey(authority)).flatMap(authority -> ((Set)this.authoritiesMap.get(authority)).stream()).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            logger.debug("getReachableGrantedAuthorities() - From the roles " + authorities + " one can reach " + reachableRoles + " in zero or more steps.");
        }
        return reachableRoles;
    }

    private Set<GrantedAuthority> findReachableRoles(UserRole authority) {
        HashSet<GrantedAuthority> reachableRoles = new HashSet<GrantedAuthority>();
        UserRole[] roles = UserRole.values();
        int startIndex = Arrays.binarySearch(UserRole.values(), authority);
        for (int i = 0; i <= startIndex; ++i) {
            reachableRoles.add(this.asAuthority(roles[i]));
        }
        return reachableRoles;
    }

    private GrantedAuthority asAuthority(UserRole userRole) {
        return new SimpleGrantedAuthority(userRole.getAuthority());
    }
}

