/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth;

import com.epam.ta.reportportal.auth.ExpirationPolicy;
import com.epam.ta.reportportal.database.entity.user.User;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LoginTimeBasedExpirationPolicy
implements ExpirationPolicy {
    private Duration time;

    public LoginTimeBasedExpirationPolicy(Duration time) {
        this.time = time;
    }

    @Autowired
    public LoginTimeBasedExpirationPolicy(@Value(value="${rp.auth.expire.account.after}") long expirationDays) {
        this.time = Duration.ofDays(expirationDays);
    }

    public Date getExpirationDate() {
        return Date.from(Instant.now().minusSeconds(this.time.getSeconds()));
    }

    public boolean isExpired(User user) {
        return user.getMetaInfo().getLastLogin().before(this.getExpirationDate());
    }
}

