/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.config;

import com.epam.healenium.processor.BaseProcessor;
import com.epam.healenium.processor.FillMetricsProcessor;
import com.epam.healenium.processor.FindChildElementProcessor;
import com.epam.healenium.processor.FindChildElementsProcessor;
import com.epam.healenium.processor.FindElementProcessor;
import com.epam.healenium.processor.FindElementsProcessor;
import com.epam.healenium.processor.GetReferenceElementsProcessor;
import com.epam.healenium.processor.HealingElementsProcessor;
import com.epam.healenium.processor.HealingProcessor;
import com.epam.healenium.processor.ImitateProcessor;
import com.epam.healenium.processor.SaveHealingResultsProcessor;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;

public class ProcessorConfig {
    public static BaseProcessor findElementChainProcessor() {
        return ProcessorConfig.buildChain(FindElementProcessor.class, GetReferenceElementsProcessor.class, HealingProcessor.class, ImitateProcessor.class, FillMetricsProcessor.class, SaveHealingResultsProcessor.class);
    }

    public static BaseProcessor findElementsChainProcessor() {
        return ProcessorConfig.buildChain(FindElementsProcessor.class, GetReferenceElementsProcessor.class, HealingElementsProcessor.class, FillMetricsProcessor.class, SaveHealingResultsProcessor.class);
    }

    public static BaseProcessor findChildElementChainProcessor() {
        return ProcessorConfig.buildChain(FindChildElementProcessor.class, GetReferenceElementsProcessor.class, HealingProcessor.class, ImitateProcessor.class, FillMetricsProcessor.class, SaveHealingResultsProcessor.class);
    }

    public static BaseProcessor findChildElementsChainProcessor() {
        return ProcessorConfig.buildChain(FindChildElementsProcessor.class, GetReferenceElementsProcessor.class, HealingElementsProcessor.class, FillMetricsProcessor.class, SaveHealingResultsProcessor.class);
    }

    private static BaseProcessor buildChain(Class<?> ... clazz) {
        Collections.reverse(Arrays.asList(clazz));
        BaseProcessor param = null;
        for (Class<?> aClass : clazz) {
            Constructor<?> constructor = aClass.getConstructor(BaseProcessor.class);
            param = (BaseProcessor)constructor.newInstance(param);
        }
        return param;
    }
}

