/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.auth;

import com.enonic.xp.lib.auth.PrincipalsResultMapper;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.security.IdProviderKey;
import com.enonic.xp.security.PrincipalQuery;
import com.enonic.xp.security.PrincipalQueryResult;
import com.enonic.xp.security.PrincipalType;
import com.enonic.xp.security.SecurityService;
import java.util.function.Supplier;

public final class FindPrincipalsHandler
implements ScriptBean {
    private Supplier<SecurityService> securityService;
    private PrincipalType type;
    private IdProviderKey idProvider;
    private int start = 0;
    private int count = 10;
    private String name;
    private String searchText;

    public void setSearchText(String value) {
        this.searchText = value;
    }

    public void setType(String type) {
        if (type == null || type.isBlank()) {
            this.type = null;
            return;
        }
        switch (type.trim().toLowerCase()) {
            case "group": {
                this.type = PrincipalType.GROUP;
                return;
            }
            case "role": {
                this.type = PrincipalType.ROLE;
                return;
            }
            case "user": {
                this.type = PrincipalType.USER;
                return;
            }
        }
        throw new IllegalArgumentException("Invalid principal type: '" + type + "'");
    }

    public void setIdProvider(String idProvider) {
        if (idProvider == null || idProvider.isBlank()) {
            this.idProvider = null;
            return;
        }
        this.idProvider = IdProviderKey.from((String)idProvider);
    }

    public void setStart(Integer start) {
        if (start != null) {
            this.start = start;
        }
    }

    public void setCount(Integer count) {
        if (count != null) {
            this.count = count;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public PrincipalsResultMapper findPrincipals() {
        PrincipalQuery.Builder query = PrincipalQuery.create();
        if (this.type != null) {
            query.includeTypes(new PrincipalType[]{this.type});
        }
        if (this.idProvider != null) {
            query.idProvider(this.idProvider);
        }
        query.name(this.name);
        query.from(this.start);
        query.size(this.count);
        query.searchText(this.searchText);
        PrincipalQueryResult result = this.securityService.get().query(query.build());
        return new PrincipalsResultMapper(result.getPrincipals(), result.getTotalSize());
    }

    public void initialize(BeanContext context) {
        this.securityService = context.getService(SecurityService.class);
    }
}

