/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.textio.template;

import com.embabel.common.textio.template.EscFilter;
import com.embabel.common.textio.template.InvalidTemplateException;
import com.embabel.common.textio.template.JinjaProperties;
import com.embabel.common.textio.template.NoSuchTemplateException;
import com.embabel.common.textio.template.TemplateRenderer;
import com.hubspot.jinjava.Jinjava;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.loader.ResourceLocator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.DigestUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0014B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J$\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/embabel/common/textio/template/JinjavaTemplateRenderer;", "Lcom/embabel/common/textio/template/TemplateRenderer;", "jinja", "Lcom/embabel/common/textio/template/JinjaProperties;", "resourceLoader", "Lorg/springframework/core/io/ResourceLoader;", "<init>", "(Lcom/embabel/common/textio/template/JinjaProperties;Lorg/springframework/core/io/ResourceLoader;)V", "logger", "Lorg/slf4j/Logger;", "renderLiteralTemplate", "", "template", "model", "", "", "renderLoadedTemplate", "templateName", "getLocation", "load", "SpringResourceLocator", "embabel-common-textio"})
public final class JinjavaTemplateRenderer
implements TemplateRenderer {
    @NotNull
    private final JinjaProperties jinja;
    @NotNull
    private final ResourceLoader resourceLoader;
    @NotNull
    private final Logger logger;

    public JinjavaTemplateRenderer(@NotNull JinjaProperties jinja, @NotNull ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)jinja, (String)"jinja");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.jinja = jinja;
        this.resourceLoader = resourceLoader;
        Logger logger = LoggerFactory.getLogger(JinjavaTemplateRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public /* synthetic */ JinjavaTemplateRenderer(JinjaProperties jinjaProperties, ResourceLoader resourceLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jinjaProperties = new JinjaProperties("classpath:/prompts/", ".jinja", false);
        }
        if ((n & 2) != 0) {
            resourceLoader = (ResourceLoader)new DefaultResourceLoader();
        }
        this(jinjaProperties, resourceLoader);
    }

    @Override
    @NotNull
    public String renderLiteralTemplate(@NotNull String template, @NotNull Map<String, ? extends Object> model) throws InvalidTemplateException {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        try {
            JinjavaConfig jcConfig = JinjavaConfig.newBuilder().withFailOnUnknownTokens(this.jinja.getFailOnUnknownTokens()).withTrimBlocks(true).build();
            Jinjava $this$renderLiteralTemplate_u24lambda_u240 = new Jinjava(jcConfig);
            boolean bl = false;
            $this$renderLiteralTemplate_u24lambda_u240.registerFilter((Filter)new EscFilter());
            $this$renderLiteralTemplate_u24lambda_u240.setResourceLocator((ResourceLocator)new SpringResourceLocator());
            String string = $this$renderLiteralTemplate_u24lambda_u240.render(template, model);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"run(...)");
            return string;
        }
        catch (Exception e) {
            throw new InvalidTemplateException("Invalid template '" + template + "'", e);
        }
    }

    @Override
    @NotNull
    public String renderLoadedTemplate(@NotNull String templateName, @NotNull Map<String, ? extends Object> model) throws NoSuchTemplateException, InvalidTemplateException {
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        String template = this.load(templateName);
        try {
            return this.renderLiteralTemplate(template, model);
        }
        catch (InvalidTemplateException ex) {
            throw new InvalidTemplateException("Invalid template at '" + templateName + "'", (Throwable)((Object)ex));
        }
    }

    private final String getLocation(String template) {
        if (StringsKt.startsWith$default((String)template, (String)"classpath:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)template, (String)"file:", (boolean)false, (int)2, null)) {
            return template;
        }
        return this.jinja.getPrefix() + template + (StringsKt.contains$default((CharSequence)template, (CharSequence)this.jinja.getSuffix(), (boolean)false, (int)2, null) ? "" : this.jinja.getSuffix());
    }

    @Override
    @NotNull
    public String load(@NotNull String templateName) throws NoSuchTemplateException {
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        String expanded = this.getLocation(templateName);
        Resource resource = this.resourceLoader.getResource(expanded);
        Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"getResource(...)");
        Resource resource2 = resource;
        if (!resource2.exists()) {
            throw new NoSuchTemplateException(templateName, resource2);
        }
        try {
            String template;
            String string = resource2.getContentAsString(Charset.defaultCharset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentAsString(...)");
            String string2 = template = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            String string3 = DigestUtils.md5DigestAsHex((byte[])byArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"md5DigestAsHex(...)");
            String sha = string3;
            Object[] objectArray = new Object[]{templateName, sha, expanded};
            this.logger.debug("Loaded template {} with sha [{}] at location [{}]", objectArray);
            return template;
        }
        catch (IOException e) {
            throw new InvalidTemplateException("Can't read template at '" + expanded + "'", e);
        }
    }

    public JinjavaTemplateRenderer() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/embabel/common/textio/template/JinjavaTemplateRenderer$SpringResourceLocator;", "Lcom/hubspot/jinjava/loader/ResourceLocator;", "<init>", "(Lcom/embabel/common/textio/template/JinjavaTemplateRenderer;)V", "getString", "", "fullName", "encoding", "Ljava/nio/charset/Charset;", "interpreter", "Lcom/hubspot/jinjava/interpret/JinjavaInterpreter;", "embabel-common-textio"})
    private final class SpringResourceLocator
    implements ResourceLocator {
        @Nullable
        public String getString(@NotNull String fullName, @Nullable Charset encoding, @Nullable JinjavaInterpreter interpreter) {
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            return JinjavaTemplateRenderer.this.load(fullName);
        }
    }
}

