/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.core.config;

import com.embabel.common.core.config.CrossJarConfig;
import com.embabel.common.core.config.DiscoveryResult;
import com.embabel.common.core.config.PropertyAnalysis;
import com.embabel.common.core.config.PropertyConflict;
import com.embabel.common.core.config.PropertySourceInfo;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u0015J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0016\u0010\u001b\u001a\u00020\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J(\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u001d0 2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0013H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/embabel/common/core/config/CrossJarPropertiesUtil;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/Properties;", "resolver", "Lorg/springframework/core/io/support/PathMatchingResourcePatternResolver;", "config", "Lcom/embabel/common/core/config/CrossJarConfig;", "loadCrossJarProperties", "fileName", "analyzeCrossJarProperties", "Lcom/embabel/common/core/config/PropertyAnalysis;", "configure", "", "newConfig", "clearCache", "loadAndMergeProperties", "discoverPropertySources", "Lcom/embabel/common/core/config/DiscoveryResult;", "mergeWithHierarchy", "sources", "", "Lcom/embabel/common/core/config/PropertySourceInfo;", "detectConflicts", "", "Lcom/embabel/common/core/config/PropertyConflict;", "logAnalysis", "analysis", "embabel-common-core"})
@SourceDebugExtension(value={"SMAP\nCrossJarPropertiesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossJarPropertiesUtil.kt\ncom/embabel/common/core/config/CrossJarPropertiesUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,449:1\n1797#2,3:450\n1368#2:453\n1454#2,2:454\n1557#2:456\n1628#2,3:457\n1456#2,3:460\n1863#2:463\n1611#2,9:464\n1863#2:473\n1864#2:475\n1620#2:476\n1053#2:477\n1567#2:478\n1598#2,4:479\n1864#2:483\n1053#2:484\n1863#2,2:485\n230#2,2:488\n1863#2,2:490\n1#3:474\n216#4:487\n217#4:492\n*S KotlinDebug\n*F\n+ 1 CrossJarPropertiesUtil.kt\ncom/embabel/common/core/config/CrossJarPropertiesUtil\n*L\n376#1:450,3\n391#1:453\n391#1:454,2\n391#1:456\n391#1:457,3\n391#1:460,3\n394#1:463\n395#1:464,9\n395#1:473\n395#1:475\n395#1:476\n403#1:477\n404#1:478\n404#1:479,4\n394#1:483\n420#1:484\n420#1:485,2\n427#1:488,2\n431#1:490,2\n395#1:474\n426#1:487\n426#1:492\n*E\n"})
public final class CrossJarPropertiesUtil {
    @NotNull
    public static final CrossJarPropertiesUtil INSTANCE = new CrossJarPropertiesUtil();
    private static final Logger logger = LoggerFactory.getLogger(CrossJarPropertiesUtil.class);
    @NotNull
    private static final ConcurrentHashMap<String, Properties> cache = new ConcurrentHashMap();
    @NotNull
    private static final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    @NotNull
    private static CrossJarConfig config = CrossJarConfig.Companion.getDEFAULT();

    private CrossJarPropertiesUtil() {
    }

    @NotNull
    public final Properties loadCrossJarProperties(@NotNull String fileName) {
        Properties properties;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (config.getCacheResults()) {
            Properties properties2 = cache.computeIfAbsent(fileName, arg_0 -> CrossJarPropertiesUtil.loadCrossJarProperties$lambda$1(CrossJarPropertiesUtil::loadCrossJarProperties$lambda$0, arg_0));
            Intrinsics.checkNotNull((Object)properties2);
            properties = properties2;
        } else {
            properties = this.loadAndMergeProperties(fileName);
        }
        return properties;
    }

    @NotNull
    public final PropertyAnalysis analyzeCrossJarProperties(@NotNull String fileName) {
        PropertyAnalysis propertyAnalysis;
        DiscoveryResult discoveryResult;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        DiscoveryResult discoveryResult2 = discoveryResult = this.discoverPropertySources(fileName);
        if (discoveryResult2 instanceof DiscoveryResult.Success) {
            PropertyAnalysis propertyAnalysis2;
            Map<String, List<PropertyConflict>> conflicts = this.detectConflicts(((DiscoveryResult.Success)discoveryResult).getSources());
            Properties merged = this.mergeWithHierarchy(((DiscoveryResult.Success)discoveryResult).getSources());
            PropertyAnalysis analysis = propertyAnalysis2 = new PropertyAnalysis(fileName, ((DiscoveryResult.Success)discoveryResult).getSources(), merged, conflicts);
            boolean bl = false;
            if (config.getLogMergeProcess()) {
                INSTANCE.logAnalysis(analysis);
            }
            propertyAnalysis = propertyAnalysis2;
        } else if (discoveryResult2 instanceof DiscoveryResult.Empty) {
            propertyAnalysis = new PropertyAnalysis(fileName, CollectionsKt.emptyList(), new Properties(), MapsKt.emptyMap());
        } else if (discoveryResult2 instanceof DiscoveryResult.Error) {
            if (config.getFailOnError()) {
                throw ((DiscoveryResult.Error)discoveryResult).getCause();
            }
            propertyAnalysis = new PropertyAnalysis(fileName, CollectionsKt.emptyList(), new Properties(), MapsKt.emptyMap());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return propertyAnalysis;
    }

    public final void configure(@NotNull CrossJarConfig newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        config = newConfig;
        if (!newConfig.getCacheResults()) {
            this.clearCache();
        }
        logger.debug("CrossJarPropertiesUtil configured: " + newConfig);
    }

    public final void clearCache() {
        cache.clear();
        logger.debug("Cross-JAR properties cache cleared");
    }

    private final Properties loadAndMergeProperties(String fileName) {
        Properties properties;
        logger.debug("Loading cross-JAR properties for: " + fileName);
        try {
            Properties properties2;
            DiscoveryResult discoveryResult = this.discoverPropertySources(fileName);
            if (discoveryResult instanceof DiscoveryResult.Success) {
                if (((DiscoveryResult.Success)discoveryResult).isEmpty()) {
                    logger.warn("No '" + fileName + "' files found in classpath");
                    if (config.getFailOnError()) {
                        throw new IllegalStateException("No property files found for '" + fileName + "' in classpath (STRICT mode)");
                    }
                    properties2 = new Properties();
                } else if (((DiscoveryResult.Success)discoveryResult).getSourceCount() == 1) {
                    Properties properties3 = var3_3 = ((PropertySourceInfo)CollectionsKt.first(((DiscoveryResult.Success)discoveryResult).getSources())).getProperties();
                    boolean bl = false;
                    if (config.getLogMergeProcess()) {
                        logger.info("Loaded '" + fileName + "' from 1 source: " + properties3.size() + " properties");
                        Set<Map.Entry<Object, Object>> set = properties3.entrySet();
                        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                        propertiesString = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, CrossJarPropertiesUtil::loadAndMergeProperties$lambda$4$lambda$3, (int)30, null);
                        logger.info("Properties for '" + fileName + "':\n" + propertiesString);
                    }
                    properties2 = var3_3;
                } else {
                    Properties merged = var3_3 = this.mergeWithHierarchy(((DiscoveryResult.Success)discoveryResult).getSources());
                    boolean bl = false;
                    if (config.getLogMergeProcess()) {
                        logger.info("Merged '" + fileName + "' from " + ((DiscoveryResult.Success)discoveryResult).getSourceCount() + " sources: " + merged.size() + " final properties");
                        Set<Map.Entry<Object, Object>> set = merged.entrySet();
                        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                        propertiesString = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, CrossJarPropertiesUtil::loadAndMergeProperties$lambda$6$lambda$5, (int)30, null);
                        logger.info("Final merged properties for '" + fileName + "':\n" + propertiesString);
                    }
                    properties2 = var3_3;
                }
            } else if (discoveryResult instanceof DiscoveryResult.Empty) {
                logger.warn("No '" + fileName + "' files found in classpath");
                if (config.getFailOnError()) {
                    throw new IllegalStateException("No property files found for '" + fileName + "' in classpath (STRICT mode)");
                }
                properties2 = new Properties();
            } else if (discoveryResult instanceof DiscoveryResult.Error) {
                logger.error("Failed to discover property sources for '" + fileName + "'", ((DiscoveryResult.Error)discoveryResult).getCause());
                if (config.getFailOnError()) {
                    throw ((DiscoveryResult.Error)discoveryResult).getCause();
                }
                properties2 = new Properties();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            properties = properties2;
        }
        catch (Exception e) {
            logger.error("Failed to load cross-JAR properties for '" + fileName + "': " + e.getMessage());
            if (config.getFailOnError()) {
                throw e;
            }
            properties = new Properties();
        }
        return properties;
    }

    private final DiscoveryResult discoverPropertySources(String fileName) {
        DiscoveryResult discoveryResult;
        try {
            DiscoveryResult discoveryResult2;
            Object[] objectArray = resolver.getResources("classpath*:" + fileName);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getResources(...)");
            Object[] resources = objectArray;
            List sources = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])resources), CrossJarPropertiesUtil::discoverPropertySources$lambda$7), arg_0 -> CrossJarPropertiesUtil.discoverPropertySources$lambda$8(fileName, arg_0)));
            if (sources.isEmpty()) {
                logger.info("No instances of '" + fileName + "' found in classpath");
                discoveryResult2 = new DiscoveryResult.Empty(fileName);
            } else {
                String sourcesList = CollectionsKt.joinToString$default((Iterable)sources, (CharSequence)"\n", null, null, (int)0, null, CrossJarPropertiesUtil::discoverPropertySources$lambda$9, (int)30, null);
                logger.info("Discovered " + sources.size() + " instances of '" + fileName + "':\n" + sourcesList);
                discoveryResult2 = new DiscoveryResult.Success(sources);
            }
            discoveryResult = discoveryResult2;
        }
        catch (Exception e) {
            logger.error("Failed to discover property sources for '" + fileName + "'", (Throwable)e);
            discoveryResult = new DiscoveryResult.Error(fileName, e);
        }
        return discoveryResult;
    }

    /*
     * WARNING - void declaration
     */
    private final Properties mergeWithHierarchy(List<PropertySourceInfo> sources) {
        void $this$fold$iv;
        if (sources.isEmpty()) {
            return new Properties();
        }
        if (sources.size() == 1) {
            return ((PropertySourceInfo)CollectionsKt.first(sources)).getProperties();
        }
        logger.debug("Starting hierarchical merge of " + sources.size() + " property sources");
        Object object = new Comparator(){

            public final int compare(T a, T b) {
                PropertySourceInfo it = (PropertySourceInfo)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getDepth());
                it = (PropertySourceInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getDepth()));
            }
        };
        List sortedSources = CollectionsKt.sortedWith((Iterable)sources, (Comparator)new Comparator((Comparator)object, sources){
            final /* synthetic */ Comparator $this_thenByDescending;
            final /* synthetic */ List $sources$inlined;
            {
                this.$this_thenByDescending = $receiver;
                this.$sources$inlined = list;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    PropertySourceInfo it = (PropertySourceInfo)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(this.$sources$inlined.indexOf(it));
                    it = (PropertySourceInfo)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$sources$inlined.indexOf(it)));
                }
                return n;
            }
        });
        object = sortedSources;
        Properties initial$iv = new Properties();
        boolean $i$f$fold = false;
        Properties accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Properties properties;
            void source;
            PropertySourceInfo propertySourceInfo = (PropertySourceInfo)element$iv;
            Properties merged = accumulator$iv;
            boolean bl = false;
            if (config.getLogMergeProcess()) {
                logger.debug("Merging depth " + source.getDepth() + ": " + source.getJarPath() + " (" + source.getProperties().size() + " properties)");
            }
            Properties $this$mergeWithHierarchy_u24lambda_u2413_u24lambda_u2412 = properties = merged;
            boolean bl2 = false;
            $this$mergeWithHierarchy_u24lambda_u2413_u24lambda_u2412.putAll((Map<?, ?>)source.getProperties());
            accumulator$iv = properties;
        }
        Object result = object = accumulator$iv;
        boolean bl = false;
        logger.debug("Hierarchical merge complete: " + ((Properties)result).size() + " final properties");
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<PropertyConflict>> detectConflicts(List<PropertySourceInfo> sources) {
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        void $this$flatMapTo$iv$iv;
        if (sources.size() <= 1) {
            return MapsKt.emptyMap();
        }
        Iterable $this$flatMap$iv = sources;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            PropertySourceInfo it = (PropertySourceInfo)element$iv$iv;
            boolean bl = false;
            Set<Object> set = it.getProperties().keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void key;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type kotlin.String");
                collection.add((String)key);
            }
            Iterable list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set allKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Map conflicts = new LinkedHashMap();
        Iterable $this$forEach$iv = allKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapIndexedTo$iv$iv;
            int n;
            Object source;
            void $this$mapNotNullTo$iv$iv;
            String key = (String)element$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = sources;
            boolean $i$f$mapNotNull = false;
            $this$map$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo22 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PropertyConflict propertyConflict;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                source = (PropertySourceInfo)element$iv$iv;
                n = 0;
                if (((PropertySourceInfo)source).getProperties().getProperty(key) != null) {
                    String value;
                    boolean bl4 = false;
                    propertyConflict = new PropertyConflict(key, value, (PropertySourceInfo)source, false);
                } else {
                    propertyConflict = null;
                }
                if (propertyConflict == null) continue;
                PropertyConflict it$iv$iv = propertyConflict;
                boolean bl5 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List valuesForKey = (List)destination$iv$iv3;
            if (valuesForKey.size() <= 1) continue;
            Iterable $this$sortedBy$iv = valuesForKey;
            boolean $i$f$sortedBy = false;
            List sortedByDepth = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PropertyConflict it = (PropertyConflict)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getSource().getDepth());
                    it = (PropertyConflict)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getSource().getDepth()));
                }
            });
            Iterable $this$mapIndexed$iv = sortedByDepth;
            boolean $i$f$mapIndexed = false;
            Iterable $i$f$mapNotNullTo22 = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void conflict;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                source = (PropertyConflict)item$iv$iv;
                n = n2;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(PropertyConflict.copy$default((PropertyConflict)conflict, null, null, null, index < sortedByDepth.size() - 1, 7, null));
            }
            List conflictList = (List)destination$iv$iv;
            conflicts.put(key, CollectionsKt.toMutableList((Collection)conflictList));
        }
        return conflicts;
    }

    private final void logAnalysis(PropertyAnalysis analysis) {
        Object element$iv;
        if (!logger.isInfoEnabled()) {
            return;
        }
        logger.info("=== Cross-JAR Property Analysis: " + analysis.getFileName() + " ===");
        logger.info("Discovered " + analysis.getSourceCount() + " sources:");
        Iterable $this$sortedBy$iv = analysis.getSources();
        boolean $i$f$sortedBy = false;
        Object $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PropertySourceInfo it = (PropertySourceInfo)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getDepth());
                it = (PropertySourceInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getDepth()));
            }
        });
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            PropertySourceInfo source = (PropertySourceInfo)element$iv;
            boolean bl = false;
            logger.info("  Depth " + source.getDepth() + ": " + source.getJarPath() + " (" + source.getProperties().size() + " properties)");
        }
        if (analysis.getHasConflicts() && config.getLogConflicts()) {
            logger.info("Property conflicts found (" + analysis.getConflictCount() + "):");
            $this$forEach$iv = analysis.getConflicts();
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object element$iv22;
                List conflicts;
                String key;
                block6: {
                    Object object = element$iv = (Map.Entry)iterator.next();
                    boolean bl = false;
                    key = (String)object.getKey();
                    conflicts = (List)object.getValue();
                    Iterable $this$first$iv = conflicts;
                    boolean $i$f$first = false;
                    for (Object element$iv22 : $this$first$iv) {
                        PropertyConflict it = (PropertyConflict)element$iv22;
                        boolean bl2 = false;
                        if (!it.isWinner()) continue;
                        break block6;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                PropertyConflict winner = (PropertyConflict)element$iv22;
                logger.info("  '" + key + "': " + conflicts.size() + " sources, winner: '" + winner.getValue() + "' from depth " + winner.getSource().getDepth());
                if (!logger.isDebugEnabled()) continue;
                Iterable $this$forEach$iv2 = conflicts;
                boolean $i$f$forEach2 = false;
                for (Object element$iv22 : $this$forEach$iv2) {
                    PropertyConflict conflict = (PropertyConflict)element$iv22;
                    boolean bl = false;
                    String status = conflict.getOverridden() ? "OVERRIDDEN" : "WINNER";
                    logger.debug("    " + status + ": '" + conflict.getValue() + "' from " + conflict.getSource().getJarPath());
                }
            }
        }
        logger.info("Final result: " + analysis.getPropertyCount() + " properties");
        logger.info("=== End Analysis ===");
    }

    private static final Properties loadCrossJarProperties$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.loadAndMergeProperties(it);
    }

    private static final Properties loadCrossJarProperties$lambda$1(Function1 $tmp0, Object p0) {
        return (Properties)$tmp0.invoke(p0);
    }

    private static final CharSequence loadAndMergeProperties$lambda$4$lambda$3(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        Object key = entry.getKey();
        Object value = entry.getValue();
        return "  " + key + "=" + value;
    }

    private static final CharSequence loadAndMergeProperties$lambda$6$lambda$5(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        Object key = entry.getKey();
        Object value = entry.getValue();
        return "  " + key + "=" + value;
    }

    private static final boolean discoverPropertySources$lambda$7(Resource resource) {
        return resource.exists() && resource.isReadable();
    }

    private static final PropertySourceInfo discoverPropertySources$lambda$8(String $fileName, Resource resource) {
        PropertySourceInfo propertySourceInfo;
        try {
            URL uRL = resource.getURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getURL(...)");
            propertySourceInfo = PropertySourceInfo.Companion.load(uRL, $fileName);
        }
        catch (Exception e) {
            logger.warn("Failed to load properties from " + resource.getURL() + ": " + e.getMessage());
            propertySourceInfo = null;
        }
        return propertySourceInfo;
    }

    private static final CharSequence discoverPropertySources$lambda$9(PropertySourceInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "  " + it.getUrl() + " (" + it.getProperties().size() + " properties)";
    }
}

