/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.web.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/embabel/agent/web/rest/GlobalExceptionHandler;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "handleNotFound", "Lorg/springframework/http/ResponseEntity;", "", "", "ex", "Lorg/springframework/web/servlet/NoHandlerFoundException;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "getClientIp", "embabel-agent-webmvc"})
public class GlobalExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @NotNull
    public ResponseEntity<Map<String, Object>> handleNotFound(@NotNull NoHandlerFoundException ex, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.logger.warn("404 Not Found - Method: " + ex.getHttpMethod() + ", Path: " + ex.getRequestURL() + ", Client IP: " + this.getClientIp(request));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"status", (Object)HttpStatus.NOT_FOUND.value()), TuplesKt.to((Object)"error", (Object)HttpStatus.NOT_FOUND.getReasonPhrase()), TuplesKt.to((Object)"path", (Object)ex.getRequestURL())};
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    private String getClientIp(HttpServletRequest request) {
        String string = request.getHeader("X-Forwarded-For");
        if (string == null && (string = request.getHeader("X-Real-IP")) == null) {
            String string2 = request.getRemoteAddr();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRemoteAddr(...)");
        }
        return string;
    }
}

