/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.testing.integration;

import com.embabel.agent.core.Action;
import com.embabel.agent.core.AgentPlatform;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.spi.LlmInteraction;
import com.embabel.agent.spi.LlmOperations;
import com.embabel.chat.Message;
import com.embabel.common.ai.model.ModelProvider;
import java.util.List;
import java.util.function.Predicate;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.bean.override.mockito.MockitoBean;

@SpringBootTest
@TestPropertySource(properties={"embabel.models.default-llm=test-model", "embabel.agent.verbosity.debug=true", "spring.shell.interactive.enabled=false", "spring.shell.noninteractive.enabled=false"})
public class EmbabelMockitoIntegrationTest {
    @Autowired
    protected AgentPlatform agentPlatform;
    @MockitoBean
    private ModelProvider modelProvider;
    @MockitoBean
    protected LlmOperations llmOperations;

    protected <T> OngoingStubbing<T> whenCreateObject(Predicate<String> promptMatcher, Class<T> outputClass, Predicate<LlmInteraction> llmInteractionPredicate) {
        return Mockito.when((Object)this.llmOperations.createObject((List)ArgumentMatchers.argThat(m -> this.firstMessageContentSatisfiesMatcher((List<? extends Message>)m, promptMatcher)), (LlmInteraction)ArgumentMatchers.argThat(llmInteractionPredicate::test), (Class)ArgumentMatchers.eq(outputClass), (AgentProcess)ArgumentMatchers.any(), (Action)ArgumentMatchers.any()));
    }

    protected <T> OngoingStubbing<T> whenCreateObject(Predicate<String> promptMatcher, Class<T> outputClass) {
        return this.whenCreateObject(promptMatcher, outputClass, llmi -> true);
    }

    protected OngoingStubbing<String> whenGenerateText(Predicate<String> promptMatcher, Predicate<LlmInteraction> llmInteractionMatcher) {
        return Mockito.when((Object)((String)this.llmOperations.createObject((List)ArgumentMatchers.argThat(m -> this.firstMessageContentSatisfiesMatcher((List<? extends Message>)m, promptMatcher)), (LlmInteraction)ArgumentMatchers.argThat(llmInteractionMatcher::test), (Class)ArgumentMatchers.eq(String.class), (AgentProcess)ArgumentMatchers.any(), (Action)ArgumentMatchers.any())));
    }

    protected OngoingStubbing<String> whenGenerateText(Predicate<String> promptMatcher) {
        return this.whenGenerateText(promptMatcher, llmi -> true);
    }

    protected <T> void verifyCreateObject(Predicate<String> promptMatcher, Class<T> outputClass, Predicate<LlmInteraction> llmInteractionMatcher) {
        ((LlmOperations)Mockito.verify((Object)this.llmOperations)).createObject((List)ArgumentMatchers.argThat(m -> this.firstMessageContentSatisfiesMatcher((List<? extends Message>)m, promptMatcher)), (LlmInteraction)ArgumentMatchers.argThat(llmInteractionMatcher::test), (Class)ArgumentMatchers.eq(outputClass), (AgentProcess)ArgumentMatchers.any(), (Action)ArgumentMatchers.any());
    }

    protected <T> void verifyCreateObject(Predicate<String> prompt, Class<T> outputClass) {
        this.verifyCreateObject(prompt, outputClass, llmi -> true);
    }

    protected void verifyGenerateText(Predicate<String> promptMatcher, Predicate<LlmInteraction> llmInteractionMatcher) {
        ((LlmOperations)Mockito.verify((Object)this.llmOperations)).createObject((List)ArgumentMatchers.argThat(m -> this.firstMessageContentSatisfiesMatcher((List<? extends Message>)m, promptMatcher)), (LlmInteraction)ArgumentMatchers.argThat(llmInteractionMatcher::test), (Class)ArgumentMatchers.eq(String.class), (AgentProcess)ArgumentMatchers.any(), (Action)ArgumentMatchers.any());
    }

    protected void verifyGenerateText(Predicate<String> promptMatcher) {
        this.verifyGenerateText(promptMatcher, llmi -> true);
    }

    protected <T> void verifyCreateObjectMatching(Predicate<String> promptMatcher, Class<T> outputClass, ArgumentMatcher<LlmInteraction> llmInteractionMatcher) {
        ((LlmOperations)Mockito.verify((Object)this.llmOperations)).createObject((List)ArgumentMatchers.argThat(m -> this.firstMessageContentSatisfiesMatcher((List<? extends Message>)m, promptMatcher)), (LlmInteraction)ArgumentMatchers.argThat(llmInteractionMatcher), (Class)ArgumentMatchers.eq(outputClass), (AgentProcess)ArgumentMatchers.any(), (Action)ArgumentMatchers.any());
    }

    protected <T> void verifyCreateObjectMatchingMessages(ArgumentMatcher<List<Message>> promptMatcher, Class<T> outputClass, ArgumentMatcher<LlmInteraction> llmInteractionMatcher) {
        ((LlmOperations)Mockito.verify((Object)this.llmOperations)).createObject((List)ArgumentMatchers.argThat(promptMatcher), (LlmInteraction)ArgumentMatchers.argThat(llmInteractionMatcher), (Class)ArgumentMatchers.eq(outputClass), (AgentProcess)ArgumentMatchers.any(), (Action)ArgumentMatchers.any());
    }

    protected void verifyGenerateTextMatching(Predicate<String> promptMatcher) {
        ((LlmOperations)Mockito.verify((Object)this.llmOperations)).createObject((List)ArgumentMatchers.argThat(messages -> this.firstMessageContentSatisfiesMatcher((List<? extends Message>)messages, promptMatcher)), (LlmInteraction)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class), (AgentProcess)ArgumentMatchers.any(), (Action)ArgumentMatchers.any());
    }

    protected void verifyGenerateTextMatching(Predicate<String> promptMatcher, LlmInteraction llmInteraction) {
        ((LlmOperations)Mockito.verify((Object)this.llmOperations)).createObject((List)ArgumentMatchers.argThat(messages -> this.firstMessageContentSatisfiesMatcher((List<? extends Message>)messages, promptMatcher)), (LlmInteraction)ArgumentMatchers.eq((Object)llmInteraction), (Class)ArgumentMatchers.eq(String.class), (AgentProcess)ArgumentMatchers.any(), (Action)ArgumentMatchers.any());
    }

    protected void verifyNoInteractions() {
        Mockito.verifyNoInteractions((Object[])new Object[]{this.llmOperations});
    }

    protected void verifyNoMoreInteractions() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.llmOperations});
    }

    protected ArgumentCaptor<String> capturePrompt() {
        return ArgumentCaptor.forClass(String.class);
    }

    protected ArgumentCaptor<LlmInteraction> captureLlmInteraction() {
        return ArgumentCaptor.forClass(LlmInteraction.class);
    }

    protected <T> ArgumentCaptor<Class<T>> captureOutputClass() {
        return ArgumentCaptor.forClass(Class.class);
    }

    private boolean firstMessageContentSatisfiesMatcher(List<? extends Message> messages, Predicate<String> contentMatcher) {
        return messages != null && messages.size() == 1 && contentMatcher.test(messages.getFirst().getContent());
    }
}

