/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.shell;

import com.embabel.agent.api.common.autonomy.AgentProcessExecution;
import com.embabel.agent.domain.library.HasContent;
import com.embabel.agent.domain.library.InternetResource;
import com.embabel.agent.domain.library.InternetResources;
import com.embabel.agent.event.logging.personality.ColorPalette;
import com.embabel.agent.shell.MarkdownKt;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.util.AnsiBuilderKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.text.WordUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"formatProcessOutput", "", "result", "Lcom/embabel/agent/api/common/autonomy/AgentProcessExecution;", "colorPalette", "Lcom/embabel/agent/event/logging/personality/ColorPalette;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "lineLength", "", "embabel-agent-shell"})
public final class FormatProcessOutputKt {
    @NotNull
    public static final String formatProcessOutput(@NotNull AgentProcessExecution result, @NotNull ColorPalette colorPalette, @NotNull ObjectMapper objectMapper, int lineLength) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Object output = "";
        if (result.getOutput() instanceof HasContent) {
            Object object;
            Object object2 = result.getOutput();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.embabel.agent.domain.library.HasContent");
            HasContent hasContentOutput = (HasContent)object2;
            if (StringsKt.contains$default((CharSequence)hasContentOutput.getContent(), (CharSequence)"#", (boolean)false, (int)2, null)) {
                String string = WordUtils.wrap((String)MarkdownKt.markdownToConsole(hasContentOutput.getContent()), (int)lineLength);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrap(...)");
                object = "\n" + AnsiBuilderKt.color((String)string, (int)colorPalette.getColor2());
            } else {
                String string = WordUtils.wrap((String)hasContentOutput.getContent(), (int)lineLength);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrap(...)");
                object = AnsiBuilderKt.color((String)string, (int)colorPalette.getColor2());
            }
            output = (String)output + (String)object;
            if (result.getOutput() instanceof InternetResources) {
                Object object3 = result.getOutput();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.embabel.agent.domain.library.InternetResources");
                InternetResources internetResourcesOutput = (InternetResources)object3;
                output = (String)output + "\n\n" + CollectionsKt.joinToString$default((Iterable)internetResourcesOutput.getLinks(), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> FormatProcessOutputKt.formatProcessOutput$lambda$0(colorPalette, arg_0), (int)30, null);
            }
        } else {
            output = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(result.getOutput());
        }
        return StringsKt.trimMargin$default((String)("|\n              |" + HasInfoString.infoString$default((HasInfoString)((HasInfoString)result.getAgentProcess()), (Boolean)true, (int)0, (int)2, null) + "\n              |\n              |You asked: " + AnsiBuilderKt.color((String)result.getBasis().toString(), (int)colorPalette.getHighlight()) + "\n              |\n              |" + AnsiBuilderKt.color((String)output, (int)colorPalette.getColor2()) + "\n              |\n              |" + result.getAgentProcess().costInfoString(true) + "\n              |" + HasInfoString.infoString$default((HasInfoString)((HasInfoString)result.getAgentProcess().getToolsStats()), (Boolean)true, (int)0, (int)2, null) + "\n              |"), null, (int)1, null);
    }

    private static final CharSequence formatProcessOutput$lambda$0(ColorPalette $colorPalette, InternetResource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "- " + it.getUrl() + ": " + AnsiBuilderKt.color((String)it.getSummary(), (int)$colorPalette.getColor2());
    }
}

