/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.service.support;

import com.embabel.agent.rag.model.Retrievable;
import com.embabel.agent.rag.service.CoreSearchOperations;
import com.embabel.agent.rag.service.support.AssetRetrievable;
import com.embabel.agent.rag.service.support.TextMath;
import com.embabel.agent.rag.service.support.VectorMath;
import com.embabel.chat.Asset;
import com.embabel.chat.AssetView;
import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.core.types.SimilarityResult;
import com.embabel.common.core.types.SimpleSimilaritySearchResult;
import com.embabel.common.core.types.TextSimilaritySearchRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J4\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u00160\u0015\"\b\b\u0000\u0010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001cH\u0016J4\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u00160\u0015\"\b\b\u0000\u0010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/embabel/agent/rag/service/support/AssetViewSearchOperations;", "Lcom/embabel/agent/rag/service/CoreSearchOperations;", "assetView", "Lcom/embabel/chat/AssetView;", "embeddingService", "Lcom/embabel/common/ai/model/EmbeddingService;", "<init>", "(Lcom/embabel/chat/AssetView;Lcom/embabel/common/ai/model/EmbeddingService;)V", "getAssetView", "()Lcom/embabel/chat/AssetView;", "embeddingCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "supportsType", "", "type", "luceneSyntaxNotes", "getLuceneSyntaxNotes", "()Ljava/lang/String;", "vectorSearch", "", "Lcom/embabel/common/core/types/SimilarityResult;", "T", "Lcom/embabel/agent/rag/model/Retrievable;", "request", "Lcom/embabel/common/core/types/TextSimilaritySearchRequest;", "clazz", "Ljava/lang/Class;", "textSearch", "getAssetText", "asset", "Lcom/embabel/chat/Asset;", "getOrComputeEmbedding", "clearEmbeddingCache", "", "precomputeEmbeddings", "embabel-agent-rag-core"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nAssetViewSearchOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssetViewSearchOperations.kt\ncom/embabel/agent/rag/service/support/AssetViewSearchOperations\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n618#2:190\n618#2:194\n774#3:191\n865#3,2:192\n1863#3,2:195\n*S KotlinDebug\n*F\n+ 1 AssetViewSearchOperations.kt\ncom/embabel/agent/rag/service/support/AssetViewSearchOperations\n*L\n76#1:190\n107#1:194\n96#1:191\n96#1:192,2\n150#1:195,2\n*E\n"})
public final class AssetViewSearchOperations
implements CoreSearchOperations {
    @NotNull
    private final AssetView assetView;
    @Nullable
    private final EmbeddingService embeddingService;
    @NotNull
    private final ConcurrentHashMap<String, float[]> embeddingCache;

    public AssetViewSearchOperations(@NotNull AssetView assetView, @Nullable EmbeddingService embeddingService) {
        Intrinsics.checkNotNullParameter((Object)assetView, (String)"assetView");
        this.assetView = assetView;
        this.embeddingService = embeddingService;
        this.embeddingCache = new ConcurrentHashMap();
    }

    public /* synthetic */ AssetViewSearchOperations(AssetView assetView, EmbeddingService embeddingService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            embeddingService = null;
        }
        this(assetView, embeddingService);
    }

    @NotNull
    public final AssetView getAssetView() {
        return this.assetView;
    }

    @Override
    public boolean supportsType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)Asset.class.getSimpleName()) || Intrinsics.areEqual((Object)type, (Object)AssetRetrievable.class.getSimpleName());
    }

    @Override
    @NotNull
    public String getLuceneSyntaxNotes() {
        return "Simple text matching only. Supports case-insensitive substring search. No Lucene query syntax supported.";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T extends Retrievable> List<SimilarityResult<T>> vectorSearch(@NotNull TextSimilaritySearchRequest request, @NotNull Class<T> clazz) {
        void $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (this.embeddingService == null) {
            return CollectionsKt.emptyList();
        }
        float[] queryEmbedding = this.embeddingService.embed(request.getQuery());
        List assets = this.assetView.getAssets();
        Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)assets), arg_0 -> AssetViewSearchOperations.vectorSearch$lambda$0(this, queryEmbedding, arg_0)), arg_0 -> AssetViewSearchOperations.vectorSearch$lambda$1(request, arg_0));
        boolean $i$f$sortedByDescending = false;
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.take((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)b;
                boolean bl = false;
                double score = ((Number)pair.component2()).doubleValue();
                pair = (Pair)a;
                Comparable comparable = Double.valueOf(score);
                bl = false;
                score = ((Number)pair.component2()).doubleValue();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(score));
            }
        }), (int)request.getTopK()), arg_0 -> AssetViewSearchOperations.vectorSearch$lambda$3(clazz, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T extends Retrievable> List<SimilarityResult<T>> textSearch(@NotNull TextSimilaritySearchRequest request, @NotNull Class<T> clazz) {
        void $this$sortedByDescending$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String string = request.getQuery().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String queryLower = string;
        Object object = queryLower;
        Regex regex = new Regex("\\s+");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$filter22 = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List queryTerms = (List)destination$iv$iv;
        List assets = this.assetView.getAssets();
        Sequence $i$f$filter22 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)assets), arg_0 -> AssetViewSearchOperations.textSearch$lambda$5(this, queryTerms, arg_0)), arg_0 -> AssetViewSearchOperations.textSearch$lambda$6(request, arg_0));
        boolean $i$f$sortedByDescending = false;
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.take((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)b;
                boolean bl = false;
                double score = ((Number)pair.component2()).doubleValue();
                pair = (Pair)a;
                Comparable comparable = Double.valueOf(score);
                bl = false;
                score = ((Number)pair.component2()).doubleValue();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(score));
            }
        }), (int)request.getTopK()), arg_0 -> AssetViewSearchOperations.textSearch$lambda$8(clazz, arg_0)));
    }

    private final String getAssetText(Asset asset) {
        return asset.reference().contribution();
    }

    private final float[] getOrComputeEmbedding(Asset asset) {
        float[] fArray = this.embeddingCache.computeIfAbsent(asset.getId(), arg_0 -> AssetViewSearchOperations.getOrComputeEmbedding$lambda$10(arg_0 -> AssetViewSearchOperations.getOrComputeEmbedding$lambda$9(this, asset, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"computeIfAbsent(...)");
        return fArray;
    }

    public final void clearEmbeddingCache() {
        this.embeddingCache.clear();
    }

    public final void precomputeEmbeddings() {
        if (this.embeddingService == null) {
            return;
        }
        Iterable $this$forEach$iv = this.assetView.getAssets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Asset asset = (Asset)element$iv;
            boolean bl = false;
            this.getOrComputeEmbedding(asset);
        }
    }

    private static final Pair vectorSearch$lambda$0(AssetViewSearchOperations this$0, float[] $queryEmbedding, Asset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        float[] assetEmbedding = this$0.getOrComputeEmbedding(asset);
        double score = VectorMath.INSTANCE.cosineSimilarity($queryEmbedding, assetEmbedding);
        return TuplesKt.to((Object)asset, (Object)score);
    }

    private static final boolean vectorSearch$lambda$1(TextSimilaritySearchRequest $request, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        double score = ((Number)pair.component2()).doubleValue();
        return score >= $request.getSimilarityThreshold();
    }

    private static final SimpleSimilaritySearchResult vectorSearch$lambda$3(Class $clazz, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        Asset asset = (Asset)pair.component1();
        double score = ((Number)pair.component2()).doubleValue();
        AssetRetrievable retrievable = new AssetRetrievable(asset);
        return $clazz.isInstance(retrievable) ? new SimpleSimilaritySearchResult((Object)retrievable, score) : null;
    }

    private static final Pair textSearch$lambda$5(AssetViewSearchOperations this$0, List $queryTerms, Asset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        String string = this$0.getAssetText(asset).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String text = string;
        double score = TextMath.INSTANCE.textMatchScore(text, $queryTerms);
        return TuplesKt.to((Object)asset, (Object)score);
    }

    private static final boolean textSearch$lambda$6(TextSimilaritySearchRequest $request, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        double score = ((Number)pair.component2()).doubleValue();
        return score >= $request.getSimilarityThreshold();
    }

    private static final SimpleSimilaritySearchResult textSearch$lambda$8(Class $clazz, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        Asset asset = (Asset)pair.component1();
        double score = ((Number)pair.component2()).doubleValue();
        AssetRetrievable retrievable = new AssetRetrievable(asset);
        return $clazz.isInstance(retrievable) ? new SimpleSimilaritySearchResult((Object)retrievable, score) : null;
    }

    private static final float[] getOrComputeEmbedding$lambda$9(AssetViewSearchOperations this$0, Asset $asset, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EmbeddingService embeddingService = this$0.embeddingService;
        Intrinsics.checkNotNull((Object)embeddingService);
        return embeddingService.embed(this$0.getAssetText($asset));
    }

    private static final float[] getOrComputeEmbedding$lambda$10(Function1 $tmp0, Object p0) {
        return (float[])$tmp0.invoke(p0);
    }
}

