/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.service;

import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.model.Fact;
import com.embabel.agent.rag.model.NamedEntityData;
import com.embabel.agent.rag.model.Retrievable;
import com.embabel.agent.rag.service.RetrievableResultsFormatter;
import com.embabel.agent.rag.service.SimilarityResults;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.core.types.SimilarityResult;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/embabel/agent/rag/service/SimpleRetrievableResultsFormatter;", "Lcom/embabel/agent/rag/service/RetrievableResultsFormatter;", "<init>", "()V", "formatResults", "", "similarityResults", "Lcom/embabel/agent/rag/service/SimilarityResults;", "Lcom/embabel/agent/rag/model/Retrievable;", "embabel-agent-rag-core"})
@SourceDebugExtension(value={"SMAP\nRetrievableResultsFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetrievableResultsFormatter.kt\ncom/embabel/agent/rag/service/SimpleRetrievableResultsFormatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class SimpleRetrievableResultsFormatter
implements RetrievableResultsFormatter {
    @NotNull
    public static final SimpleRetrievableResultsFormatter INSTANCE = new SimpleRetrievableResultsFormatter();

    private SimpleRetrievableResultsFormatter() {
    }

    @Override
    @NotNull
    public String formatResults(@NotNull SimilarityResults<? extends Retrievable> similarityResults) {
        Intrinsics.checkNotNullParameter(similarityResults, (String)"similarityResults");
        List<SimilarityResult<? extends Retrievable>> results = similarityResults.getResults();
        String header = results.size() + " results:";
        String formattedResults = CollectionsKt.joinToString$default((Iterable)results, (CharSequence)"\n---\n", null, null, (int)0, null, SimpleRetrievableResultsFormatter::formatResults$lambda$1, (int)30, null);
        return results.isEmpty() ? header : header + "\n\n" + formattedResults;
    }

    private static final CharSequence formatResults$lambda$1(SimilarityResult result) {
        CharSequence charSequence;
        block3: {
            Retrievable match;
            String formattedScore;
            block4: {
                Object object;
                block6: {
                    block5: {
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                            String string = "%.2f";
                            Object[] objectArray = new Object[]{result.getScore()};
                            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                            formattedScore = string2;
                            match = (Retrievable)result.getMatch();
                            if (!(match instanceof NamedEntityData)) break block2;
                            charSequence = formattedScore + ": " + ((NamedEntityData)match).embeddableValue();
                            break block3;
                        }
                        if (!(match instanceof Chunk)) break block4;
                        object = ((Chunk)match).getUri();
                        if (object == null) break block5;
                        String it = object;
                        boolean bl = false;
                        String string = "url: " + it + "\n";
                        object = string;
                        if (string != null) break block6;
                    }
                    object = "";
                }
                String urlHeader = object;
                charSequence = "chunkId: " + match.getId() + " " + urlHeader + formattedScore + " - " + ((Chunk)match).getText();
                break block3;
            }
            charSequence = match instanceof Fact ? (CharSequence)(formattedScore + ": fact - " + ((Fact)match).getAssertion()) : (CharSequence)(formattedScore + ": " + result.getMatch().getClass().getSimpleName() + " - " + HasInfoString.infoString$default((HasInfoString)match, (Boolean)true, (int)0, (int)2, null));
        }
        return charSequence;
    }
}

