/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.tools;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.rag.filter.EntityFilter;
import com.embabel.agent.rag.filter.PropertyFilter;
import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.service.FilteringRegexSearch;
import com.embabel.agent.rag.service.RegexSearchOperations;
import com.embabel.agent.rag.service.SimilarityResults;
import com.embabel.agent.rag.service.SimpleRetrievableResultsFormatter;
import com.embabel.agent.rag.tools.PostFilteringSearch;
import com.embabel.agent.rag.tools.ResultsEvent;
import com.embabel.agent.rag.tools.ResultsListener;
import com.embabel.agent.rag.tools.SearchTools;
import com.embabel.agent.rag.tools.TopKInflationStrategy;
import com.embabel.common.core.types.SimilarityResult;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0002\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J$\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/embabel/agent/rag/tools/RegexSearchTools;", "Lcom/embabel/agent/rag/tools/SearchTools;", "regexSearch", "Lcom/embabel/agent/rag/service/RegexSearchOperations;", "metadataFilter", "Lcom/embabel/agent/rag/filter/PropertyFilter;", "entityFilter", "Lcom/embabel/agent/rag/filter/EntityFilter;", "resultsListener", "Lcom/embabel/agent/rag/tools/ResultsListener;", "<init>", "(Lcom/embabel/agent/rag/service/RegexSearchOperations;Lcom/embabel/agent/rag/filter/PropertyFilter;Lcom/embabel/agent/rag/filter/EntityFilter;Lcom/embabel/agent/rag/tools/ResultsListener;)V", "", "regex", "topK", "", "searchWithFilter", "", "Lcom/embabel/common/core/types/SimilarityResult;", "Lcom/embabel/agent/rag/model/Chunk;", "Lkotlin/text/Regex;", "embabel-agent-rag-core"})
@SourceDebugExtension(value={"SMAP\nCoreSearchTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreSearchTools.kt\ncom/embabel/agent/rag/tools/RegexSearchTools\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,319:1\n27#2:320\n*S KotlinDebug\n*F\n+ 1 CoreSearchTools.kt\ncom/embabel/agent/rag/tools/RegexSearchTools\n*L\n222#1:320\n*E\n"})
public final class RegexSearchTools
implements SearchTools {
    @NotNull
    private final RegexSearchOperations regexSearch;
    @Nullable
    private final PropertyFilter metadataFilter;
    @Nullable
    private final EntityFilter entityFilter;
    @Nullable
    private final ResultsListener resultsListener;

    public RegexSearchTools(@NotNull RegexSearchOperations regexSearch, @Nullable PropertyFilter metadataFilter, @Nullable EntityFilter entityFilter, @Nullable ResultsListener resultsListener) {
        Intrinsics.checkNotNullParameter((Object)regexSearch, (String)"regexSearch");
        this.regexSearch = regexSearch;
        this.metadataFilter = metadataFilter;
        this.entityFilter = entityFilter;
        this.resultsListener = resultsListener;
    }

    public /* synthetic */ RegexSearchTools(RegexSearchOperations regexSearchOperations, PropertyFilter propertyFilter, EntityFilter entityFilter, ResultsListener resultsListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            propertyFilter = null;
        }
        if ((n & 4) != 0) {
            entityFilter = null;
        }
        if ((n & 8) != 0) {
            resultsListener = null;
        }
        this(regexSearchOperations, propertyFilter, entityFilter, resultsListener);
    }

    @LlmTool(description="Perform regex search across content elements. Specify topK")
    @NotNull
    public final String regexSearch(@NotNull String regex, int topK) {
        List<SimilarityResult<Chunk>> results;
        block0: {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            boolean $i$f$loggerFor22 = false;
            Logger logger = LoggerFactory.getLogger(RegexSearchTools.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            Object[] $i$f$loggerFor22 = new Object[]{regex, topK, this.metadataFilter, this.entityFilter};
            logger.info("Performing regex search with regex='{}', topK={}, metadataFilter={}, entityFilter={}", $i$f$loggerFor22);
            Instant start = Instant.now();
            results = this.searchWithFilter(new Regex(regex), topK);
            Duration runningTime = Duration.between(start, Instant.now());
            ResultsListener resultsListener = this.resultsListener;
            if (resultsListener == null) break block0;
            SearchTools searchTools = this;
            Intrinsics.checkNotNull((Object)runningTime);
            resultsListener.onResultsEvent(new ResultsEvent(searchTools, regex, results, runningTime, null, 16, null));
        }
        return SimpleRetrievableResultsFormatter.INSTANCE.formatResults(SimilarityResults.Companion.fromList(results));
    }

    private final List<SimilarityResult<Chunk>> searchWithFilter(Regex regex, int topK) {
        if (this.metadataFilter == null && this.entityFilter == null) {
            return this.regexSearch.regexSearch(regex, topK, Chunk.class);
        }
        if (this.regexSearch instanceof FilteringRegexSearch) {
            return ((FilteringRegexSearch)this.regexSearch).regexSearchWithFilter(regex, topK, Chunk.class, this.metadataFilter, this.entityFilter);
        }
        return PostFilteringSearch.INSTANCE.regexSearch(topK, this.metadataFilter, this.entityFilter, TopKInflationStrategy.DEFAULT, arg_0 -> RegexSearchTools.searchWithFilter$lambda$0(this, regex, arg_0));
    }

    private static final List searchWithFilter$lambda$0(RegexSearchTools this$0, Regex $regex, int inflatedTopK) {
        return this$0.regexSearch.regexSearch($regex, inflatedTopK, Chunk.class);
    }
}

