/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.service.support;

import com.embabel.agent.core.DataDictionary;
import com.embabel.agent.rag.filter.EntityFilter;
import com.embabel.agent.rag.filter.InMemoryPropertyFilter;
import com.embabel.agent.rag.filter.PropertyFilter;
import com.embabel.agent.rag.model.NamedEntityData;
import com.embabel.agent.rag.model.RelationshipDirection;
import com.embabel.agent.rag.service.NamedEntityDataRepository;
import com.embabel.agent.rag.service.RelationshipData;
import com.embabel.agent.rag.service.RetrievableIdentifier;
import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.core.types.SimilarityResult;
import com.embabel.common.core.types.TextSimilaritySearchRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J0\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J0\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0016J&\u00100\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u0002062\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\u0006\u00108\u001a\u00020\u0010H\u0016J\u0006\u00109\u001a\u00020*J\u0010\u0010>\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u0018\u0010?\u001a\u00020@2\u0006\u0010+\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u0013H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0014\u001a \u0012\u0004\u0012\u00020\u0010\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00160\u00150\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0017\u001a \u0012\u0004\u0012\u00020\u0010\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00160\u00150\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010:\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006A"}, d2={"Lcom/embabel/agent/rag/service/support/InMemoryNamedEntityDataRepository;", "Lcom/embabel/agent/rag/service/NamedEntityDataRepository;", "dataDictionary", "Lcom/embabel/agent/core/DataDictionary;", "embeddingService", "Lcom/embabel/common/ai/model/EmbeddingService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/embabel/agent/core/DataDictionary;Lcom/embabel/common/ai/model/EmbeddingService;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getDataDictionary", "()Lcom/embabel/agent/core/DataDictionary;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "entities", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/embabel/agent/rag/model/NamedEntityData;", "embeddings", "", "outgoingRelationships", "", "", "incomingRelationships", "save", "entity", "findById", "id", "vectorSearch", "", "Lcom/embabel/common/core/types/SimilarityResult;", "request", "Lcom/embabel/common/core/types/TextSimilaritySearchRequest;", "metadataFilter", "Lcom/embabel/agent/rag/filter/PropertyFilter;", "entityFilter", "Lcom/embabel/agent/rag/filter/EntityFilter;", "textSearch", "luceneSyntaxNotes", "getLuceneSyntaxNotes", "()Ljava/lang/String;", "createRelationship", "", "a", "Lcom/embabel/agent/rag/service/RetrievableIdentifier;", "b", "relationship", "Lcom/embabel/agent/rag/service/RelationshipData;", "findRelated", "source", "relationshipName", "direction", "Lcom/embabel/agent/rag/model/RelationshipDirection;", "delete", "", "findByLabel", "label", "clear", "size", "", "getSize", "()I", "buildEmbeddingText", "cosineSimilarity", "", "embabel-agent-rag-core"})
@SourceDebugExtension(value={"SMAP\nInMemoryNamedEntityDataRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryNamedEntityDataRepository.kt\ncom/embabel/agent/rag/service/support/InMemoryNamedEntityDataRepository\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,207:1\n136#2,9:208\n216#2:217\n217#2:219\n145#2:220\n1#3:218\n1#3:221\n1#3:232\n1#3:242\n1#3:260\n1062#4:222\n774#4:223\n865#4,2:224\n1557#4:226\n1628#4,3:227\n1611#4,9:250\n1863#4:259\n1864#4:261\n1620#4:262\n774#4:263\n865#4,2:264\n72#5,2:230\n72#5,2:240\n381#6,7:233\n381#6,7:243\n*S KotlinDebug\n*F\n+ 1 InMemoryNamedEntityDataRepository.kt\ncom/embabel/agent/rag/service/support/InMemoryNamedEntityDataRepository\n*L\n90#1:208,9\n90#1:217\n90#1:219\n90#1:220\n90#1:218\n128#1:232\n134#1:242\n158#1:260\n100#1:222\n110#1:223\n110#1:224,2\n114#1:226\n114#1:227,3\n158#1:250,9\n158#1:259\n158#1:261\n158#1:262\n167#1:263\n167#1:264,2\n128#1:230,2\n134#1:240,2\n129#1:233,7\n135#1:243,7\n*E\n"})
public class InMemoryNamedEntityDataRepository
implements NamedEntityDataRepository {
    @NotNull
    private final DataDictionary dataDictionary;
    @Nullable
    private final EmbeddingService embeddingService;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ConcurrentHashMap<String, NamedEntityData> entities;
    @NotNull
    private final ConcurrentHashMap<String, float[]> embeddings;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, List<String>>> outgoingRelationships;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, List<String>>> incomingRelationships;
    @NotNull
    private final String luceneSyntaxNotes;

    @JvmOverloads
    public InMemoryNamedEntityDataRepository(@NotNull DataDictionary dataDictionary, @Nullable EmbeddingService embeddingService, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)dataDictionary, (String)"dataDictionary");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.dataDictionary = dataDictionary;
        this.embeddingService = embeddingService;
        this.objectMapper = objectMapper;
        this.entities = new ConcurrentHashMap();
        this.embeddings = new ConcurrentHashMap();
        this.outgoingRelationships = new ConcurrentHashMap();
        this.incomingRelationships = new ConcurrentHashMap();
        this.luceneSyntaxNotes = "Basic substring matching only";
    }

    public /* synthetic */ InMemoryNamedEntityDataRepository(DataDictionary dataDictionary, EmbeddingService embeddingService, ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            embeddingService = null;
        }
        if ((n & 4) != 0) {
            objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
        }
        this(dataDictionary, embeddingService, objectMapper);
    }

    @Override
    @NotNull
    public DataDictionary getDataDictionary() {
        return this.dataDictionary;
    }

    @Override
    @NotNull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    @NotNull
    public NamedEntityData save(@NotNull NamedEntityData entity) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            ((Map)this.entities).put(entity.getId(), entity);
            EmbeddingService embeddingService = this.embeddingService;
            if (embeddingService == null) break block0;
            EmbeddingService service = embeddingService;
            boolean bl = false;
            String textToEmbed = this.buildEmbeddingText(entity);
            ((Map)this.embeddings).put(entity.getId(), service.embed(textToEmbed));
        }
        return entity;
    }

    @Override
    @Nullable
    public NamedEntityData findById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.entities.get(id);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SimilarityResult<NamedEntityData>> vectorSearch(@NotNull TextSimilaritySearchRequest request, @Nullable PropertyFilter metadataFilter, @Nullable EntityFilter entityFilter) {
        void $this$sortedByDescending$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        EmbeddingService embeddingService = this.embeddingService;
        if (embeddingService == null) {
            return CollectionsKt.emptyList();
        }
        EmbeddingService service = embeddingService;
        float[] queryEmbedding = service.embed(request.getQuery());
        Object $this$mapNotNull$iv = this.embeddings;
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            SimilarityResult it$iv$iv;
            NamedEntityData entity;
            double similarity;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String id = (String)entry.getKey();
            float[] embedding = (float[])entry.getValue();
            if ((this.entities.get(id) == null ? null : ((similarity = this.cosineSimilarity(queryEmbedding, embedding)) >= request.getSimilarityThreshold() ? SimilarityResult.Companion.invoke((Object)entity, similarity) : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        $this$mapNotNull$iv = InMemoryPropertyFilter.INSTANCE.filterResults(it, metadataFilter, entityFilter);
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SimilarityResult it = (SimilarityResult)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getScore());
                it = (SimilarityResult)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
            }
        }), (int)request.getTopK());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SimilarityResult<NamedEntityData>> textSearch(@NotNull TextSimilaritySearchRequest request, @Nullable PropertyFilter metadataFilter, @Nullable EntityFilter entityFilter) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        NamedEntityData entity;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Collection<NamedEntityData> collection = this.entities.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            entity = (NamedEntityData)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.contains((CharSequence)entity.getName(), (CharSequence)request.getQuery(), (boolean)true) || StringsKt.contains((CharSequence)entity.getDescription(), (CharSequence)request.getQuery(), (boolean)true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            entity = (NamedEntityData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(SimilarityResult.Companion.invoke((Object)entity, 1.0));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        return CollectionsKt.take((Iterable)InMemoryPropertyFilter.INSTANCE.filterResults(it, metadataFilter, entityFilter), (int)request.getTopK());
    }

    @Override
    @NotNull
    public String getLuceneSyntaxNotes() {
        return this.luceneSyntaxNotes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createRelationship(@NotNull RetrievableIdentifier a, @NotNull RetrievableIdentifier b, @NotNull RelationshipData relationship) {
        Object object;
        Object object2;
        Map $this$getOrPut$iv;
        boolean bl;
        Map default$iv;
        void $this$getOrPut$iv2;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)relationship, (String)"relationship");
        ConcurrentMap concurrentMap = this.outgoingRelationships;
        String key$iv = a.getId();
        boolean $i$f$getOrPut = false;
        Object object3 = $this$getOrPut$iv2.get(key$iv);
        if (object3 == null) {
            boolean bl2 = false;
            default$iv = new ConcurrentHashMap();
            bl = false;
            object3 = $this$getOrPut$iv2.putIfAbsent(key$iv, default$iv);
            if (object3 == null) {
                object3 = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object3, (String)"getOrPut(...)");
        Map map = (Map)object3;
        Object key$iv2 = relationship.getName();
        boolean $i$f$getOrPut2 = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv2);
        if (value$iv == null) {
            boolean bl3 = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv2, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        ((List)object2).add(b.getId());
        key$iv2 = this.incomingRelationships;
        key$iv = b.getId();
        $i$f$getOrPut = false;
        Object object4 = $this$getOrPut$iv2.get(key$iv);
        if (object4 == null) {
            boolean bl4 = false;
            default$iv = new ConcurrentHashMap();
            bl = false;
            object4 = $this$getOrPut$iv2.putIfAbsent(key$iv, default$iv);
            if (object4 == null) {
                object4 = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object4, (String)"getOrPut(...)");
        $this$getOrPut$iv = (Map)object4;
        key$iv2 = relationship.getName();
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(key$iv2);
        if (value$iv == null) {
            boolean bl5 = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(a.getId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<NamedEntityData> findRelated(@NotNull RetrievableIdentifier source, @NotNull String relationshipName, @NotNull RelationshipDirection direction) {
        void $this$mapNotNullTo$iv$iv;
        Iterable<String> outgoing;
        Map<String, List<String>> map;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)relationshipName, (String)"relationshipName");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        String entityId = source.getId();
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                map = this.outgoingRelationships.get(entityId);
                if (map != null && (map = map.get(relationshipName)) != null) break;
                map = CollectionsKt.emptyList();
                break;
            }
            case 2: {
                map = this.incomingRelationships.get(entityId);
                if (map != null && (map = (List)map.get(relationshipName)) != null) break;
                map = CollectionsKt.emptyList();
                break;
            }
            case 3: {
                List<String> list;
                Object object = this.outgoingRelationships.get(entityId);
                if (object == null || (object = object.get(relationshipName)) == null) {
                    object = outgoing = CollectionsKt.emptyList();
                }
                if ((list = this.incomingRelationships.get(entityId)) == null || (list = list.get(relationshipName)) == null) {
                    list = CollectionsKt.emptyList();
                }
                List<String> incoming = list;
                map = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)outgoing, (Iterable)incoming));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List relatedIds = map;
        Iterable $this$mapNotNull$iv = relatedIds;
        boolean $i$f$mapNotNull = false;
        outgoing = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NamedEntityData it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.entities.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean delete(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.embeddings.remove(id);
        return this.entities.remove(id) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<NamedEntityData> findByLabel(@NotNull String label) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Collection<NamedEntityData> collection = this.entities.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NamedEntityData it = (NamedEntityData)element$iv$iv;
            boolean bl = false;
            if (!it.labels().contains(label)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void clear() {
        this.entities.clear();
        this.embeddings.clear();
        this.outgoingRelationships.clear();
        this.incomingRelationships.clear();
    }

    public final int getSize() {
        return this.entities.size();
    }

    private final String buildEmbeddingText(NamedEntityData entity) {
        Object[] objectArray = new String[]{entity.getName(), entity.getDescription()};
        List parts = CollectionsKt.mutableListOf((Object[])objectArray);
        parts.addAll((Collection)entity.labels());
        return CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final double cosineSimilarity(float[] a, float[] b) {
        if (a.length != b.length) {
            return 0.0;
        }
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            dotProduct += (double)(a[i] * b[i]);
            normA += (double)(a[i] * a[i]);
            normB += (double)(b[i] * b[i]);
        }
        double denominator = Math.sqrt(normA) * Math.sqrt(normB);
        return denominator == 0.0 ? 0.0 : dotProduct / denominator;
    }

    @JvmOverloads
    public InMemoryNamedEntityDataRepository(@NotNull DataDictionary dataDictionary, @Nullable EmbeddingService embeddingService) {
        Intrinsics.checkNotNullParameter((Object)dataDictionary, (String)"dataDictionary");
        this(dataDictionary, embeddingService, null, 4, null);
    }

    @JvmOverloads
    public InMemoryNamedEntityDataRepository(@NotNull DataDictionary dataDictionary) {
        Intrinsics.checkNotNullParameter((Object)dataDictionary, (String)"dataDictionary");
        this(dataDictionary, null, null, 6, null);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RelationshipDirection.values().length];
            try {
                nArray[RelationshipDirection.OUTGOING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipDirection.INCOMING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipDirection.BOTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

