/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.ingestion;

import com.embabel.agent.rag.ingestion.ChunkTransformationContext;
import com.embabel.agent.rag.ingestion.ChunkTransformer;
import com.embabel.agent.rag.ingestion.ContentChunker;
import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.model.ContentRoot;
import com.embabel.agent.rag.model.LeafSection;
import com.embabel.agent.rag.model.NavigableContainerSection;
import com.embabel.agent.rag.model.Section;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011J&\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00112\u0006\u0010\u001f\u001a\u00020 H\u0002J,\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\"\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00112\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00110\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0011H\u0002J.\u0010$\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0002J(\u0010'\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0002J.\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010*\u001a\u00020&H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020 0\u00112\u0006\u0010,\u001a\u00020 H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020 0\u00112\u0006\u0010,\u001a\u00020 H\u0002J\u0010\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u00060"}, d2={"Lcom/embabel/agent/rag/ingestion/InMemoryContentChunker;", "Lcom/embabel/agent/rag/ingestion/ContentChunker;", "config", "Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;", "chunkTransformer", "Lcom/embabel/agent/rag/ingestion/ChunkTransformer;", "<init>", "(Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;Lcom/embabel/agent/rag/ingestion/ChunkTransformer;)V", "getConfig", "()Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;", "getChunkTransformer", "()Lcom/embabel/agent/rag/ingestion/ChunkTransformer;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "chunk", "", "Lcom/embabel/agent/rag/model/Chunk;", "section", "Lcom/embabel/agent/rag/model/NavigableContainerSection;", "applyTransformer", "chunks", "Lcom/embabel/agent/rag/model/Section;", "document", "Lcom/embabel/agent/rag/model/ContentRoot;", "splitSections", "sections", "createSingleChunkFromContainer", "leaves", "Lcom/embabel/agent/rag/model/LeafSection;", "rootId", "", "chunkLeavesIntelligently", "containerSection", "groupLeavesForOptimalChunking", "createCombinedLeafChunk", "sequenceNumber", "", "createSingleLeafChunk", "leaf", "splitLeafIntoMultipleChunks", "startingSequenceNumber", "splitText", "text", "splitBySentences", "getOverlapText", "previousChunk", "embabel-agent-rag-core"})
@SourceDebugExtension(value={"SMAP\nInMemoryContentChunker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryContentChunker.kt\ncom/embabel/agent/rag/ingestion/InMemoryContentChunker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,441:1\n1#2:442\n1557#3:443\n1628#3,3:444\n1368#3:447\n1454#3,5:448\n774#3:453\n865#3,2:454\n1872#3,3:456\n774#3:459\n865#3,2:460\n1368#3:462\n1454#3,2:463\n774#3:465\n865#3,2:466\n1456#3,3:468\n774#3:471\n865#3,2:472\n774#3:474\n865#3,2:475\n1368#3:477\n1454#3,2:478\n774#3:480\n865#3,2:481\n1456#3,3:483\n774#3:486\n865#3,2:487\n*S KotlinDebug\n*F\n+ 1 InMemoryContentChunker.kt\ncom/embabel/agent/rag/ingestion/InMemoryContentChunker\n*L\n86#1:443\n86#1:444,3\n93#1:447\n93#1:448,5\n262#1:453\n262#1:454,2\n266#1:456,3\n291#1:459\n291#1:460,2\n354#1:462\n354#1:463,2\n359#1:465\n359#1:466,2\n354#1:468,3\n361#1:471\n361#1:472,2\n371#1:474\n371#1:475,2\n404#1:477\n404#1:478,2\n409#1:480\n409#1:481,2\n404#1:483,3\n411#1:486\n411#1:487,2\n*E\n"})
public final class InMemoryContentChunker
implements ContentChunker {
    @NotNull
    private final ContentChunker.Config config;
    @NotNull
    private final ChunkTransformer chunkTransformer;
    private final Logger logger;

    public InMemoryContentChunker(@NotNull ContentChunker.Config config, @NotNull ChunkTransformer chunkTransformer) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)chunkTransformer, (String)"chunkTransformer");
        this.config = config;
        this.chunkTransformer = chunkTransformer;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ InMemoryContentChunker(ContentChunker.Config config, ChunkTransformer chunkTransformer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = new ContentChunker.Config(0, 0, 0, 7, null);
        }
        if ((n & 2) != 0) {
            chunkTransformer = ChunkTransformer.NO_OP;
        }
        this(config, chunkTransformer);
    }

    @NotNull
    public final ContentChunker.Config getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public ChunkTransformer getChunkTransformer() {
        return this.chunkTransformer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Chunk> chunk(@NotNull NavigableContainerSection section) {
        List list;
        ContentRoot document;
        String string;
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        List leaves2 = CollectionsKt.toList(section.leaves());
        Iterable iterable = leaves2;
        int n = 0;
        for (Object object : iterable) {
            void it;
            LeafSection leafSection = (LeafSection)object;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getContent().length() + it.getTitle().length() + 1;
            n = n2 + n3;
        }
        int totalContentLength = n;
        if (section instanceof ContentRoot) {
            string = section.getId();
        } else {
            Object object = section.getMetadata().get("root_document_id");
            string = object instanceof String ? (String)object : null;
            if (string == null) {
                string = section.getId();
            }
        }
        String rootId = string;
        ContentRoot contentRoot = document = section instanceof ContentRoot ? (ContentRoot)((Object)section) : null;
        if (totalContentLength <= this.config.getMaxChunkSize()) {
            Object object;
            object = new Object[]{section.getTitle(), leaves2.size(), totalContentLength, this.config.getMaxChunkSize()};
            this.logger.debug("Creating single chunk for container section '{}' with {} leaves (total length: {} <= max: {})", object);
            list = CollectionsKt.listOf((Object)this.createSingleChunkFromContainer(section, leaves2, rootId));
        } else {
            this.logger.debug("Total content ({} chars) exceeds maxChunkSize ({}), attempting intelligent grouping", (Object)totalContentLength, (Object)this.config.getMaxChunkSize());
            list = this.chunkLeavesIntelligently(section, leaves2, rootId);
        }
        List chunks = list;
        return this.applyTransformer(chunks, section, document);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Chunk> applyTransformer(List<? extends Chunk> chunks, Section section, ContentRoot document) {
        void $this$mapTo$iv$iv;
        ChunkTransformationContext context = new ChunkTransformationContext(section, document);
        Iterable $this$map$iv = chunks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void chunk;
            Chunk chunk2 = (Chunk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getChunkTransformer().transform((Chunk)chunk, context));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Chunk> splitSections(@NotNull List<? extends NavigableContainerSection> sections) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sections, (String)"sections");
        Iterable $this$flatMap$iv = sections;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NavigableContainerSection it = (NavigableContainerSection)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.chunk(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Chunk createSingleChunkFromContainer(NavigableContainerSection section, List<LeafSection> leaves2, String rootId) {
        String combinedContent = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)leaves2, (CharSequence)"\n\n", null, null, (int)0, null, InMemoryContentChunker::createSingleChunkFromContainer$lambda$3, (int)30, null))).toString();
        Map combinedMetadata = new LinkedHashMap();
        combinedMetadata.putAll(section.getMetadata());
        combinedMetadata.put("root_document_id", rootId);
        combinedMetadata.put("container_section_id", section.getId());
        combinedMetadata.put("container_section_title", section.getTitle());
        combinedMetadata.put("container_section_url", section.getUri());
        combinedMetadata.put("chunk_index", 0);
        combinedMetadata.put("total_chunks", 1);
        combinedMetadata.put("sequence_number", 0);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Chunk.Companion.invoke(string, combinedContent, combinedMetadata, section.getId());
    }

    private final List<Chunk> chunkLeavesIntelligently(NavigableContainerSection containerSection, List<LeafSection> leaves2, String rootId) {
        List allChunks = new ArrayList();
        List<List<LeafSection>> leafGroups = this.groupLeavesForOptimalChunking(leaves2);
        int sequenceNumber = 0;
        this.logger.debug("Grouped {} leaves into {} groups for chunking", (Object)leaves2.size(), (Object)leafGroups.size());
        for (List<LeafSection> group : leafGroups) {
            boolean bl;
            if (group.size() == 1) {
                LeafSection leaf = (LeafSection)CollectionsKt.first(group);
                int leafContentSize = leaf.getContent().length() + leaf.getTitle().length() + 1;
                if (leafContentSize <= this.config.getMaxChunkSize()) {
                    bl = allChunks.add(this.createSingleLeafChunk(containerSection, leaf, rootId, sequenceNumber++));
                    continue;
                }
                List<Chunk> chunks = this.splitLeafIntoMultipleChunks(containerSection, leaf, rootId, sequenceNumber);
                sequenceNumber += chunks.size();
                bl = allChunks.addAll((Collection)chunks);
                continue;
            }
            bl = allChunks.add(this.createCombinedLeafChunk(containerSection, group, rootId, sequenceNumber++));
        }
        return allChunks;
    }

    private final List<List<LeafSection>> groupLeavesForOptimalChunking(List<LeafSection> leaves2) {
        List groups = new ArrayList();
        List currentGroup = new ArrayList();
        int currentGroupSize = 0;
        for (LeafSection leaf : leaves2) {
            int leafSize = leaf.getContent().length() + leaf.getTitle().length() + 1;
            if (!((Collection)currentGroup).isEmpty() && currentGroupSize + leafSize + 2 > this.config.getMaxChunkSize()) {
                groups.add(CollectionsKt.toList((Iterable)currentGroup));
                currentGroup.clear();
                currentGroupSize = 0;
            }
            if (leafSize > this.config.getMaxChunkSize()) {
                if (!((Collection)currentGroup).isEmpty()) {
                    groups.add(CollectionsKt.toList((Iterable)currentGroup));
                    currentGroup.clear();
                    currentGroupSize = 0;
                }
                groups.add(CollectionsKt.listOf((Object)leaf));
                continue;
            }
            currentGroup.add(leaf);
            currentGroupSize += leafSize + 2;
        }
        if (!((Collection)currentGroup).isEmpty()) {
            groups.add(CollectionsKt.toList((Iterable)currentGroup));
        }
        return groups;
    }

    private final Chunk createCombinedLeafChunk(NavigableContainerSection containerSection, List<LeafSection> leaves2, String rootId, int sequenceNumber) {
        String combinedContent = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)leaves2, (CharSequence)"\n\n", null, null, (int)0, null, InMemoryContentChunker::createCombinedLeafChunk$lambda$4, (int)30, null))).toString();
        Map combinedMetadata = new LinkedHashMap();
        combinedMetadata.putAll(containerSection.getMetadata());
        combinedMetadata.put("root_document_id", rootId);
        combinedMetadata.put("container_section_id", containerSection.getId());
        combinedMetadata.put("container_section_title", containerSection.getTitle());
        combinedMetadata.put("container_section_url", containerSection.getUri());
        combinedMetadata.put("chunk_index", 0);
        combinedMetadata.put("total_chunks", 1);
        Integer n = sequenceNumber;
        combinedMetadata.put("sequence_number", n);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Chunk.Companion.invoke(string, combinedContent, combinedMetadata, containerSection.getId());
    }

    private final Chunk createSingleLeafChunk(NavigableContainerSection containerSection, LeafSection leaf, String rootId, int sequenceNumber) {
        String content = !StringsKt.isBlank((CharSequence)leaf.getTitle()) ? leaf.getTitle() + "\n" + leaf.getContent() : leaf.getContent();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"root_document_id", (Object)rootId), TuplesKt.to((Object)"container_section_id", (Object)containerSection.getId()), TuplesKt.to((Object)"container_section_title", (Object)containerSection.getTitle()), TuplesKt.to((Object)"leaf_section_id", (Object)leaf.getId()), TuplesKt.to((Object)"leaf_section_title", (Object)leaf.getTitle()), TuplesKt.to((Object)"leaf_section_url", (Object)leaf.getUri()), TuplesKt.to((Object)"chunk_index", (Object)0), TuplesKt.to((Object)"total_chunks", (Object)1), TuplesKt.to((Object)"sequence_number", (Object)sequenceNumber)};
        return Chunk.Companion.invoke(string, ((Object)StringsKt.trim((CharSequence)content)).toString(), MapsKt.plus(leaf.getMetadata(), (Map)MapsKt.mapOf((Pair[])pairArray)), leaf.getId());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Chunk> splitLeafIntoMultipleChunks(NavigableContainerSection containerSection, LeafSection leaf, String rootId, int startingSequenceNumber) {
        void $this$filterTo$iv$iv;
        List chunks = new ArrayList();
        String fullContent = !StringsKt.isBlank((CharSequence)leaf.getTitle()) ? leaf.getTitle() + "\n" + leaf.getContent() : leaf.getContent();
        Iterable $this$filter$iv = this.splitText(((Object)StringsKt.trim((CharSequence)fullContent)).toString());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List textChunks = (List)destination$iv$iv;
        this.logger.debug("Split leaf section '{}' into {} text chunks", (Object)leaf.getTitle(), (Object)textChunks.size());
        Iterable $this$forEachIndexed$iv = textChunks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void textChunk;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (String)item$iv;
            int index = n;
            boolean bl = false;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"root_document_id", (Object)rootId), TuplesKt.to((Object)"container_section_id", (Object)containerSection.getId()), TuplesKt.to((Object)"container_section_title", (Object)containerSection.getTitle()), TuplesKt.to((Object)"leaf_section_id", (Object)leaf.getId()), TuplesKt.to((Object)"leaf_section_title", (Object)leaf.getTitle()), TuplesKt.to((Object)"leaf_section_url", (Object)leaf.getUri()), TuplesKt.to((Object)"chunk_index", (Object)index), TuplesKt.to((Object)"total_chunks", (Object)textChunks.size()), TuplesKt.to((Object)"sequence_number", (Object)(startingSequenceNumber + index))};
            Chunk chunk = Chunk.Companion.invoke(string, ((Object)StringsKt.trim((CharSequence)((CharSequence)textChunk))).toString(), MapsKt.plus(leaf.getMetadata(), (Map)MapsKt.mapOf((Pair[])pairArray)), leaf.getId());
            chunks.add(chunk);
        }
        return chunks;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitText(String text) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Iterator $this$filterTo$iv$iv2;
        String[] stringArray = new String[]{"\n\n"};
        Iterable $this$filter$iv2 = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator<String> iterator = $this$filterTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List paragraphs = (List)destination$iv$iv;
        List chunks = new ArrayList();
        StringBuilder currentChunk = new StringBuilder();
        for (String paragraph : paragraphs) {
            if (((CharSequence)currentChunk).length() > 0 && currentChunk.length() + paragraph.length() + 2 > this.config.getMaxChunkSize()) {
                String overlap;
                String string = currentChunk.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                currentChunk = new StringBuilder();
                if (!((Collection)chunks).isEmpty() && ((CharSequence)(overlap = this.getOverlapText((String)CollectionsKt.last((List)chunks)))).length() > 0 && overlap.length() + paragraph.length() + 2 <= this.config.getMaxChunkSize()) {
                    currentChunk.append(overlap).append("\n\n");
                }
            }
            if (paragraph.length() > this.config.getMaxChunkSize()) {
                List<String> sentenceChunks = this.splitBySentences(paragraph);
                for (String sentenceChunk : sentenceChunks) {
                    if (((CharSequence)currentChunk).length() > 0 && currentChunk.length() + sentenceChunk.length() + 2 > this.config.getMaxChunkSize()) {
                        String overlap;
                        String string = currentChunk.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                        currentChunk = new StringBuilder();
                        if (!((Collection)chunks).isEmpty() && ((CharSequence)(overlap = this.getOverlapText((String)CollectionsKt.last((List)chunks)))).length() > 0 && overlap.length() + sentenceChunk.length() + 2 <= this.config.getMaxChunkSize()) {
                            currentChunk.append(overlap).append("\n\n");
                        }
                    }
                    if (((CharSequence)currentChunk).length() > 0) {
                        currentChunk.append("\n\n");
                    }
                    currentChunk.append(sentenceChunk);
                }
                continue;
            }
            if (((CharSequence)currentChunk).length() > 0) {
                currentChunk.append("\n\n");
            }
            currentChunk.append(paragraph);
        }
        if (((CharSequence)currentChunk).length() > 0) {
            String string = currentChunk.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
        }
        Iterable $this$flatMap$iv = chunks;
        boolean $i$f$flatMap = false;
        iterator = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String chunk = (String)element$iv$iv;
            boolean bl = false;
            if (chunk.length() <= this.config.getMaxChunkSize()) {
                list = CollectionsKt.listOf((Object)chunk);
            } else {
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv3 = StringsKt.chunked((CharSequence)chunk, (int)this.config.getMaxChunkSize());
                boolean $i$f$filter2 = false;
                Iterable iterable2 = $this$filter$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                    String it = (String)element$iv$iv2;
                    boolean bl3 = false;
                    boolean bl4 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                    if (!bl4) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                list = (List)destination$iv$iv3;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$filter3 = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl5 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl5) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List finalChunks = (List)destination$iv$iv2;
        Collection collection2 = finalChunks;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = ((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString()).length() > 0 ? CollectionsKt.listOf((Object)((Object)StringsKt.trim((CharSequence)text)).toString()) : CollectionsKt.emptyList();
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitBySentences(String text) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Iterator $this$filterTo$iv$iv2;
        CharSequence charSequence = text;
        Regex regex = new Regex("(?<=[.!?])\\s+");
        int n = 0;
        Iterable $this$filter$iv2 = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Object object = $this$filterTo$iv$iv2.iterator();
        while (object.hasNext()) {
            Object element$iv$iv = object.next();
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sentences = (List)destination$iv$iv;
        List chunks = new ArrayList();
        StringBuilder currentChunk = new StringBuilder();
        for (String sentence : sentences) {
            if (((CharSequence)currentChunk).length() > 0 && currentChunk.length() + sentence.length() + 1 > this.config.getMaxChunkSize()) {
                String overlap;
                String string = currentChunk.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                currentChunk = new StringBuilder();
                if (!((Collection)chunks).isEmpty() && ((CharSequence)(overlap = this.getOverlapText((String)CollectionsKt.last((List)chunks)))).length() > 0 && overlap.length() + sentence.length() + 1 <= this.config.getMaxChunkSize()) {
                    currentChunk.append(overlap).append(" ");
                }
            }
            if (((CharSequence)currentChunk).length() > 0) {
                currentChunk.append(" ");
            }
            currentChunk.append(sentence);
        }
        if (((CharSequence)currentChunk).length() > 0) {
            String string = currentChunk.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
        }
        Iterable $this$flatMap$iv = chunks;
        boolean $i$f$flatMap = false;
        object = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String chunk = (String)element$iv$iv;
            boolean bl = false;
            if (chunk.length() <= this.config.getMaxChunkSize()) {
                list = CollectionsKt.listOf((Object)chunk);
            } else {
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv3 = StringsKt.chunked((CharSequence)chunk, (int)this.config.getMaxChunkSize());
                boolean $i$f$filter2 = false;
                Iterable iterable2 = $this$filter$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                    String it = (String)element$iv$iv2;
                    boolean bl3 = false;
                    boolean bl4 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                    if (!bl4) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                list = (List)destination$iv$iv3;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$filter3 = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl5 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl5) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List finalChunks = (List)destination$iv$iv2;
        Collection collection2 = finalChunks;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = ((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString()).length() > 0 ? CollectionsKt.listOf((Object)((Object)StringsKt.trim((CharSequence)text)).toString()) : CollectionsKt.emptyList();
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    private final String getOverlapText(String previousChunk) {
        String string;
        if (previousChunk.length() <= this.config.getOverlapSize()) {
            return "";
        }
        String overlap = StringsKt.takeLast((String)previousChunk, (int)this.config.getOverlapSize());
        int sentenceStart = StringsKt.indexOf$default((CharSequence)overlap, (String)". ", (int)0, (boolean)false, (int)6, null) + 2;
        if (sentenceStart > 1 && sentenceStart < overlap.length()) {
            String string2 = overlap.substring(sentenceStart);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            String[] stringArray = new String[]{" "};
            List words = StringsKt.split$default((CharSequence)overlap, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            string = words.size() > 1 ? CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)words, (int)1), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) : "";
        }
        return string;
    }

    private static final CharSequence createSingleChunkFromContainer$lambda$3(LeafSection leaf) {
        Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
        return !StringsKt.isBlank((CharSequence)leaf.getTitle()) ? (CharSequence)(leaf.getTitle() + "\n" + leaf.getContent()) : (CharSequence)leaf.getContent();
    }

    private static final CharSequence createCombinedLeafChunk$lambda$4(LeafSection leaf) {
        Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
        return !StringsKt.isBlank((CharSequence)leaf.getTitle()) ? (CharSequence)(leaf.getTitle() + "\n" + leaf.getContent()) : (CharSequence)leaf.getContent();
    }

    public InMemoryContentChunker() {
        this(null, null, 3, null);
    }
}

