/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.tools;

import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.service.RegexSearchOperations;
import com.embabel.agent.rag.service.SimilarityResults;
import com.embabel.agent.rag.service.SimpleRetrievableResultsFormatter;
import com.embabel.agent.rag.tools.ResultsEvent;
import com.embabel.agent.rag.tools.ResultsListener;
import com.embabel.agent.rag.tools.SearchTools;
import com.embabel.common.core.types.SimilarityResult;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.annotation.Tool;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/embabel/agent/rag/tools/RegexSearchTools;", "Lcom/embabel/agent/rag/tools/SearchTools;", "textSearch", "Lcom/embabel/agent/rag/service/RegexSearchOperations;", "resultsListener", "Lcom/embabel/agent/rag/tools/ResultsListener;", "<init>", "(Lcom/embabel/agent/rag/service/RegexSearchOperations;Lcom/embabel/agent/rag/tools/ResultsListener;)V", "regexSearch", "", "regex", "topK", "", "embabel-agent-rag-core"})
@SourceDebugExtension(value={"SMAP\nToolishRag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolishRag.kt\ncom/embabel/agent/rag/tools/RegexSearchTools\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,293:1\n27#2:294\n*S KotlinDebug\n*F\n+ 1 ToolishRag.kt\ncom/embabel/agent/rag/tools/RegexSearchTools\n*L\n276#1:294\n*E\n"})
public final class RegexSearchTools
implements SearchTools {
    @NotNull
    private final RegexSearchOperations textSearch;
    @Nullable
    private final ResultsListener resultsListener;

    public RegexSearchTools(@NotNull RegexSearchOperations textSearch, @Nullable ResultsListener resultsListener) {
        Intrinsics.checkNotNullParameter((Object)textSearch, (String)"textSearch");
        this.textSearch = textSearch;
        this.resultsListener = resultsListener;
    }

    public /* synthetic */ RegexSearchTools(RegexSearchOperations regexSearchOperations, ResultsListener resultsListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            resultsListener = null;
        }
        this(regexSearchOperations, resultsListener);
    }

    @Tool(description="Perform regex search across content elements. Specify topK")
    @NotNull
    public final String regexSearch(@NotNull String regex, int topK) {
        List<SimilarityResult<Chunk>> results;
        block0: {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            boolean $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(RegexSearchTools.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.info("Performing regex search with regex='{}', topK={}", (Object)regex, (Object)topK);
            Instant start = Instant.now();
            results = this.textSearch.regexSearch(new Regex(regex), topK, Chunk.class);
            Duration runningTime = Duration.between(start, Instant.now());
            ResultsListener resultsListener = this.resultsListener;
            if (resultsListener == null) break block0;
            SearchTools searchTools = this;
            Intrinsics.checkNotNull((Object)runningTime);
            resultsListener.onResultsEvent(new ResultsEvent(searchTools, regex, results, runningTime, null, 16, null));
        }
        return SimpleRetrievableResultsFormatter.INSTANCE.formatResults(SimilarityResults.Companion.fromList(results));
    }
}

