/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.service;

import com.embabel.agent.api.common.PromptRunner;
import com.embabel.agent.rag.service.RagResponse;
import com.embabel.agent.rag.service.RagResponseSummarizer;
import com.embabel.agent.rag.tools.DualShotConfig;
import com.embabel.agent.rag.tools.RagOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/embabel/agent/rag/service/PromptRunnerRagResponseSummarizer;", "Lcom/embabel/agent/rag/service/RagResponseSummarizer;", "promptRunner", "Lcom/embabel/agent/api/common/PromptRunner;", "options", "Lcom/embabel/agent/rag/tools/RagOptions;", "<init>", "(Lcom/embabel/agent/api/common/PromptRunner;Lcom/embabel/agent/rag/tools/RagOptions;)V", "getPromptRunner", "()Lcom/embabel/agent/api/common/PromptRunner;", "getOptions", "()Lcom/embabel/agent/rag/tools/RagOptions;", "summarize", "", "ragResponse", "Lcom/embabel/agent/rag/service/RagResponse;", "embabel-agent-rag-core"})
public final class PromptRunnerRagResponseSummarizer
implements RagResponseSummarizer {
    @NotNull
    private final PromptRunner promptRunner;
    @NotNull
    private final RagOptions options;

    public PromptRunnerRagResponseSummarizer(@NotNull PromptRunner promptRunner, @NotNull RagOptions options) {
        Intrinsics.checkNotNullParameter((Object)promptRunner, (String)"promptRunner");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.promptRunner = promptRunner;
        this.options = options;
    }

    @NotNull
    public final PromptRunner getPromptRunner() {
        return this.promptRunner;
    }

    @NotNull
    public final RagOptions getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public String summarize(@NotNull RagResponse ragResponse) {
        Intrinsics.checkNotNullParameter((Object)ragResponse, (String)"ragResponse");
        DualShotConfig dualShotConfig = this.options.getDualShot();
        return this.promptRunner.withId("summarizer").generateText(StringsKt.trimIndent((String)("\n                Summarize the following information provided as context to answer a question.\n                Limit the summary to approximately " + (dualShotConfig != null ? dualShotConfig.getSummaryWords() : 100) + " words.\n                <query>" + ragResponse.getRequest().getQuery() + "</query>\n                <context>\n                " + this.options.getRagResponseFormatter().format(ragResponse) + "\n                </context>\n            ")));
    }
}

