/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.ingestion;

import com.embabel.agent.rag.ingestion.ContentChunker;
import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.model.ContentRoot;
import com.embabel.agent.rag.model.LeafSection;
import com.embabel.agent.rag.model.NavigableContainerSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\rJ&\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J,\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0019\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\r0\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0002J.\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001dH\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\u0006\u0010#\u001a\u00020\u0017H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\u0006\u0010#\u001a\u00020\u0017H\u0002J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0017H\u0002J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006*"}, d2={"Lcom/embabel/agent/rag/ingestion/InMemoryContentChunker;", "Lcom/embabel/agent/rag/ingestion/ContentChunker;", "config", "Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;", "<init>", "(Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;)V", "getConfig", "()Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "chunk", "", "Lcom/embabel/agent/rag/model/Chunk;", "section", "Lcom/embabel/agent/rag/model/NavigableContainerSection;", "splitSections", "sections", "createSingleChunkFromContainer", "leaves", "Lcom/embabel/agent/rag/model/LeafSection;", "rootId", "", "chunkLeavesIntelligently", "containerSection", "groupLeavesForOptimalChunking", "createCombinedLeafChunk", "sequenceNumber", "", "createSingleLeafChunk", "leaf", "splitLeafIntoMultipleChunks", "startingSequenceNumber", "splitText", "text", "splitBySentences", "getOverlapText", "previousChunk", "prependSectionTitle", "content", "sectionTitle", "embabel-agent-rag-core"})
@SourceDebugExtension(value={"SMAP\nInMemoryContentChunker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryContentChunker.kt\ncom/embabel/agent/rag/ingestion/InMemoryContentChunker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,448:1\n1#2:449\n1368#3:450\n1454#3,5:451\n774#3:456\n865#3,2:457\n1872#3,3:459\n774#3:462\n865#3,2:463\n1368#3:465\n1454#3,2:466\n774#3:468\n865#3,2:469\n1456#3,3:471\n774#3:474\n865#3,2:475\n774#3:477\n865#3,2:478\n1368#3:480\n1454#3,2:481\n774#3:483\n865#3,2:484\n1456#3,3:486\n774#3:489\n865#3,2:490\n*S KotlinDebug\n*F\n+ 1 InMemoryContentChunker.kt\ncom/embabel/agent/rag/ingestion/InMemoryContentChunker\n*L\n73#1:450\n73#1:451,5\n249#1:456\n249#1:457,2\n253#1:459,3\n278#1:462\n278#1:463,2\n341#1:465\n341#1:466,2\n346#1:468\n346#1:469,2\n341#1:471,3\n348#1:474\n348#1:475,2\n358#1:477\n358#1:478,2\n391#1:480\n391#1:481,2\n396#1:483\n396#1:484,2\n391#1:486,3\n398#1:489\n398#1:490,2\n*E\n"})
public final class InMemoryContentChunker
implements ContentChunker {
    @NotNull
    private final ContentChunker.Config config;
    private final Logger logger;

    public InMemoryContentChunker(@NotNull ContentChunker.Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ InMemoryContentChunker(ContentChunker.Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = new ContentChunker.DefaultConfig(0, 0, false, 7, null);
        }
        this(config);
    }

    @NotNull
    public final ContentChunker.Config getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Chunk> chunk(@NotNull NavigableContainerSection section) {
        String rootId;
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        List leaves2 = CollectionsKt.toList(section.leaves());
        Iterable iterable = leaves2;
        int n = 0;
        for (Object t : iterable) {
            void it;
            LeafSection leafSection = (LeafSection)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getContent().length() + it.getTitle().length() + 1;
            n = n2 + n3;
        }
        int totalContentLength = n;
        if (section instanceof ContentRoot) {
            v0 = section.getId();
        } else {
            Object object = section.getMetadata().get("root_document_id");
            v0 = object instanceof String ? (String)object : null;
            if (v0 == null) {
                v0 = rootId = section.getId();
            }
        }
        if (totalContentLength <= this.config.getMaxChunkSize()) {
            Object[] objectArray = new Object[]{section.getTitle(), leaves2.size(), totalContentLength, this.config.getMaxChunkSize()};
            this.logger.debug("Creating single chunk for container section '{}' with {} leaves (total length: {} <= max: {})", objectArray);
            return CollectionsKt.listOf((Object)this.createSingleChunkFromContainer(section, leaves2, rootId));
        }
        this.logger.debug("Total content ({} chars) exceeds maxChunkSize ({}), attempting intelligent grouping", (Object)totalContentLength, (Object)this.config.getMaxChunkSize());
        return this.chunkLeavesIntelligently(section, leaves2, rootId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Chunk> splitSections(@NotNull List<? extends NavigableContainerSection> sections) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sections, (String)"sections");
        Iterable $this$flatMap$iv = sections;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NavigableContainerSection it = (NavigableContainerSection)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.chunk(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Chunk createSingleChunkFromContainer(NavigableContainerSection section, List<LeafSection> leaves2, String rootId) {
        String combinedContent = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)leaves2, (CharSequence)"\n\n", null, null, (int)0, null, InMemoryContentChunker::createSingleChunkFromContainer$lambda$2, (int)30, null))).toString();
        String contentWithSectionTitle = this.prependSectionTitle(combinedContent, section.getTitle());
        Map combinedMetadata = new LinkedHashMap();
        combinedMetadata.putAll(section.getMetadata());
        combinedMetadata.put("root_document_id", rootId);
        combinedMetadata.put("container_section_id", section.getId());
        combinedMetadata.put("container_section_title", section.getTitle());
        combinedMetadata.put("container_section_url", section.getUri());
        combinedMetadata.put("chunk_index", 0);
        combinedMetadata.put("total_chunks", 1);
        combinedMetadata.put("sequence_number", 0);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Chunk.Companion.invoke(string, contentWithSectionTitle, combinedMetadata, section.getId());
    }

    private final List<Chunk> chunkLeavesIntelligently(NavigableContainerSection containerSection, List<LeafSection> leaves2, String rootId) {
        List allChunks = new ArrayList();
        List<List<LeafSection>> leafGroups = this.groupLeavesForOptimalChunking(leaves2);
        int sequenceNumber = 0;
        this.logger.debug("Grouped {} leaves into {} groups for chunking", (Object)leaves2.size(), (Object)leafGroups.size());
        for (List<LeafSection> group : leafGroups) {
            boolean bl;
            if (group.size() == 1) {
                LeafSection leaf = (LeafSection)CollectionsKt.first(group);
                int leafContentSize = leaf.getContent().length() + leaf.getTitle().length() + 1;
                if (leafContentSize <= this.config.getMaxChunkSize()) {
                    bl = allChunks.add(this.createSingleLeafChunk(containerSection, leaf, rootId, sequenceNumber++));
                    continue;
                }
                List<Chunk> chunks = this.splitLeafIntoMultipleChunks(containerSection, leaf, rootId, sequenceNumber);
                sequenceNumber += chunks.size();
                bl = allChunks.addAll((Collection)chunks);
                continue;
            }
            bl = allChunks.add(this.createCombinedLeafChunk(containerSection, group, rootId, sequenceNumber++));
        }
        return allChunks;
    }

    private final List<List<LeafSection>> groupLeavesForOptimalChunking(List<LeafSection> leaves2) {
        List groups = new ArrayList();
        List currentGroup = new ArrayList();
        int currentGroupSize = 0;
        for (LeafSection leaf : leaves2) {
            int leafSize = leaf.getContent().length() + leaf.getTitle().length() + 1;
            if (!((Collection)currentGroup).isEmpty() && currentGroupSize + leafSize + 2 > this.config.getMaxChunkSize()) {
                groups.add(CollectionsKt.toList((Iterable)currentGroup));
                currentGroup.clear();
                currentGroupSize = 0;
            }
            if (leafSize > this.config.getMaxChunkSize()) {
                if (!((Collection)currentGroup).isEmpty()) {
                    groups.add(CollectionsKt.toList((Iterable)currentGroup));
                    currentGroup.clear();
                    currentGroupSize = 0;
                }
                groups.add(CollectionsKt.listOf((Object)leaf));
                continue;
            }
            currentGroup.add(leaf);
            currentGroupSize += leafSize + 2;
        }
        if (!((Collection)currentGroup).isEmpty()) {
            groups.add(CollectionsKt.toList((Iterable)currentGroup));
        }
        return groups;
    }

    private final Chunk createCombinedLeafChunk(NavigableContainerSection containerSection, List<LeafSection> leaves2, String rootId, int sequenceNumber) {
        String combinedContent = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)leaves2, (CharSequence)"\n\n", null, null, (int)0, null, InMemoryContentChunker::createCombinedLeafChunk$lambda$3, (int)30, null))).toString();
        String contentWithSectionTitle = this.prependSectionTitle(combinedContent, containerSection.getTitle());
        Map combinedMetadata = new LinkedHashMap();
        combinedMetadata.putAll(containerSection.getMetadata());
        combinedMetadata.put("root_document_id", rootId);
        combinedMetadata.put("container_section_id", containerSection.getId());
        combinedMetadata.put("container_section_title", containerSection.getTitle());
        combinedMetadata.put("container_section_url", containerSection.getUri());
        combinedMetadata.put("chunk_index", 0);
        combinedMetadata.put("total_chunks", 1);
        Integer n = sequenceNumber;
        combinedMetadata.put("sequence_number", n);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Chunk.Companion.invoke(string, contentWithSectionTitle, combinedMetadata, containerSection.getId());
    }

    private final Chunk createSingleLeafChunk(NavigableContainerSection containerSection, LeafSection leaf, String rootId, int sequenceNumber) {
        String content = !StringsKt.isBlank((CharSequence)leaf.getTitle()) ? leaf.getTitle() + "\n" + leaf.getContent() : leaf.getContent();
        String contentWithSectionTitle = this.prependSectionTitle(((Object)StringsKt.trim((CharSequence)content)).toString(), containerSection.getTitle());
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"root_document_id", (Object)rootId), TuplesKt.to((Object)"container_section_id", (Object)containerSection.getId()), TuplesKt.to((Object)"container_section_title", (Object)containerSection.getTitle()), TuplesKt.to((Object)"leaf_section_id", (Object)leaf.getId()), TuplesKt.to((Object)"leaf_section_title", (Object)leaf.getTitle()), TuplesKt.to((Object)"leaf_section_url", (Object)leaf.getUri()), TuplesKt.to((Object)"chunk_index", (Object)0), TuplesKt.to((Object)"total_chunks", (Object)1), TuplesKt.to((Object)"sequence_number", (Object)sequenceNumber)};
        return Chunk.Companion.invoke(string, contentWithSectionTitle, MapsKt.plus(leaf.getMetadata(), (Map)MapsKt.mapOf((Pair[])pairArray)), leaf.getId());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Chunk> splitLeafIntoMultipleChunks(NavigableContainerSection containerSection, LeafSection leaf, String rootId, int startingSequenceNumber) {
        void $this$filterTo$iv$iv;
        List chunks = new ArrayList();
        String fullContent = !StringsKt.isBlank((CharSequence)leaf.getTitle()) ? leaf.getTitle() + "\n" + leaf.getContent() : leaf.getContent();
        String contentWithSectionTitle = this.prependSectionTitle(((Object)StringsKt.trim((CharSequence)fullContent)).toString(), containerSection.getTitle());
        Iterable $this$filter$iv = this.splitText(contentWithSectionTitle);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List textChunks = (List)destination$iv$iv;
        this.logger.debug("Split leaf section '{}' into {} text chunks", (Object)leaf.getTitle(), (Object)textChunks.size());
        Iterable $this$forEachIndexed$iv = textChunks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void textChunk;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (String)item$iv;
            int index = n;
            boolean bl = false;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"root_document_id", (Object)rootId), TuplesKt.to((Object)"container_section_id", (Object)containerSection.getId()), TuplesKt.to((Object)"container_section_title", (Object)containerSection.getTitle()), TuplesKt.to((Object)"leaf_section_id", (Object)leaf.getId()), TuplesKt.to((Object)"leaf_section_title", (Object)leaf.getTitle()), TuplesKt.to((Object)"leaf_section_url", (Object)leaf.getUri()), TuplesKt.to((Object)"chunk_index", (Object)index), TuplesKt.to((Object)"total_chunks", (Object)textChunks.size()), TuplesKt.to((Object)"sequence_number", (Object)(startingSequenceNumber + index))};
            Chunk chunk = Chunk.Companion.invoke(string, ((Object)StringsKt.trim((CharSequence)((CharSequence)textChunk))).toString(), MapsKt.plus(leaf.getMetadata(), (Map)MapsKt.mapOf((Pair[])pairArray)), leaf.getId());
            chunks.add(chunk);
        }
        return chunks;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitText(String text) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Iterator $this$filterTo$iv$iv2;
        String[] stringArray = new String[]{"\n\n"};
        Iterable $this$filter$iv2 = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator<String> iterator = $this$filterTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List paragraphs = (List)destination$iv$iv;
        List chunks = new ArrayList();
        StringBuilder currentChunk = new StringBuilder();
        for (String paragraph : paragraphs) {
            if (((CharSequence)currentChunk).length() > 0 && currentChunk.length() + paragraph.length() + 2 > this.config.getMaxChunkSize()) {
                String overlap;
                String string = currentChunk.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                currentChunk = new StringBuilder();
                if (!((Collection)chunks).isEmpty() && ((CharSequence)(overlap = this.getOverlapText((String)CollectionsKt.last((List)chunks)))).length() > 0 && overlap.length() + paragraph.length() + 2 <= this.config.getMaxChunkSize()) {
                    currentChunk.append(overlap).append("\n\n");
                }
            }
            if (paragraph.length() > this.config.getMaxChunkSize()) {
                List<String> sentenceChunks = this.splitBySentences(paragraph);
                for (String sentenceChunk : sentenceChunks) {
                    if (((CharSequence)currentChunk).length() > 0 && currentChunk.length() + sentenceChunk.length() + 2 > this.config.getMaxChunkSize()) {
                        String overlap;
                        String string = currentChunk.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                        currentChunk = new StringBuilder();
                        if (!((Collection)chunks).isEmpty() && ((CharSequence)(overlap = this.getOverlapText((String)CollectionsKt.last((List)chunks)))).length() > 0 && overlap.length() + sentenceChunk.length() + 2 <= this.config.getMaxChunkSize()) {
                            currentChunk.append(overlap).append("\n\n");
                        }
                    }
                    if (((CharSequence)currentChunk).length() > 0) {
                        currentChunk.append("\n\n");
                    }
                    currentChunk.append(sentenceChunk);
                }
                continue;
            }
            if (((CharSequence)currentChunk).length() > 0) {
                currentChunk.append("\n\n");
            }
            currentChunk.append(paragraph);
        }
        if (((CharSequence)currentChunk).length() > 0) {
            String string = currentChunk.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
        }
        Iterable $this$flatMap$iv = chunks;
        boolean $i$f$flatMap = false;
        iterator = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String chunk = (String)element$iv$iv;
            boolean bl = false;
            if (chunk.length() <= this.config.getMaxChunkSize()) {
                list = CollectionsKt.listOf((Object)chunk);
            } else {
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv3 = StringsKt.chunked((CharSequence)chunk, (int)this.config.getMaxChunkSize());
                boolean $i$f$filter2 = false;
                Iterable iterable2 = $this$filter$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                    String it = (String)element$iv$iv2;
                    boolean bl3 = false;
                    boolean bl4 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                    if (!bl4) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                list = (List)destination$iv$iv3;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$filter3 = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl5 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl5) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List finalChunks = (List)destination$iv$iv2;
        Collection collection2 = finalChunks;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = ((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString()).length() > 0 ? CollectionsKt.listOf((Object)((Object)StringsKt.trim((CharSequence)text)).toString()) : CollectionsKt.emptyList();
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitBySentences(String text) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Iterator $this$filterTo$iv$iv2;
        CharSequence charSequence = text;
        Regex regex = new Regex("(?<=[.!?])\\s+");
        int n = 0;
        Iterable $this$filter$iv2 = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Object object = $this$filterTo$iv$iv2.iterator();
        while (object.hasNext()) {
            Object element$iv$iv = object.next();
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sentences = (List)destination$iv$iv;
        List chunks = new ArrayList();
        StringBuilder currentChunk = new StringBuilder();
        for (String sentence : sentences) {
            if (((CharSequence)currentChunk).length() > 0 && currentChunk.length() + sentence.length() + 1 > this.config.getMaxChunkSize()) {
                String overlap;
                String string = currentChunk.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                currentChunk = new StringBuilder();
                if (!((Collection)chunks).isEmpty() && ((CharSequence)(overlap = this.getOverlapText((String)CollectionsKt.last((List)chunks)))).length() > 0 && overlap.length() + sentence.length() + 1 <= this.config.getMaxChunkSize()) {
                    currentChunk.append(overlap).append(" ");
                }
            }
            if (((CharSequence)currentChunk).length() > 0) {
                currentChunk.append(" ");
            }
            currentChunk.append(sentence);
        }
        if (((CharSequence)currentChunk).length() > 0) {
            String string = currentChunk.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            chunks.add(((Object)StringsKt.trim((CharSequence)string)).toString());
        }
        Iterable $this$flatMap$iv = chunks;
        boolean $i$f$flatMap = false;
        object = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String chunk = (String)element$iv$iv;
            boolean bl = false;
            if (chunk.length() <= this.config.getMaxChunkSize()) {
                list = CollectionsKt.listOf((Object)chunk);
            } else {
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv3 = StringsKt.chunked((CharSequence)chunk, (int)this.config.getMaxChunkSize());
                boolean $i$f$filter2 = false;
                Iterable iterable2 = $this$filter$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                    String it = (String)element$iv$iv2;
                    boolean bl3 = false;
                    boolean bl4 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                    if (!bl4) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                list = (List)destination$iv$iv3;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$filter3 = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl5 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
            if (!bl5) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List finalChunks = (List)destination$iv$iv2;
        Collection collection2 = finalChunks;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = ((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString()).length() > 0 ? CollectionsKt.listOf((Object)((Object)StringsKt.trim((CharSequence)text)).toString()) : CollectionsKt.emptyList();
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    private final String getOverlapText(String previousChunk) {
        String string;
        if (previousChunk.length() <= this.config.getOverlapSize()) {
            return "";
        }
        String overlap = StringsKt.takeLast((String)previousChunk, (int)this.config.getOverlapSize());
        int sentenceStart = StringsKt.indexOf$default((CharSequence)overlap, (String)". ", (int)0, (boolean)false, (int)6, null) + 2;
        if (sentenceStart > 1 && sentenceStart < overlap.length()) {
            String string2 = overlap.substring(sentenceStart);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            String[] stringArray = new String[]{" "};
            List words = StringsKt.split$default((CharSequence)overlap, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            string = words.size() > 1 ? CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)words, (int)1), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) : "";
        }
        return string;
    }

    private final String prependSectionTitle(String content, String sectionTitle) {
        if (!this.config.getIncludeSectionTitleInChunk() || StringsKt.isBlank((CharSequence)sectionTitle) || StringsKt.isBlank((CharSequence)content)) {
            return content;
        }
        String titleWithSeparator = "FROM: " + sectionTitle + "\n\n";
        int resultLength = titleWithSeparator.length() + content.length();
        if (resultLength > this.config.getMaxChunkSize()) {
            return content;
        }
        return titleWithSeparator + content;
    }

    private static final CharSequence createSingleChunkFromContainer$lambda$2(LeafSection leaf) {
        Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
        return !StringsKt.isBlank((CharSequence)leaf.getTitle()) ? (CharSequence)(leaf.getTitle() + "\n" + leaf.getContent()) : (CharSequence)leaf.getContent();
    }

    private static final CharSequence createCombinedLeafChunk$lambda$3(LeafSection leaf) {
        Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
        return !StringsKt.isBlank((CharSequence)leaf.getTitle()) ? (CharSequence)(leaf.getTitle() + "\n" + leaf.getContent()) : (CharSequence)leaf.getContent();
    }

    public InMemoryContentChunker() {
        this(null, 1, null);
    }
}

