/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.observability.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationFilter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.prompt.Prompt;

public class ChatModelObservationFilter
implements ObservationFilter {
    private static final Logger log = LoggerFactory.getLogger(ChatModelObservationFilter.class);
    private final int maxAttributeLength;

    public ChatModelObservationFilter() {
        this(4000);
    }

    public ChatModelObservationFilter(int maxAttributeLength) {
        this.maxAttributeLength = maxAttributeLength;
    }

    @NotNull
    public Observation.Context map(@NotNull Observation.Context context) {
        if (!(context instanceof ChatModelObservationContext)) {
            return context;
        }
        ChatModelObservationContext chatContext = (ChatModelObservationContext)context;
        try {
            String completion;
            String prompt;
            ChatResponse response;
            context.addLowCardinalityKeyValue(KeyValue.of((String)"gen_ai.operation.name", (String)"chat"));
            Prompt request = (Prompt)chatContext.getRequest();
            if (request != null && request.getOptions() != null) {
                String model = request.getOptions().getModel();
                if (model != null && !model.isEmpty()) {
                    context.addLowCardinalityKeyValue(KeyValue.of((String)"gen_ai.request.model", (String)model));
                }
                if (request.getOptions().getTemperature() != null) {
                    context.addHighCardinalityKeyValue(KeyValue.of((String)"gen_ai.request.temperature", (String)String.valueOf(request.getOptions().getTemperature())));
                }
                if (request.getOptions().getMaxTokens() != null) {
                    context.addHighCardinalityKeyValue(KeyValue.of((String)"gen_ai.request.max_tokens", (String)String.valueOf(request.getOptions().getMaxTokens())));
                }
            }
            if ((response = (ChatResponse)chatContext.getResponse()) != null && response.getMetadata() != null) {
                Usage usage;
                String responseModel = response.getMetadata().getModel();
                if (responseModel != null && !responseModel.isEmpty()) {
                    context.addLowCardinalityKeyValue(KeyValue.of((String)"gen_ai.response.model", (String)responseModel));
                }
                if ((usage = response.getMetadata().getUsage()) != null) {
                    if (usage.getPromptTokens() != null) {
                        context.addHighCardinalityKeyValue(KeyValue.of((String)"gen_ai.usage.input_tokens", (String)String.valueOf(usage.getPromptTokens())));
                    }
                    if (usage.getCompletionTokens() != null) {
                        context.addHighCardinalityKeyValue(KeyValue.of((String)"gen_ai.usage.output_tokens", (String)String.valueOf(usage.getCompletionTokens())));
                    }
                }
            }
            if ((prompt = this.extractPrompt(chatContext)) != null && !prompt.isEmpty()) {
                String truncated = this.truncate(prompt);
                context.addHighCardinalityKeyValue(KeyValue.of((String)"gen_ai.prompt", (String)truncated));
                context.addHighCardinalityKeyValue(KeyValue.of((String)"input.value", (String)truncated));
            }
            if ((completion = this.extractCompletion(chatContext)) != null && !completion.isEmpty()) {
                String truncated = this.truncate(completion);
                context.addHighCardinalityKeyValue(KeyValue.of((String)"gen_ai.completion", (String)truncated));
                context.addHighCardinalityKeyValue(KeyValue.of((String)"output.value", (String)truncated));
            }
        }
        catch (Exception e) {
            log.debug("Failed to extract prompt/completion from ChatModelObservationContext", (Throwable)e);
        }
        return context;
    }

    private String extractPrompt(ChatModelObservationContext chatContext) {
        Prompt request = (Prompt)chatContext.getRequest();
        if (request == null) {
            return null;
        }
        List instructions = request.getInstructions();
        if (instructions == null || instructions.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Message message : instructions) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("[").append(message.getMessageType()).append("]: ");
            sb.append(message.getText());
        }
        return sb.toString();
    }

    private String extractCompletion(ChatModelObservationContext chatContext) {
        ChatResponse response = (ChatResponse)chatContext.getResponse();
        if (response == null) {
            return null;
        }
        Generation result = response.getResult();
        if (result == null || result.getOutput() == null) {
            return null;
        }
        return result.getOutput().getText();
    }

    private String truncate(String value) {
        if (value == null) {
            return "";
        }
        return value.length() > this.maxAttributeLength ? value.substring(0, this.maxAttributeLength) + "..." : value;
    }
}

