/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.observability.metrics;

import com.embabel.agent.api.event.AgentProcessCompletedEvent;
import com.embabel.agent.api.event.AgentProcessCreationEvent;
import com.embabel.agent.api.event.AgentProcessEvent;
import com.embabel.agent.api.event.AgentProcessFailedEvent;
import com.embabel.agent.api.event.AgenticEventListener;
import com.embabel.agent.api.event.ProcessKilledEvent;
import com.embabel.agent.api.event.ReplanRequestedEvent;
import com.embabel.agent.api.event.ToolCallResponseEvent;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.Usage;
import com.embabel.agent.observability.ObservabilityProperties;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbabelMetricsEventListener
implements AgenticEventListener {
    private static final Logger log = LoggerFactory.getLogger(EmbabelMetricsEventListener.class);
    private final MeterRegistry registry;
    private final ObservabilityProperties properties;
    private final AtomicInteger activeAgents = new AtomicInteger(0);

    public EmbabelMetricsEventListener(MeterRegistry registry, ObservabilityProperties properties) {
        this.registry = registry;
        this.properties = properties;
        Gauge.builder((String)"embabel.agent.active", (Object)this.activeAgents, AtomicInteger::get).description("Number of agent processes currently running").register(registry);
    }

    public void onProcessEvent(AgentProcessEvent event) {
        if (!this.properties.isMetricsEnabled()) {
            return;
        }
        AgentProcessEvent agentProcessEvent = event;
        Objects.requireNonNull(agentProcessEvent);
        AgentProcessEvent agentProcessEvent2 = agentProcessEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AgentProcessCreationEvent.class, AgentProcessCompletedEvent.class, AgentProcessFailedEvent.class, ProcessKilledEvent.class, ToolCallResponseEvent.class, ReplanRequestedEvent.class}, (Object)agentProcessEvent2, n)) {
            case 0: {
                AgentProcessCreationEvent e = (AgentProcessCreationEvent)agentProcessEvent2;
                this.activeAgents.incrementAndGet();
                break;
            }
            case 1: {
                AgentProcessCompletedEvent e = (AgentProcessCompletedEvent)agentProcessEvent2;
                this.activeAgents.decrementAndGet();
                this.recordTokensAndCost(e.getAgentProcess());
                break;
            }
            case 2: {
                AgentProcessFailedEvent e = (AgentProcessFailedEvent)agentProcessEvent2;
                this.activeAgents.decrementAndGet();
                this.recordAgentError(e.getAgentProcess());
                this.recordTokensAndCost(e.getAgentProcess());
                break;
            }
            case 3: {
                ProcessKilledEvent e = (ProcessKilledEvent)agentProcessEvent2;
                this.activeAgents.decrementAndGet();
                break;
            }
            case 4: {
                ToolCallResponseEvent e = (ToolCallResponseEvent)agentProcessEvent2;
                this.recordToolError(e);
                break;
            }
            case 5: {
                ReplanRequestedEvent e = (ReplanRequestedEvent)agentProcessEvent2;
                this.recordReplanning(e.getAgentProcess());
                break;
            }
        }
    }

    private void recordAgentError(AgentProcess process) {
        String agentName = process.getAgent().getName();
        Counter.builder((String)"embabel.agent.errors.total").description("Total agent process failures").tag("agent", agentName).register(this.registry).increment();
    }

    private void recordTokensAndCost(AgentProcess process) {
        double cost;
        String agentName = process.getAgent().getName();
        Usage usage = process.usage();
        if (usage != null) {
            if (usage.getPromptTokens() != null) {
                Counter.builder((String)"embabel.llm.tokens.total").description("Total LLM tokens consumed").tag("agent", agentName).tag("direction", "input").register(this.registry).increment((double)usage.getPromptTokens().intValue());
            }
            if (usage.getCompletionTokens() != null) {
                Counter.builder((String)"embabel.llm.tokens.total").description("Total LLM tokens consumed").tag("agent", agentName).tag("direction", "output").register(this.registry).increment((double)usage.getCompletionTokens().intValue());
            }
        }
        if ((cost = process.cost()) > 0.0) {
            Counter.builder((String)"embabel.llm.cost.total").description("Estimated LLM cost in USD").tag("agent", agentName).register(this.registry).increment(cost);
        }
    }

    private void recordToolError(ToolCallResponseEvent event) {
        Throwable error = this.extractToolError(event);
        if (error != null) {
            String toolName = event.getRequest().getTool();
            Counter.builder((String)"embabel.tool.errors.total").description("Total tool call failures").tag("tool", toolName).register(this.registry).increment();
        }
    }

    private void recordReplanning(AgentProcess process) {
        String agentName = process.getAgent().getName();
        Counter.builder((String)"embabel.planning.replanning.total").description("Total replanning events").tag("agent", agentName).register(this.registry).increment();
    }

    private Throwable extractToolError(ToolCallResponseEvent event) {
        try {
            Method getResultMethod = null;
            for (Method m : ToolCallResponseEvent.class.getMethods()) {
                if (!m.getName().startsWith("getResult") || m.getParameterCount() != 0) continue;
                getResultMethod = m;
                break;
            }
            if (getResultMethod == null) {
                return null;
            }
            Object result = getResultMethod.invoke((Object)event, new Object[0]);
            if (result == null) {
                return null;
            }
            if (result instanceof Throwable) {
                Throwable t = (Throwable)result;
                return t;
            }
            try {
                Method exceptionOrNullMethod = result.getClass().getMethod("exceptionOrNull", new Class[0]);
                Object error = exceptionOrNullMethod.invoke(result, new Object[0]);
                if (error instanceof Throwable) {
                    Throwable t = (Throwable)error;
                    return t;
                }
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        catch (Exception e) {
            log.trace("Could not extract tool error: {}", (Object)e.getMessage());
        }
        return null;
    }
}

