/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.autoconfigure.observability;

import com.embabel.agent.autoconfigure.observability.ObservabilityAutoConfiguration;
import com.embabel.agent.observability.ObservabilityProperties;
import com.embabel.agent.observability.observation.TrackedAspect;
import io.micrometer.observation.ObservationRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={ObservabilityAutoConfiguration.class})
@ConditionalOnClass(name={"org.aspectj.lang.ProceedingJoinPoint"})
@ConditionalOnProperty(prefix="embabel.observability", name={"enabled", "trace-tracked-operations"}, havingValue="true", matchIfMissing=true)
public class TrackedAspectAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TrackedAspectAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public TrackedAspect trackedAspect(ObservationRegistry observationRegistry, ObservabilityProperties properties) {
        log.info("Configuring @Tracked annotation aspect for custom operation tracking");
        return new TrackedAspect(observationRegistry, properties.getMaxAttributeLength());
    }
}

