/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.autoconfigure.observability;

import com.embabel.agent.observability.ObservabilityProperties;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.ServiceAttributes;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureOrder(value=0x7FFFFFF5)
@EnableConfigurationProperties(value={ObservabilityProperties.class})
@ConditionalOnClass(value={SdkTracerProvider.class, OpenTelemetry.class})
@ConditionalOnProperty(prefix="embabel.observability", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class OpenTelemetrySdkAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OpenTelemetrySdkAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={Resource.class})
    public Resource openTelemetryResource(ObservabilityProperties properties) {
        return Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ServiceAttributes.SERVICE_NAME, (Object)properties.getServiceName())));
    }

    @Bean
    @ConditionalOnMissingBean(value={SdkTracerProvider.class})
    public SdkTracerProvider sdkTracerProvider(ObjectProvider<List<SpanExporter>> exportersProvider, ObjectProvider<List<SpanProcessor>> processorsProvider, Resource resource) {
        List<SpanProcessor> validProcessors;
        List exporters = (List)exportersProvider.getIfAvailable();
        List processors = (List)processorsProvider.getIfAvailable();
        List<SpanExporter> validExporters = exporters == null ? List.of() : exporters.stream().filter(Objects::nonNull).toList();
        List<SpanProcessor> list = validProcessors = processors == null ? List.of() : processors.stream().filter(Objects::nonNull).toList();
        if (validExporters.isEmpty()) {
            log.warn("No SpanExporter beans found. OpenTelemetry tracing will be disabled. To enable tracing, add an exporter dependency (e.g., opentelemetry-exporter-langfuse, opentelemetry-exporter-zipkin) and configure it properly.");
            return null;
        }
        SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder().setResource(resource);
        for (SpanProcessor processor : validProcessors) {
            tracerProviderBuilder.addSpanProcessor(processor);
            log.debug("Added SpanProcessor: {}", (Object)processor.getClass().getSimpleName());
        }
        for (SpanExporter exporter : validExporters) {
            tracerProviderBuilder.addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)exporter).build());
            log.debug("Added SpanExporter: {}", (Object)exporter.getClass().getSimpleName());
        }
        SdkTracerProvider tracerProvider = tracerProviderBuilder.build();
        log.info("SdkTracerProvider configured with {} processor(s) and {} exporter(s)", (Object)validProcessors.size(), (Object)validExporters.size());
        return tracerProvider;
    }

    @Bean
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    public OpenTelemetry openTelemetry(ObjectProvider<SdkTracerProvider> tracerProviderProvider) {
        SdkTracerProvider tracerProvider = (SdkTracerProvider)tracerProviderProvider.getIfAvailable();
        if (tracerProvider == null) {
            log.warn("No SdkTracerProvider available. OpenTelemetry will be disabled.");
            return OpenTelemetry.noop();
        }
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).buildAndRegisterGlobal();
        log.info("OpenTelemetry SDK configured and registered globally");
        return openTelemetry;
    }
}

