/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.autoconfigure.observability;

import com.embabel.agent.api.event.AgenticEventListener;
import com.embabel.agent.autoconfigure.observability.HttpBodyCachingFilter;
import com.embabel.agent.autoconfigure.observability.HttpRequestObservationFilter;
import com.embabel.agent.autoconfigure.observability.MicrometerTracingAutoConfiguration;
import com.embabel.agent.observability.ObservabilityProperties;
import com.embabel.agent.observability.mdc.MdcPropagationEventListener;
import com.embabel.agent.observability.metrics.EmbabelMetricsEventListener;
import com.embabel.agent.observability.observation.ChatModelObservationFilter;
import com.embabel.agent.observability.observation.EmbabelFullObservationEventListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.ObservationRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(after={MicrometerTracingAutoConfiguration.class}, afterName={"org.springframework.boot.actuate.autoconfigure.tracing.MicrometerTracingAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration"})
@EnableConfigurationProperties(value={ObservabilityProperties.class})
@ConditionalOnProperty(prefix="embabel.observability", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ObservabilityAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ObservabilityAutoConfiguration.class);

    @Bean
    @ConditionalOnBean(value={ObservationRegistry.class})
    @ConditionalOnProperty(prefix="embabel.observability", name={"trace-agent-events"}, havingValue="true", matchIfMissing=true)
    public AgenticEventListener embabelObservationEventListener(ObservationRegistry observationRegistry, ObservabilityProperties properties) {
        log.info("Configuring Embabel Agent observability with Spring Observation API (traces + metrics)");
        return new EmbabelFullObservationEventListener(observationRegistry, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.ai.chat.observation.ChatModelObservationContext"})
    @ConditionalOnProperty(prefix="embabel.observability", name={"trace-llm-calls"}, havingValue="true", matchIfMissing=true)
    public ChatModelObservationFilter chatModelObservationFilter(ObservabilityProperties properties) {
        log.debug("Configuring ChatModel observation filter for LLM call tracing");
        return new ChatModelObservationFilter(properties.getMaxAttributeLength());
    }

    @Bean
    @ConditionalOnProperty(prefix="embabel.observability", name={"mdc-propagation"}, havingValue="true", matchIfMissing=true)
    public MdcPropagationEventListener mdcPropagationEventListener(ObservabilityProperties properties) {
        log.info("Configuring Embabel Agent MDC propagation for log correlation");
        return new MdcPropagationEventListener(properties);
    }

    @Bean
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnProperty(prefix="embabel.observability", name={"metrics-enabled"}, havingValue="true", matchIfMissing=true)
    public EmbabelMetricsEventListener embabelMetricsEventListener(MeterRegistry meterRegistry, ObservabilityProperties properties) {
        log.info("Configuring Embabel Agent Micrometer metrics listener");
        return new EmbabelMetricsEventListener(meterRegistry, properties);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"jakarta.servlet.Filter"})
    @ConditionalOnProperty(prefix="embabel.observability", name={"trace-http-details"}, havingValue="true")
    static class ServletObservabilityConfiguration {
        private static final Logger log = LoggerFactory.getLogger(ServletObservabilityConfiguration.class);

        ServletObservabilityConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.web.util.ContentCachingRequestWrapper"})
        public HttpBodyCachingFilter httpBodyCachingFilter() {
            log.debug("Configuring HTTP body caching filter for request/response tracing");
            return new HttpBodyCachingFilter();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.http.server.observation.ServerRequestObservationContext"})
        public HttpRequestObservationFilter httpRequestObservationFilter(ObservabilityProperties properties) {
            log.debug("Configuring HTTP request observation filter for request/response tracing");
            return new HttpRequestObservationFilter(properties.getMaxAttributeLength());
        }
    }
}

