/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.autoconfigure.observability;

import io.micrometer.common.KeyValue;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.observation.ServerRequestObservationContext;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class HttpRequestObservationFilter
implements ObservationFilter {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestObservationFilter.class);
    private static final Set<String> TRACKED_HEADERS = Set.of("content-type", "accept", "authorization", "user-agent");
    private static final Set<String> MASKED_HEADERS = Set.of("authorization");
    private final int maxAttributeLength;

    public HttpRequestObservationFilter(int maxAttributeLength) {
        this.maxAttributeLength = maxAttributeLength;
    }

    @NotNull
    public Observation.Context map(@NotNull Observation.Context context) {
        if (!(context instanceof ServerRequestObservationContext)) {
            return context;
        }
        ServerRequestObservationContext serverContext = (ServerRequestObservationContext)context;
        try {
            this.addHeaders(serverContext);
            this.addParams(serverContext);
            this.addRequestBody(serverContext);
            this.addResponseBody(serverContext);
        }
        catch (Exception e) {
            log.debug("Failed to extract HTTP details from observation context", (Throwable)e);
        }
        return context;
    }

    private void addHeaders(ServerRequestObservationContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getCarrier();
        StringJoiner joiner = new StringJoiner("; ");
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!TRACKED_HEADERS.contains(name.toLowerCase())) continue;
            String value = MASKED_HEADERS.contains(name.toLowerCase()) ? "***" : request.getHeader(name);
            joiner.add(name + ": " + value);
        }
        if (joiner.length() > 0) {
            context.addHighCardinalityKeyValue(KeyValue.of((String)"http.request.headers", (String)joiner.toString()));
        }
    }

    private void addParams(ServerRequestObservationContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getCarrier();
        Map paramMap = request.getParameterMap();
        if (paramMap.isEmpty()) {
            return;
        }
        StringJoiner joiner = new StringJoiner("&");
        paramMap.forEach((key, values) -> {
            for (String value : values) {
                joiner.add(key + "=" + value);
            }
        });
        context.addHighCardinalityKeyValue(KeyValue.of((String)"http.request.params", (String)joiner.toString()));
    }

    private void addRequestBody(ServerRequestObservationContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getCarrier();
        if (!(request instanceof ContentCachingRequestWrapper)) {
            return;
        }
        ContentCachingRequestWrapper wrapper = (ContentCachingRequestWrapper)request;
        String body = new String(wrapper.getContentAsByteArray(), StandardCharsets.UTF_8);
        if (!body.isEmpty()) {
            context.addHighCardinalityKeyValue(KeyValue.of((String)"http.request.body", (String)this.truncate(body)));
        }
    }

    private void addResponseBody(ServerRequestObservationContext context) {
        HttpServletResponse response = (HttpServletResponse)context.getResponse();
        if (!(response instanceof ContentCachingResponseWrapper)) {
            return;
        }
        ContentCachingResponseWrapper wrapper = (ContentCachingResponseWrapper)response;
        String body = new String(wrapper.getContentAsByteArray(), StandardCharsets.UTF_8);
        if (!body.isEmpty()) {
            context.addHighCardinalityKeyValue(KeyValue.of((String)"http.response.body", (String)this.truncate(body)));
        }
    }

    private String truncate(String value) {
        return value.length() > this.maxAttributeLength ? value.substring(0, this.maxAttributeLength) + "..." : value;
    }
}

