/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.autoconfigure.observability;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class HttpBodyCachingFilter
extends OncePerRequestFilter
implements Ordered {
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) throws ServletException, IOException {
        ContentCachingResponseWrapper ccr;
        HttpServletRequest wrappedRequest = request instanceof ContentCachingRequestWrapper ? request : new ContentCachingRequestWrapper(request);
        ContentCachingResponseWrapper wrappedResponse = response instanceof ContentCachingResponseWrapper ? (ccr = (ContentCachingResponseWrapper)response) : new ContentCachingResponseWrapper(response);
        try {
            filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        }
        finally {
            wrappedResponse.copyBodyToResponse();
        }
    }
}

