/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.autoconfigure.netty;

import com.embabel.agent.autoconfigure.netty.NettyClientFactoryProperties;
import io.netty.channel.ChannelOption;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ReactorClientHttpRequestFactory;
import reactor.netty.http.client.HttpClient;

@AutoConfiguration
@EnableConfigurationProperties(value={NettyClientFactoryProperties.class})
@AutoConfigureBefore(name={"com.embabel.agent.autoconfigure.platform.AgentPlatformAutoConfiguration"})
public class NettyClientAutoConfiguration {
    @Bean(value={"aiModelHttpRequestFactory"})
    @ConditionalOnProperty(value={"embabel.agent.platform.http-client.use-reactor-netty"}, havingValue="true", matchIfMissing=true)
    ClientHttpRequestFactory reactorClientHttpRequestFactory(NettyClientFactoryProperties httpClientProperties) {
        HttpClient httpClient = (HttpClient)HttpClient.create().responseTimeout(httpClientProperties.readTimeout()).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)httpClientProperties.connectTimeout().toMillis()));
        return new ReactorClientHttpRequestFactory(httpClient);
    }
}

