/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.lmstudio;

import com.embabel.agent.config.models.lmstudio.LmStudioProperties;
import com.embabel.agent.openai.OpenAiCompatibleModelFactory;
import com.embabel.agent.spi.LlmService;
import com.embabel.common.ai.autoconfig.ProviderInitialization;
import com.embabel.common.ai.autoconfig.RegisteredModel;
import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.ai.model.PricingModel;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestClient;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LmStudioProperties.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0017J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0012J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig;", "Lcom/embabel/agent/openai/OpenAiCompatibleModelFactory;", "lmStudioProperties", "Lcom/embabel/agent/config/models/lmstudio/LmStudioProperties;", "configurableBeanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "observationRegistry", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/observation/ObservationRegistry;", "<init>", "(Lcom/embabel/agent/config/models/lmstudio/LmStudioProperties;Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;Lorg/springframework/beans/factory/ObjectProvider;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "lmStudioModelsInitializer", "Lcom/embabel/common/ai/autoconfig/ProviderInitialization;", "loadModelsFromUrl", "", "Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig$ModelData;", "normalizeModelName", "", "modelId", "ModelResponse", "ModelData", "LlmType", "embabel-agent-lmstudio-autoconfigure"})
@SourceDebugExtension(value={"SMAP\nLmStudioModelsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LmStudioModelsConfig.kt\ncom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n774#2:233\n865#2,2:234\n1863#2,2:236\n774#2:238\n865#2,2:239\n1863#2,2:241\n1#3:243\n*S KotlinDebug\n*F\n+ 1 LmStudioModelsConfig.kt\ncom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig\n*L\n126#1:233\n126#1:234,2\n127#1:236,2\n150#1:238\n150#1:239,2\n151#1:241,2\n*E\n"})
public class LmStudioModelsConfig
extends OpenAiCompatibleModelFactory {
    @NotNull
    private final LmStudioProperties lmStudioProperties;
    @NotNull
    private final ConfigurableBeanFactory configurableBeanFactory;
    private final Logger log;

    public LmStudioModelsConfig(@NotNull LmStudioProperties lmStudioProperties, @NotNull ConfigurableBeanFactory configurableBeanFactory, @NotNull ObjectProvider<ObservationRegistry> observationRegistry) {
        Intrinsics.checkNotNullParameter((Object)lmStudioProperties, (String)"lmStudioProperties");
        Intrinsics.checkNotNullParameter((Object)configurableBeanFactory, (String)"configurableBeanFactory");
        Intrinsics.checkNotNullParameter(observationRegistry, (String)"observationRegistry");
        String string = lmStudioProperties.getBaseUrl();
        String string2 = lmStudioProperties.getApiKey();
        Object object = observationRegistry.getIfUnique(LmStudioModelsConfig::_init_$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getIfUnique(...)");
        super(string, string2, null, null, null, (ObservationRegistry)object, null, 80, null);
        this.lmStudioProperties = lmStudioProperties;
        this.configurableBeanFactory = configurableBeanFactory;
        this.log = LoggerFactory.getLogger(LmStudioModelsConfig.class);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @NotNull
    public ProviderInitialization lmStudioModelsInitializer() {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List list;
        Object element$iv2;
        void $this$forEach$iv2;
        Iterator $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        List list2;
        List<ModelData> models = this.loadModelsFromUrl();
        if (models.isEmpty()) {
            this.log.warn("No LM Studio models discovered at {}. Ensure LM Studio is running and the server is started.", (Object)this.getBaseUrl());
        }
        this.log.info("Discovered {} LM Studio models: {}", (Object)models.size(), models);
        List $this$lmStudioModelsInitializer_u24lambda_u243 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable iterable = models;
        boolean $i$f$filter = false;
        void var8_10 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            ModelData it = (ModelData)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getType() == LlmType.llm)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            ModelData modelData = (ModelData)element$iv2;
            boolean bl3 = false;
            try {
                LlmService llm = OpenAiCompatibleModelFactory.openAiCompatibleLlm$default((OpenAiCompatibleModelFactory)this, (String)modelData.getKey(), (PricingModel)PricingModel.Companion.getALL_YOU_CAN_EAT(), (String)"LM Studio", null, null, (RetryTemplate)this.lmStudioProperties.retryTemplate("lmstudio-" + modelData + ".key"), (int)16, null);
                String beanName = "lmStudioModel-" + this.normalizeModelName(modelData.getKey());
                this.configurableBeanFactory.registerSingleton(beanName, (Object)llm);
                $this$lmStudioModelsInitializer_u24lambda_u243.add(new RegisteredModel(beanName, modelData.getKey()));
                this.log.debug("Successfully registered LM Studio LLM {} as bean {}", (Object)modelData.getKey(), (Object)beanName);
            }
            catch (Exception e) {
                this.log.error("Failed to register LM Studio model {}: {}", (Object)modelData.getKey(), (Object)e.getMessage());
            }
        }
        List registeredLlms = CollectionsKt.build((List)list2);
        List $this$lmStudioModelsInitializer_u24lambda_u246 = list = CollectionsKt.createListBuilder();
        boolean bl4 = false;
        Iterable $i$f$forEach22 = models;
        boolean $i$f$filter2 = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModelData it = (ModelData)element$iv$iv;
            boolean bl5 = false;
            if (!(it.getType() == LlmType.embedding)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            ModelData modelData = (ModelData)element$iv3;
            boolean bl6 = false;
            try {
                EmbeddingService llm = this.openAiCompatibleEmbeddingService(modelData.getKey(), "LM Studio");
                String beanName = "lmStudioModel-" + this.normalizeModelName(modelData.getKey());
                this.configurableBeanFactory.registerSingleton(beanName, (Object)llm);
                $this$lmStudioModelsInitializer_u24lambda_u246.add(new RegisteredModel(beanName, modelData.getKey()));
                this.log.debug("Successfully registered LM Studio LLM {} as bean {}", (Object)modelData.getKey(), (Object)beanName);
            }
            catch (Exception e) {
                this.log.error("Failed to register LM Studio model {}: {}", (Object)modelData.getKey(), (Object)e.getMessage());
            }
        }
        List registeredEmbeddings = CollectionsKt.build((List)list);
        List it = list = new ProviderInitialization("LM Studio", registeredLlms, registeredEmbeddings, null, 8, null);
        boolean bl7 = false;
        this.getLogger().info(it.summary());
        return list;
    }

    private List<ModelData> loadModelsFromUrl() {
        List list;
        try {
            String cleanBaseUrl;
            char[] cArray;
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            requestFactory.setConnectTimeout(2000);
            requestFactory.setReadTimeout(2000);
            RestClient restClient = RestClient.builder().requestFactory((ClientHttpRequestFactory)requestFactory).build();
            Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
            RestClient restClient2 = restClient;
            String string = this.getBaseUrl();
            if (string == null || (string = StringsKt.trimEnd((String)string, (char[])(cArray = new char[]{'/'}))) == null) {
                string = "http://127.0.0.1:1234";
            }
            Object apiUrl = StringsKt.contains$default((CharSequence)(cleanBaseUrl = string), (CharSequence)"/api", (boolean)false, (int)2, null) ? cleanBaseUrl : cleanBaseUrl + "/api";
            String url = StringsKt.endsWith$default((String)apiUrl, (String)"/v1", (boolean)false, (int)2, null) ? (String)apiUrl + "/models" : (String)apiUrl + "/v1/models";
            this.log.info("Attempting to fetch models from: {}", (Object)url);
            MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
            String responseBody = (String)restClient2.get().uri(url, new Object[0]).accept(mediaTypeArray).retrieve().body(String.class);
            this.log.debug("Received response from LM Studio: {}", (Object)responseBody);
            if (responseBody == null) {
                this.log.warn("Received empty response from LM Studio");
                return CollectionsKt.emptyList();
            }
            ObjectMapper objectMapper = new ObjectMapper();
            ModelResponse response = (ModelResponse)objectMapper.readValue(responseBody, ModelResponse.class);
            List list2 = response.getModels();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        catch (Exception e) {
            this.log.warn("Failed to load models from {}: {}", (Object)this.getBaseUrl(), (Object)e.getMessage());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private String normalizeModelName(String modelId) {
        String string = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)modelId, (String)":", (String)"-", (boolean)false, (int)4, null), (String)"/", (String)"-", (boolean)false, (int)4, null), (String)"\\", (String)"-", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    private static final ObservationRegistry _init_$lambda$0() {
        return ObservationRegistry.NOOP;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig$LlmType;", "", "<init>", "(Ljava/lang/String;I)V", "embedding", "llm", "embabel-agent-lmstudio-autoconfigure"})
    public static final class LlmType
    extends Enum<LlmType> {
        public static final /* enum */ LlmType embedding = new LlmType();
        public static final /* enum */ LlmType llm = new LlmType();
        private static final /* synthetic */ LlmType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LlmType[] values() {
            return (LlmType[])$VALUES.clone();
        }

        public static LlmType valueOf(String value) {
            return Enum.valueOf(LlmType.class, value);
        }

        @NotNull
        public static EnumEntries<LlmType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = llmTypeArray = new LlmType[]{LlmType.embedding, LlmType.llm};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0083\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig$ModelData;", "", "key", "", "type", "Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig$LlmType;", "<init>", "(Ljava/lang/String;Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig$LlmType;)V", "getKey", "()Ljava/lang/String;", "getType", "()Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig$LlmType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "embabel-agent-lmstudio-autoconfigure"})
    private static final class ModelData {
        @NotNull
        private final String key;
        @NotNull
        private final LlmType type;

        public ModelData(@JsonProperty(value="key") @NotNull String key, @JsonProperty(value="type") @NotNull LlmType type) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.key = key;
            this.type = type;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final LlmType getType() {
            return this.type;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final LlmType component2() {
            return this.type;
        }

        @NotNull
        public final ModelData copy(@JsonProperty(value="key") @NotNull String key, @JsonProperty(value="type") @NotNull LlmType type) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new ModelData(key, type);
        }

        public static /* synthetic */ ModelData copy$default(ModelData modelData, String string, LlmType llmType, int n, Object object) {
            if ((n & 1) != 0) {
                string = modelData.key;
            }
            if ((n & 2) != 0) {
                llmType = modelData.type;
            }
            return modelData.copy(string, llmType);
        }

        @NotNull
        public String toString() {
            return "ModelData(key=" + this.key + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = result * 31 + this.type.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModelData)) {
                return false;
            }
            ModelData modelData = (ModelData)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)modelData.key)) {
                return false;
            }
            return this.type == modelData.type;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0083\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\b\u0003\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001b\u0010\n\u001a\u00020\u00002\u0010\b\u0003\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig$ModelResponse;", "", "models", "", "Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig$ModelData;", "<init>", "(Ljava/util/List;)V", "getModels", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "embabel-agent-lmstudio-autoconfigure"})
    private static final class ModelResponse {
        @Nullable
        private final List<ModelData> models;

        public ModelResponse(@JsonProperty(value="models") @Nullable List<ModelData> models) {
            this.models = models;
        }

        public /* synthetic */ ModelResponse(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = null;
            }
            this(list);
        }

        @Nullable
        public final List<ModelData> getModels() {
            return this.models;
        }

        @Nullable
        public final List<ModelData> component1() {
            return this.models;
        }

        @NotNull
        public final ModelResponse copy(@JsonProperty(value="models") @Nullable List<ModelData> models) {
            return new ModelResponse(models);
        }

        public static /* synthetic */ ModelResponse copy$default(ModelResponse modelResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = modelResponse.models;
            }
            return modelResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "ModelResponse(models=" + this.models + ")";
        }

        public int hashCode() {
            return this.models == null ? 0 : ((Object)this.models).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModelResponse)) {
                return false;
            }
            ModelResponse modelResponse = (ModelResponse)other;
            return Intrinsics.areEqual(this.models, modelResponse.models);
        }

        public ModelResponse() {
            this(null, 1, null);
        }
    }
}

