/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.lmstudio;

import com.embabel.agent.config.models.lmstudio.LmStudioProperties;
import com.embabel.agent.openai.OpenAiCompatibleModelFactory;
import com.embabel.common.ai.autoconfig.ProviderInitialization;
import com.embabel.common.ai.autoconfig.RegisteredModel;
import com.embabel.common.ai.model.Llm;
import com.embabel.common.ai.model.PricingModel;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestClient;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LmStudioProperties.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0017J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0012J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig;", "Lcom/embabel/agent/openai/OpenAiCompatibleModelFactory;", "lmStudioProperties", "Lcom/embabel/agent/config/models/lmstudio/LmStudioProperties;", "configurableBeanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "observationRegistry", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/observation/ObservationRegistry;", "<init>", "(Lcom/embabel/agent/config/models/lmstudio/LmStudioProperties;Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;Lorg/springframework/beans/factory/ObjectProvider;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "lmStudioModelsInitializer", "Lcom/embabel/common/ai/autoconfig/ProviderInitialization;", "loadModelsFromUrl", "", "", "normalizeModelName", "modelId", "ModelResponse", "ModelData", "embabel-agent-lmstudio-autoconfigure"})
@SourceDebugExtension(value={"SMAP\nLmStudioModelsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LmStudioModelsConfig.kt\ncom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1863#2,2:200\n1557#2:203\n1628#2,3:204\n1#3:202\n*S KotlinDebug\n*F\n+ 1 LmStudioModelsConfig.kt\ncom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig\n*L\n121#1:200,2\n184#1:203\n184#1:204,3\n*E\n"})
public class LmStudioModelsConfig
extends OpenAiCompatibleModelFactory {
    @NotNull
    private final LmStudioProperties lmStudioProperties;
    @NotNull
    private final ConfigurableBeanFactory configurableBeanFactory;
    private final Logger log;

    public LmStudioModelsConfig(@NotNull LmStudioProperties lmStudioProperties, @NotNull ConfigurableBeanFactory configurableBeanFactory, @NotNull ObjectProvider<ObservationRegistry> observationRegistry) {
        Intrinsics.checkNotNullParameter((Object)lmStudioProperties, (String)"lmStudioProperties");
        Intrinsics.checkNotNullParameter((Object)configurableBeanFactory, (String)"configurableBeanFactory");
        Intrinsics.checkNotNullParameter(observationRegistry, (String)"observationRegistry");
        String string = lmStudioProperties.getBaseUrl();
        String string2 = lmStudioProperties.getApiKey();
        Object object = observationRegistry.getIfUnique(LmStudioModelsConfig::_init_$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getIfUnique(...)");
        super(string, string2, null, null, (ObservationRegistry)object, null, 32, null);
        this.lmStudioProperties = lmStudioProperties;
        this.configurableBeanFactory = configurableBeanFactory;
        this.log = LoggerFactory.getLogger(LmStudioModelsConfig.class);
    }

    @Bean
    @NotNull
    public ProviderInitialization lmStudioModelsInitializer() {
        List list;
        List<String> models = this.loadModelsFromUrl();
        if (models.isEmpty()) {
            this.log.warn("No LM Studio models discovered at {}. Ensure LM Studio is running and the server is started.", (Object)this.getBaseUrl());
        }
        this.log.info("Discovered {} LM Studio models: {}", (Object)models.size(), models);
        List $this$lmStudioModelsInitializer_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = models;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String modelId = (String)element$iv;
            boolean bl2 = false;
            try {
                Llm llm = OpenAiCompatibleModelFactory.openAiCompatibleLlm$default((OpenAiCompatibleModelFactory)this, (String)modelId, (PricingModel)PricingModel.Companion.getALL_YOU_CAN_EAT(), (String)"LM Studio", null, null, (RetryTemplate)this.lmStudioProperties.retryTemplate("lmstudio-" + modelId), (int)16, null);
                String beanName = "lmStudioModel-" + this.normalizeModelName(modelId);
                this.configurableBeanFactory.registerSingleton(beanName, (Object)llm);
                $this$lmStudioModelsInitializer_u24lambda_u242.add(new RegisteredModel(beanName, modelId));
                this.log.debug("Successfully registered LM Studio LLM {} as bean {}", (Object)modelId, (Object)beanName);
            }
            catch (Exception e) {
                this.log.error("Failed to register LM Studio model {}: {}", (Object)modelId, (Object)e.getMessage());
            }
        }
        List registeredLlms = CollectionsKt.build((List)list);
        List it = list = new ProviderInitialization("LM Studio", registeredLlms, null, null, 12, null);
        boolean bl3 = false;
        this.getLogger().info(it.summary());
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> loadModelsFromUrl() {
        List list;
        try {
            List list2;
            String cleanBaseUrl;
            Object[] objectArray;
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            requestFactory.setConnectTimeout(2000);
            requestFactory.setReadTimeout(2000);
            RestClient restClient = RestClient.builder().requestFactory((ClientHttpRequestFactory)requestFactory).build();
            Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
            RestClient restClient2 = restClient;
            String string = this.getBaseUrl();
            if (string == null || (string = StringsKt.trimEnd((String)string, (char[])(objectArray = new char[]{'/'}))) == null) {
                string = "http://127.0.0.1:1234";
            }
            String url = StringsKt.endsWith$default((String)(cleanBaseUrl = string), (String)"/v1", (boolean)false, (int)2, null) ? cleanBaseUrl + "/models" : cleanBaseUrl + "/v1/models";
            this.log.info("Attempting to fetch models from: {}", (Object)url);
            objectArray = new MediaType[1];
            objectArray[0] = (char)MediaType.APPLICATION_JSON;
            String responseBody = (String)restClient2.get().uri(url, new Object[0]).accept((MediaType[])objectArray).retrieve().body(String.class);
            this.log.debug("Received response from LM Studio: {}", (Object)responseBody);
            if (responseBody == null) {
                this.log.warn("Received empty response from LM Studio");
                return CollectionsKt.emptyList();
            }
            ObjectMapper objectMapper = new ObjectMapper();
            ModelResponse response = (ModelResponse)objectMapper.readValue(responseBody, ModelResponse.class);
            List<ModelData> list3 = response.getData();
            if (list3 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ModelData modelData = (ModelData)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getId());
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        catch (Exception e) {
            this.log.warn("Failed to load models from {}: {}", (Object)this.getBaseUrl(), (Object)e.getMessage());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private String normalizeModelName(String modelId) {
        String string = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)modelId, (String)":", (String)"-", (boolean)false, (int)4, null), (String)"/", (String)"-", (boolean)false, (int)4, null), (String)"\\", (String)"-", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    private static final ObservationRegistry _init_$lambda$0() {
        return ObservationRegistry.NOOP;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0083\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig$ModelData;", "", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "embabel-agent-lmstudio-autoconfigure"})
    private static final class ModelData {
        @NotNull
        private final String id;

        public ModelData(@JsonProperty(value="id") @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final ModelData copy(@JsonProperty(value="id") @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new ModelData(id);
        }

        public static /* synthetic */ ModelData copy$default(ModelData modelData, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = modelData.id;
            }
            return modelData.copy(string);
        }

        @NotNull
        public String toString() {
            return "ModelData(id=" + this.id + ")";
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModelData)) {
                return false;
            }
            ModelData modelData = (ModelData)other;
            return Intrinsics.areEqual((Object)this.id, (Object)modelData.id);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0083\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\b\u0003\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001b\u0010\n\u001a\u00020\u00002\u0010\b\u0003\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig$ModelResponse;", "", "data", "", "Lcom/embabel/agent/config/models/lmstudio/LmStudioModelsConfig$ModelData;", "<init>", "(Ljava/util/List;)V", "getData", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "embabel-agent-lmstudio-autoconfigure"})
    private static final class ModelResponse {
        @Nullable
        private final List<ModelData> data;

        public ModelResponse(@JsonProperty(value="data") @Nullable List<ModelData> data) {
            this.data = data;
        }

        public /* synthetic */ ModelResponse(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = null;
            }
            this(list);
        }

        @Nullable
        public final List<ModelData> getData() {
            return this.data;
        }

        @Nullable
        public final List<ModelData> component1() {
            return this.data;
        }

        @NotNull
        public final ModelResponse copy(@JsonProperty(value="data") @Nullable List<ModelData> data) {
            return new ModelResponse(data);
        }

        public static /* synthetic */ ModelResponse copy$default(ModelResponse modelResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = modelResponse.data;
            }
            return modelResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "ModelResponse(data=" + this.data + ")";
        }

        public int hashCode() {
            return this.data == null ? 0 : ((Object)this.data).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModelResponse)) {
                return false;
            }
            ModelResponse modelResponse = (ModelResponse)other;
            return Intrinsics.areEqual(this.data, modelResponse.data);
        }

        public ModelResponse() {
            this(null, 1, null);
        }
    }
}

