/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support;

import com.embabel.agent.api.tool.DelegatingTool;
import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.spi.support.ToolDecoratorsKt;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/embabel/agent/spi/support/ObservabilityTool;", "Lcom/embabel/agent/api/tool/DelegatingTool;", "delegate", "Lcom/embabel/agent/api/tool/Tool;", "observationRegistry", "Lio/micrometer/observation/ObservationRegistry;", "<init>", "(Lcom/embabel/agent/api/tool/Tool;Lio/micrometer/observation/ObservationRegistry;)V", "getDelegate", "()Lcom/embabel/agent/api/tool/Tool;", "definition", "Lcom/embabel/agent/api/tool/Tool$Definition;", "getDefinition", "()Lcom/embabel/agent/api/tool/Tool$Definition;", "metadata", "Lcom/embabel/agent/api/tool/Tool$Metadata;", "getMetadata", "()Lcom/embabel/agent/api/tool/Tool$Metadata;", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "input", "", "toString", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nToolDecorators.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolDecorators.kt\ncom/embabel/agent/spi/support/ObservabilityTool\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,281:1\n27#2:282\n*S KotlinDebug\n*F\n+ 1 ToolDecorators.kt\ncom/embabel/agent/spi/support/ObservabilityTool\n*L\n77#1:282\n*E\n"})
public final class ObservabilityTool
implements DelegatingTool {
    @NotNull
    private final Tool delegate;
    @Nullable
    private final ObservationRegistry observationRegistry;
    @NotNull
    private final Tool.Definition definition;
    @NotNull
    private final Tool.Metadata metadata;

    public ObservabilityTool(@NotNull Tool delegate, @Nullable ObservationRegistry observationRegistry) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.observationRegistry = observationRegistry;
        this.definition = this.getDelegate().getDefinition();
        this.metadata = this.getDelegate().getMetadata();
    }

    public /* synthetic */ ObservabilityTool(Tool tool, ObservationRegistry observationRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            observationRegistry = null;
        }
        this(tool, observationRegistry);
    }

    @Override
    @NotNull
    public Tool getDelegate() {
        return this.delegate;
    }

    @Override
    @NotNull
    public Tool.Definition getDefinition() {
        return this.definition;
    }

    @Override
    @NotNull
    public Tool.Metadata getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Tool.Result call(@NotNull String input) {
        Tool.Result result;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (this.observationRegistry == null) {
            return this.getDelegate().call(input);
        }
        Observation currentObservation = this.observationRegistry.getCurrentObservation();
        if (currentObservation == null) {
            boolean $i$f$loggerFor22 = false;
            Logger logger = LoggerFactory.getLogger(ObservabilityTool.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            Object[] $i$f$loggerFor22 = new Object[]{this.getDelegate().getDefinition().getName(), input, this.observationRegistry};
            logger.warn("No parent observation for tool call {} with input: {}, observation registry: {}", $i$f$loggerFor22);
        }
        Observation observation = Observation.createNotStarted((String)"tool call", (ObservationRegistry)this.observationRegistry).lowCardinalityKeyValue("toolName", this.getDelegate().getDefinition().getName()).highCardinalityKeyValue("payload", input).parentObservation(currentObservation).start();
        Intrinsics.checkNotNullExpressionValue((Object)observation, (String)"start(...)");
        Observation observation2 = observation;
        try {
            Tool.Result result2 = this.getDelegate().call(input);
            observation2.lowCardinalityKeyValue("status", "success");
            observation2.highCardinalityKeyValue("result", ToolDecoratorsKt.access$getContent(result2));
            result = result2;
        }
        catch (Exception ex) {
            observation2.lowCardinalityKeyValue("status", "error");
            String string = Reflection.getOrCreateKotlinClass(ex.getClass()).getSimpleName();
            if (string == null) {
                string = "Unknown";
            }
            observation2.highCardinalityKeyValue("error_type", string);
            String string2 = ex.getMessage();
            if (string2 == null) {
                string2 = "No message";
            }
            observation2.highCardinalityKeyValue("error_message", string2);
            observation2.error((Throwable)ex);
            throw ex;
        }
        finally {
            observation2.stop();
        }
        return result;
    }

    @NotNull
    public String toString() {
        return "ObservabilityTool(delegate=" + this.getDelegate().getDefinition().getName() + ")";
    }
}

