/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support;

import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.AgentProcessRepository;
import com.embabel.agent.spi.config.spring.ProcessRepositoryProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/embabel/agent/spi/support/InMemoryAgentProcessRepository;", "Lcom/embabel/agent/core/AgentProcessRepository;", "properties", "Lcom/embabel/agent/spi/config/spring/ProcessRepositoryProperties;", "<init>", "(Lcom/embabel/agent/spi/config/spring/ProcessRepositoryProperties;)V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/embabel/agent/core/AgentProcess;", "accessOrder", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "findById", "id", "save", "agentProcess", "update", "", "delete", "size", "", "clear", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nInMemoryAgentProcessRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryAgentProcessRepository.kt\ncom/embabel/agent/spi/support/InMemoryAgentProcessRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class InMemoryAgentProcessRepository
implements AgentProcessRepository {
    @NotNull
    private final ProcessRepositoryProperties properties;
    @NotNull
    private final ConcurrentHashMap<String, AgentProcess> map;
    @NotNull
    private final ConcurrentLinkedQueue<String> accessOrder;
    @NotNull
    private final ReentrantReadWriteLock lock;

    public InMemoryAgentProcessRepository(@NotNull ProcessRepositoryProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
        this.map = new ConcurrentHashMap();
        this.accessOrder = new ConcurrentLinkedQueue();
        this.lock = new ReentrantReadWriteLock();
    }

    public /* synthetic */ InMemoryAgentProcessRepository(ProcessRepositoryProperties processRepositoryProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            processRepositoryProperties = new ProcessRepositoryProperties();
        }
        this(processRepositoryProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AgentProcess findById(@NotNull String id) {
        AgentProcess agentProcess;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            agentProcess = this.map.get(id);
        }
        finally {
            readLock.unlock();
        }
        return agentProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public AgentProcess save(@NotNull AgentProcess agentProcess) {
        AgentProcess agentProcess2;
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            String processId = agentProcess.getId();
            if (this.map.containsKey(processId)) {
                this.accessOrder.remove(processId);
            }
            ((Map)this.map).put(processId, agentProcess);
            this.accessOrder.offer(processId);
            while (this.map.size() > this.properties.getWindowSize()) {
                String oldestId = this.accessOrder.poll();
                if (oldestId == null) continue;
                this.map.remove(oldestId);
            }
            agentProcess2 = agentProcess;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return agentProcess2;
    }

    @Override
    public void update(@NotNull AgentProcess agentProcess) {
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull AgentProcess agentProcess) {
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            String processId = agentProcess.getId();
            this.map.remove(processId);
            boolean bl2 = this.accessOrder.remove(processId);
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int n;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            n = this.map.size();
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.map.clear();
            this.accessOrder.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public InMemoryAgentProcessRepository() {
        this(null, 1, null);
    }
}

