/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.loop.support;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.ToolControlFlowSignal;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.BlackboardUpdater;
import com.embabel.agent.core.ReplanRequestedException;
import com.embabel.agent.core.Usage;
import com.embabel.agent.spi.loop.LlmMessageResponse;
import com.embabel.agent.spi.loop.LlmMessageSender;
import com.embabel.agent.spi.loop.MaxIterationsExceededException;
import com.embabel.agent.spi.loop.ToolCallResult;
import com.embabel.agent.spi.loop.ToolInjectionContext;
import com.embabel.agent.spi.loop.ToolInjectionResult;
import com.embabel.agent.spi.loop.ToolInjectionStrategy;
import com.embabel.agent.spi.loop.ToolLoop;
import com.embabel.agent.spi.loop.ToolLoopResult;
import com.embabel.agent.spi.loop.ToolNotFoundException;
import com.embabel.chat.AssistantMessageWithToolCalls;
import com.embabel.chat.Message;
import com.embabel.chat.ToolCall;
import com.embabel.chat.ToolResultMessage;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001:\u0001>BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJD\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002H\u00150\u000bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\tH\u0002J\u001a\u0010\"\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0002J8\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u00152\u0006\u0010(\u001a\u00020\u001b2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002H\u00150\u000b2\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010)\u001a\u00020\u001d2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00172\u0006\u0010%\u001a\u00020&H\u0014J\u0018\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020+2\u0006\u0010%\u001a\u00020&H\u0004J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\f2\u0006\u0010-\u001a\u00020+H\u0004J \u00100\u001a\u00020 2\u0006\u0010-\u001a\u00020+2\u0006\u00101\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0004J&\u00102\u001a\u00020 2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u00104\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0002J&\u00105\u001a\u00020 2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u00104\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0002J \u00107\u001a\u00020 2\u0006\u0010-\u001a\u00020+2\u0006\u00101\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0004J \u00108\u001a\u0004\u0018\u00010\f2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010:\u001a\u00020\u001bH\u0004J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006?"}, d2={"Lcom/embabel/agent/spi/loop/support/DefaultToolLoop;", "Lcom/embabel/agent/spi/loop/ToolLoop;", "llmMessageSender", "Lcom/embabel/agent/spi/loop/LlmMessageSender;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "injectionStrategy", "Lcom/embabel/agent/spi/loop/ToolInjectionStrategy;", "maxIterations", "", "toolDecorator", "Lkotlin/Function1;", "Lcom/embabel/agent/api/tool/Tool;", "<init>", "(Lcom/embabel/agent/spi/loop/LlmMessageSender;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/embabel/agent/spi/loop/ToolInjectionStrategy;ILkotlin/jvm/functions/Function1;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "execute", "Lcom/embabel/agent/spi/loop/ToolLoopResult;", "O", "initialMessages", "", "Lcom/embabel/chat/Message;", "initialTools", "outputParser", "", "hasToolCalls", "", "message", "logCompletion", "", "iterations", "accumulateUsage", "usage", "Lcom/embabel/agent/core/Usage;", "state", "Lcom/embabel/agent/spi/loop/support/DefaultToolLoop$LoopState;", "buildResult", "finalText", "processToolCalls", "toolCalls", "Lcom/embabel/chat/ToolCall;", "processToolCall", "toolCall", "executeToolCall", "tool", "applyInjectionStrategy", "resultContent", "removeTools", "toolsToRemove", "afterToolName", "addTools", "toolsToAdd", "addToolResultToHistory", "findTool", "tools", "name", "tryDeserialize", "", "jsonResult", "LoopState", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nDefaultToolLoop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultToolLoop.kt\ncom/embabel/agent/spi/loop/support/DefaultToolLoop\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1557#2:314\n1628#2,3:315\n1557#2:318\n1628#2,3:319\n1557#2:322\n1628#2,3:323\n1557#2:326\n1628#2,3:327\n774#2:330\n865#2,2:331\n1557#2:333\n1628#2,3:334\n1#3:337\n*S KotlinDebug\n*F\n+ 1 DefaultToolLoop.kt\ncom/embabel/agent/spi/loop/support/DefaultToolLoop\n*L\n160#1:314\n160#1:315,3\n225#1:318\n225#1:319,3\n239#1:322\n239#1:323,3\n245#1:326\n245#1:327,3\n246#1:330\n246#1:331,2\n259#1:333\n259#1:334,3\n*E\n"})
public class DefaultToolLoop
implements ToolLoop {
    @NotNull
    private final LlmMessageSender llmMessageSender;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ToolInjectionStrategy injectionStrategy;
    private final int maxIterations;
    @Nullable
    private final Function1<Tool, Tool> toolDecorator;
    private final Logger logger;

    public DefaultToolLoop(@NotNull LlmMessageSender llmMessageSender, @NotNull ObjectMapper objectMapper, @NotNull ToolInjectionStrategy injectionStrategy, int maxIterations, @Nullable Function1<? super Tool, ? extends Tool> toolDecorator) {
        Intrinsics.checkNotNullParameter((Object)llmMessageSender, (String)"llmMessageSender");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)injectionStrategy, (String)"injectionStrategy");
        this.llmMessageSender = llmMessageSender;
        this.objectMapper = objectMapper;
        this.injectionStrategy = injectionStrategy;
        this.maxIterations = maxIterations;
        this.toolDecorator = toolDecorator;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ DefaultToolLoop(LlmMessageSender llmMessageSender, ObjectMapper objectMapper, ToolInjectionStrategy toolInjectionStrategy, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            toolInjectionStrategy = ToolInjectionStrategy.Companion.getNONE();
        }
        if ((n2 & 8) != 0) {
            n = 20;
        }
        if ((n2 & 0x10) != 0) {
            function1 = null;
        }
        this(llmMessageSender, objectMapper, toolInjectionStrategy, n, (Function1<? super Tool, ? extends Tool>)function1);
    }

    @Override
    @NotNull
    public <O> ToolLoopResult<O> execute(@NotNull List<? extends Message> initialMessages, @NotNull List<? extends Tool> initialTools, @NotNull Function1<? super String, ? extends O> outputParser2) {
        Intrinsics.checkNotNullParameter(initialMessages, (String)"initialMessages");
        Intrinsics.checkNotNullParameter(initialTools, (String)"initialTools");
        Intrinsics.checkNotNullParameter(outputParser2, (String)"outputParser");
        LoopState state = new LoopState(CollectionsKt.toMutableList((Collection)initialMessages), CollectionsKt.toMutableList((Collection)initialTools), null, null, null, 0, false, null, null, 508, null);
        while (state.getIterations() < this.maxIterations) {
            int n = state.getIterations();
            state.setIterations(n + 1);
            this.logger.debug("Tool loop iteration {} with {} available tools", (Object)state.getIterations(), (Object)state.getAvailableTools().size());
            LlmMessageResponse callResult = this.llmMessageSender.call(state.getConversationHistory(), state.getAvailableTools());
            this.accumulateUsage(callResult.getUsage(), state);
            state.getConversationHistory().add(callResult.getMessage());
            this.logger.debug("ToolLoop returned. Passed messages:\n{}\nResult: {}", (Object)CollectionsKt.joinToString$default((Iterable)state.getConversationHistory(), (CharSequence)"\n", null, null, (int)0, null, DefaultToolLoop::execute$lambda$0, (int)30, null), (Object)callResult.getMessage());
            if (!this.hasToolCalls(callResult.getMessage())) {
                this.logCompletion(state.getIterations());
                return this.buildResult(callResult.getTextContent(), outputParser2, state);
            }
            Message message = callResult.getMessage();
            Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type com.embabel.chat.AssistantMessageWithToolCalls");
            AssistantMessageWithToolCalls assistantMessage = (AssistantMessageWithToolCalls)message;
            boolean shouldContinue = this.processToolCalls(assistantMessage.getToolCalls(), state);
            if (shouldContinue) continue;
            this.logger.info("Tool loop terminated for replan after {} iterations", (Object)state.getIterations());
            return this.buildResult("", outputParser2, state);
        }
        throw new MaxIterationsExceededException(this.maxIterations);
    }

    private final boolean hasToolCalls(Message message) {
        return message instanceof AssistantMessageWithToolCalls && !((Collection)((AssistantMessageWithToolCalls)message).getToolCalls()).isEmpty();
    }

    private final void logCompletion(int iterations) {
        String message = "Tool loop completed after {} iterations";
        if (iterations == 1) {
            this.logger.debug(message, (Object)iterations);
        } else {
            this.logger.info(message, (Object)iterations);
        }
    }

    private final void accumulateUsage(Usage usage, LoopState state) {
        block1: {
            Usage usage2 = usage;
            if (usage2 == null) break block1;
            Usage it = usage2;
            boolean bl = false;
            Usage usage3 = state.getAccumulatedUsage();
            if (usage3 == null || (usage3 = usage3.plus(it)) == null) {
                usage3 = it;
            }
            state.setAccumulatedUsage(usage3);
        }
    }

    private final <O> ToolLoopResult<O> buildResult(String finalText, Function1<? super String, ? extends O> outputParser2, LoopState state) {
        return new ToolLoopResult<Object>(outputParser2.invoke((Object)finalText), state.getConversationHistory(), state.getIterations(), state.getInjectedTools(), state.getRemovedTools(), state.getAccumulatedUsage(), state.getReplanRequested(), state.getReplanReason(), state.getBlackboardUpdater());
    }

    protected boolean processToolCalls(@NotNull List<ToolCall> toolCalls, @NotNull LoopState state) {
        Intrinsics.checkNotNullParameter(toolCalls, (String)"toolCalls");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        for (ToolCall toolCall : toolCalls) {
            boolean shouldContinue = this.processToolCall(toolCall, state);
            if (shouldContinue) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean processToolCall(@NotNull ToolCall toolCall, @NotNull LoopState state) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Tool tool = this.findTool(state.getAvailableTools(), toolCall.getName());
        if (tool == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = state.getAvailableTools();
            String string = toolCall.getName();
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Tool tool2 = (Tool)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getDefinition().getName());
            }
            List list = (List)destination$iv$iv;
            String string2 = string;
            throw new ToolNotFoundException(string2, list);
        }
        Tool tool3 = tool;
        try {
            String resultContent = this.executeToolCall(tool3, toolCall);
            this.applyInjectionStrategy(toolCall, resultContent, state);
            this.addToolResultToHistory(toolCall, resultContent, state);
            bl = true;
        }
        catch (ReplanRequestedException e) {
            this.logger.info("Tool '{}' requested replan: {}", (Object)toolCall.getName(), (Object)e.getReason());
            state.setReplanRequested(true);
            state.setReplanReason(e.getReason());
            state.setBlackboardUpdater(e.getBlackboardUpdater());
            bl = false;
        }
        catch (Exception e) {
            if (e instanceof ToolControlFlowSignal) {
                throw e;
            }
            throw e;
        }
        return bl;
    }

    @NotNull
    protected final String executeToolCall(@NotNull Tool tool, @NotNull ToolCall toolCall) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
        this.logger.debug("Executing tool: {} with input: {}", (Object)toolCall.getName(), (Object)toolCall.getArguments());
        Tool.Result toolResult = tool.call(toolCall.getArguments());
        if (toolResult instanceof Tool.Result.Text) {
            object = ((Tool.Result.Text)toolResult).getContent();
        } else if (toolResult instanceof Tool.Result.WithArtifact) {
            object = ((Tool.Result.WithArtifact)toolResult).getContent();
        } else if (toolResult instanceof Tool.Result.Error) {
            object = "Error: " + ((Tool.Result.Error)toolResult).getMessage();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    protected final void applyInjectionStrategy(@NotNull ToolCall toolCall, @NotNull String resultContent, @NotNull LoopState state) {
        Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
        Intrinsics.checkNotNullParameter((Object)resultContent, (String)"resultContent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ToolInjectionContext context = new ToolInjectionContext(state.getConversationHistory(), state.getAvailableTools(), new ToolCallResult(toolCall.getName(), toolCall.getArguments(), resultContent, this.tryDeserialize(resultContent)), state.getIterations());
        ToolInjectionResult injectionResult = this.injectionStrategy.evaluate(context);
        if (!injectionResult.hasChanges()) {
            return;
        }
        this.removeTools(injectionResult.getToolsToRemove(), toolCall.getName(), state);
        this.addTools(injectionResult.getToolsToAdd(), toolCall.getName(), state);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeTools(List<? extends Tool> toolsToRemove, String afterToolName, LoopState state) {
        void $this$mapTo$iv$iv;
        if (toolsToRemove.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = toolsToRemove;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tool tool = (Tool)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDefinition().getName());
        }
        Set namesToRemove = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        state.getAvailableTools().removeIf(arg_0 -> DefaultToolLoop.removeTools$lambda$5(arg_0 -> DefaultToolLoop.removeTools$lambda$4(namesToRemove, arg_0), arg_0));
        state.getRemovedTools().addAll((Collection<Tool>)toolsToRemove);
        Object[] objectArray = new Object[]{toolsToRemove.size(), afterToolName, namesToRemove};
        this.logger.info("Strategy removed {} tools after {}: {}", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final void addTools(List<? extends Tool> toolsToAdd, String afterToolName, LoopState state) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv2;
        List list;
        Iterable iterable;
        Iterable destination$iv$iv;
        if (toolsToAdd.isEmpty()) {
            return;
        }
        if (this.toolDecorator != null) {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv2 = toolsToAdd;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Iterator item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                Tool tool = (Tool)((Object)item$iv$iv);
                iterable = destination$iv$iv;
                boolean bl = false;
                iterable.add((Tool)this.toolDecorator.invoke((Object)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = toolsToAdd;
        }
        List decoratedTools = list;
        Iterable $this$map$iv3 = state.getAvailableTools();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv3;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Tool bl = (Tool)item$iv$iv;
            iterable = destination$iv$iv2;
            boolean bl2 = false;
            iterable.add(it.getDefinition().getName());
        }
        Set existingNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$filter$iv = decoratedTools;
        boolean $i$f$filter22 = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tool it = (Tool)element$iv$iv;
            boolean bl = false;
            if (!(!existingNames.contains(it.getDefinition().getName()))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List newTools = (List)destination$iv$iv3;
        if (newTools.isEmpty()) {
            this.logger.debug("All {} tools already present after {}, skipping", (Object)decoratedTools.size(), (Object)afterToolName);
            return;
        }
        state.getAvailableTools().addAll(newTools);
        state.getInjectedTools().addAll(newTools);
        Object[] objectArray = new Object[3];
        objectArray[0] = newTools.size();
        objectArray[1] = afterToolName;
        Iterable $i$f$filter22 = newTools;
        int n = 2;
        Object[] objectArray2 = objectArray;
        String string = "Strategy injected {} tools after {}: {}";
        iterable = this.logger;
        boolean $i$f$map2 = false;
        destination$iv$iv3 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tool bl = (Tool)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl3 = false;
            collection.add(it.getDefinition().getName());
        }
        collection = (List)destination$iv$iv4;
        objectArray2[n] = collection;
        iterable.info(string, objectArray);
    }

    protected final void addToolResultToHistory(@NotNull ToolCall toolCall, @NotNull String resultContent, @NotNull LoopState state) {
        Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
        Intrinsics.checkNotNullParameter((Object)resultContent, (String)"resultContent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        state.getConversationHistory().add(new ToolResultMessage(toolCall.getId(), toolCall.getName(), resultContent, null, 8, null));
    }

    @Nullable
    protected final Tool findTool(@NotNull List<? extends Tool> tools, @NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(tools, (String)"tools");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = tools;
            for (Object t : iterable) {
                Tool it = (Tool)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDefinition().getName(), (Object)name)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final Object tryDeserialize(String jsonResult) {
        Object object;
        String trimmed = ((Object)StringsKt.trimStart((CharSequence)jsonResult)).toString();
        if (!StringsKt.startsWith$default((CharSequence)trimmed, (char)'{', (boolean)false, (int)2, null) && !StringsKt.startsWith$default((CharSequence)trimmed, (char)'[', (boolean)false, (int)2, null)) {
            return null;
        }
        try {
            object = this.objectMapper.readValue(jsonResult, Object.class);
        }
        catch (Exception e) {
            this.logger.debug("Could not deserialize tool result as JSON: {}", (Object)e.getMessage());
            object = null;
        }
        return object;
    }

    private static final CharSequence execute$lambda$0(Message it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\t" + it;
    }

    private static final boolean removeTools$lambda$4(Set $namesToRemove, Tool it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $namesToRemove.contains(it.getDefinition().getName());
    }

    private static final boolean removeTools$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\b\u0004\u0018\u00002\u00020\u0001By\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lcom/embabel/agent/spi/loop/support/DefaultToolLoop$LoopState;", "", "conversationHistory", "", "Lcom/embabel/chat/Message;", "availableTools", "Lcom/embabel/agent/api/tool/Tool;", "injectedTools", "removedTools", "accumulatedUsage", "Lcom/embabel/agent/core/Usage;", "iterations", "", "replanRequested", "", "replanReason", "", "blackboardUpdater", "Lcom/embabel/agent/core/BlackboardUpdater;", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/embabel/agent/core/Usage;IZLjava/lang/String;Lcom/embabel/agent/core/BlackboardUpdater;)V", "getConversationHistory", "()Ljava/util/List;", "getAvailableTools", "getInjectedTools", "getRemovedTools", "getAccumulatedUsage", "()Lcom/embabel/agent/core/Usage;", "setAccumulatedUsage", "(Lcom/embabel/agent/core/Usage;)V", "getIterations", "()I", "setIterations", "(I)V", "getReplanRequested", "()Z", "setReplanRequested", "(Z)V", "getReplanReason", "()Ljava/lang/String;", "setReplanReason", "(Ljava/lang/String;)V", "getBlackboardUpdater", "()Lcom/embabel/agent/core/BlackboardUpdater;", "setBlackboardUpdater", "(Lcom/embabel/agent/core/BlackboardUpdater;)V", "embabel-agent-api"})
    protected static final class LoopState {
        @NotNull
        private final List<Message> conversationHistory;
        @NotNull
        private final List<Tool> availableTools;
        @NotNull
        private final List<Tool> injectedTools;
        @NotNull
        private final List<Tool> removedTools;
        @Nullable
        private Usage accumulatedUsage;
        private int iterations;
        private boolean replanRequested;
        @Nullable
        private String replanReason;
        @NotNull
        private BlackboardUpdater blackboardUpdater;

        public LoopState(@NotNull List<Message> conversationHistory, @NotNull List<Tool> availableTools, @NotNull List<Tool> injectedTools, @NotNull List<Tool> removedTools, @Nullable Usage accumulatedUsage, int iterations, boolean replanRequested, @Nullable String replanReason, @NotNull BlackboardUpdater blackboardUpdater) {
            Intrinsics.checkNotNullParameter(conversationHistory, (String)"conversationHistory");
            Intrinsics.checkNotNullParameter(availableTools, (String)"availableTools");
            Intrinsics.checkNotNullParameter(injectedTools, (String)"injectedTools");
            Intrinsics.checkNotNullParameter(removedTools, (String)"removedTools");
            Intrinsics.checkNotNullParameter((Object)blackboardUpdater, (String)"blackboardUpdater");
            this.conversationHistory = conversationHistory;
            this.availableTools = availableTools;
            this.injectedTools = injectedTools;
            this.removedTools = removedTools;
            this.accumulatedUsage = accumulatedUsage;
            this.iterations = iterations;
            this.replanRequested = replanRequested;
            this.replanReason = replanReason;
            this.blackboardUpdater = blackboardUpdater;
        }

        public /* synthetic */ LoopState(List list, List list2, List list3, List list4, Usage usage, int n, boolean bl, String string, BlackboardUpdater blackboardUpdater, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                list3 = new ArrayList();
            }
            if ((n2 & 8) != 0) {
                list4 = new ArrayList();
            }
            if ((n2 & 0x10) != 0) {
                usage = null;
            }
            if ((n2 & 0x20) != 0) {
                n = 0;
            }
            if ((n2 & 0x40) != 0) {
                bl = false;
            }
            if ((n2 & 0x80) != 0) {
                string = null;
            }
            if ((n2 & 0x100) != 0) {
                blackboardUpdater = LoopState::_init_$lambda$0;
            }
            this(list, list2, list3, list4, usage, n, bl, string, blackboardUpdater);
        }

        @NotNull
        public final List<Message> getConversationHistory() {
            return this.conversationHistory;
        }

        @NotNull
        public final List<Tool> getAvailableTools() {
            return this.availableTools;
        }

        @NotNull
        public final List<Tool> getInjectedTools() {
            return this.injectedTools;
        }

        @NotNull
        public final List<Tool> getRemovedTools() {
            return this.removedTools;
        }

        @Nullable
        public final Usage getAccumulatedUsage() {
            return this.accumulatedUsage;
        }

        public final void setAccumulatedUsage(@Nullable Usage usage) {
            this.accumulatedUsage = usage;
        }

        public final int getIterations() {
            return this.iterations;
        }

        public final void setIterations(int n) {
            this.iterations = n;
        }

        public final boolean getReplanRequested() {
            return this.replanRequested;
        }

        public final void setReplanRequested(boolean bl) {
            this.replanRequested = bl;
        }

        @Nullable
        public final String getReplanReason() {
            return this.replanReason;
        }

        public final void setReplanReason(@Nullable String string) {
            this.replanReason = string;
        }

        @NotNull
        public final BlackboardUpdater getBlackboardUpdater() {
            return this.blackboardUpdater;
        }

        public final void setBlackboardUpdater(@NotNull BlackboardUpdater blackboardUpdater) {
            Intrinsics.checkNotNullParameter((Object)blackboardUpdater, (String)"<set-?>");
            this.blackboardUpdater = blackboardUpdater;
        }

        private static final void _init_$lambda$0(Blackboard it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        }
    }
}

