/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.loop;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.config.ToolLoopConfiguration;
import com.embabel.agent.spi.loop.LlmMessageSender;
import com.embabel.agent.spi.loop.ToolInjectionStrategy;
import com.embabel.agent.spi.loop.ToolLoop;
import com.embabel.agent.spi.loop.ToolLoopFactory;
import com.embabel.agent.spi.loop.support.DefaultToolLoop;
import com.embabel.agent.spi.loop.support.ParallelToolLoop;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ>\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0016J>\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u0006H\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f*\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/embabel/agent/spi/loop/ConfigurableToolLoopFactory;", "Lcom/embabel/agent/spi/loop/ToolLoopFactory;", "Ljava/io/Closeable;", "config", "Lcom/embabel/agent/api/tool/config/ToolLoopConfiguration;", "executor", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Lcom/embabel/agent/api/tool/config/ToolLoopConfiguration;Ljava/util/concurrent/ExecutorService;)V", "lazyExecutorDelegate", "Lkotlin/Lazy;", "lazyExecutor", "getLazyExecutor$delegate", "(Lcom/embabel/agent/spi/loop/ConfigurableToolLoopFactory;)Ljava/lang/Object;", "getLazyExecutor", "()Ljava/util/concurrent/ExecutorService;", "create", "Lcom/embabel/agent/spi/loop/ToolLoop;", "llmMessageSender", "Lcom/embabel/agent/spi/loop/LlmMessageSender;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "injectionStrategy", "Lcom/embabel/agent/spi/loop/ToolInjectionStrategy;", "maxIterations", "", "toolDecorator", "Lkotlin/Function1;", "Lcom/embabel/agent/api/tool/Tool;", "createParallelToolLoop", "createExecutor", "close", "", "embabel-agent-api"})
public final class ConfigurableToolLoopFactory
implements ToolLoopFactory,
Closeable {
    @NotNull
    private final ToolLoopConfiguration config;
    @Nullable
    private final ExecutorService executor;
    @NotNull
    private final Lazy<ExecutorService> lazyExecutorDelegate;

    public ConfigurableToolLoopFactory(@NotNull ToolLoopConfiguration config, @Nullable ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.executor = executor;
        this.lazyExecutorDelegate = LazyKt.lazy(() -> ConfigurableToolLoopFactory.lazyExecutorDelegate$lambda$0(this));
    }

    public /* synthetic */ ConfigurableToolLoopFactory(ToolLoopConfiguration toolLoopConfiguration, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            executorService = null;
        }
        this(toolLoopConfiguration, executorService);
    }

    private final ExecutorService getLazyExecutor() {
        Lazy<ExecutorService> lazy = this.lazyExecutorDelegate;
        return (ExecutorService)lazy.getValue();
    }

    private static Object getLazyExecutor$delegate(ConfigurableToolLoopFactory configurableToolLoopFactory) {
        return configurableToolLoopFactory.lazyExecutorDelegate;
    }

    @Override
    @NotNull
    public ToolLoop create(@NotNull LlmMessageSender llmMessageSender, @NotNull ObjectMapper objectMapper, @NotNull ToolInjectionStrategy injectionStrategy, int maxIterations, @Nullable Function1<? super Tool, ? extends Tool> toolDecorator) {
        Intrinsics.checkNotNullParameter((Object)llmMessageSender, (String)"llmMessageSender");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)injectionStrategy, (String)"injectionStrategy");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.config.getType().ordinal()]) {
            case 1 -> new DefaultToolLoop(llmMessageSender, objectMapper, injectionStrategy, maxIterations, toolDecorator);
            case 2 -> this.createParallelToolLoop(llmMessageSender, objectMapper, injectionStrategy, maxIterations, toolDecorator);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final ToolLoop createParallelToolLoop(LlmMessageSender llmMessageSender, ObjectMapper objectMapper, ToolInjectionStrategy injectionStrategy, int maxIterations, Function1<? super Tool, ? extends Tool> toolDecorator) {
        ExecutorService executorService = this.executor;
        if (executorService == null) {
            executorService = this.getLazyExecutor();
        }
        return new ParallelToolLoop(llmMessageSender, objectMapper, injectionStrategy, maxIterations, toolDecorator, executorService, this.config.getParallel());
    }

    private final ExecutorService createExecutor() {
        ExecutorService executorService;
        switch (WhenMappings.$EnumSwitchMapping$1[this.config.getParallel().getExecutorType().ordinal()]) {
            case 1: {
                ExecutorService executorService2 = Executors.newVirtualThreadPerTaskExecutor();
                executorService = executorService2;
                Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newVirtualThreadPerTaskExecutor(...)");
                break;
            }
            case 2: {
                ExecutorService executorService3 = Executors.newFixedThreadPool(this.config.getParallel().getFixedPoolSize());
                executorService = executorService3;
                Intrinsics.checkNotNullExpressionValue((Object)executorService3, (String)"newFixedThreadPool(...)");
                break;
            }
            case 3: {
                ExecutorService executorService4 = Executors.newCachedThreadPool();
                executorService = executorService4;
                Intrinsics.checkNotNullExpressionValue((Object)executorService4, (String)"newCachedThreadPool(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return executorService;
    }

    @Override
    public void close() {
        if (this.executor == null && this.lazyExecutorDelegate.isInitialized()) {
            this.getLazyExecutor().shutdown();
            if (!this.getLazyExecutor().awaitTermination(this.config.getParallel().getShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS)) {
                this.getLazyExecutor().shutdownNow();
            }
        }
    }

    private static final ExecutorService lazyExecutorDelegate$lambda$0(ConfigurableToolLoopFactory this$0) {
        return this$0.createExecutor();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ToolLoopConfiguration.ToolLoopType.values().length];
            try {
                nArray[ToolLoopConfiguration.ToolLoopType.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolLoopConfiguration.ToolLoopType.PARALLEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ToolLoopConfiguration.ExecutorType.values().length];
            try {
                nArray[ToolLoopConfiguration.ExecutorType.VIRTUAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolLoopConfiguration.ExecutorType.FIXED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolLoopConfiguration.ExecutorType.CACHED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

