/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core;

import com.embabel.agent.api.event.ProcessKilledEvent;
import com.embabel.agent.core.ActionInvocation;
import com.embabel.agent.core.Agent;
import com.embabel.agent.core.AgentProcessStatusCode;
import com.embabel.agent.core.AgentProcessStatusReport;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.LlmInvocation;
import com.embabel.agent.core.LlmInvocationHistory;
import com.embabel.agent.core.OperationStatus;
import com.embabel.agent.core.ProcessContext;
import com.embabel.agent.core.ProcessOptions;
import com.embabel.common.core.types.Timed;
import com.embabel.common.core.types.Timestamped;
import com.embabel.common.util.ComputerSaysNoSerializer;
import com.embabel.plan.Goal;
import com.embabel.plan.Planner;
import com.embabel.plan.WorldState;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ComputerSaysNoSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\bg\u0018\u0000 K2\u00020\u00012\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u00020\u00050\u00042\u00020\u0006:\u0001KJ\b\u0010%\u001a\u00020&H\u0016J\n\u0010'\u001a\u0004\u0018\u00010(H&J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H&J\b\u0010=\u001a\u00020\u0000H&J\b\u0010>\u001a\u00020\u0000H&J!\u0010C\u001a\u0002HD\"\u0004\b\u0000\u0010D2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002HD0FH\u0016\u00a2\u0006\u0002\u0010GJ\u001a\u0010H\u001a\u0004\u0018\u00010*2\u0006\u0010I\u001a\u00020\b2\u0006\u0010J\u001a\u00020\bH\u0016R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010)\u001a\u0004\u0018\u00010*X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u0004\u0018\u00010.X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0012\u00101\u001a\u000202X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0012\u00105\u001a\u000206X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0014\u0010?\u001a\u00020@8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006L\u00c0\u0006\u0001"}, d2={"Lcom/embabel/agent/core/AgentProcess;", "Lcom/embabel/agent/core/Blackboard;", "Lcom/embabel/common/core/types/Timestamped;", "Lcom/embabel/common/core/types/Timed;", "Lcom/embabel/agent/core/OperationStatus;", "Lcom/embabel/agent/core/AgentProcessStatusCode;", "Lcom/embabel/agent/core/LlmInvocationHistory;", "id", "", "getId", "()Ljava/lang/String;", "blackboard", "getBlackboard", "()Lcom/embabel/agent/core/Blackboard;", "parentId", "getParentId", "processOptions", "Lcom/embabel/agent/core/ProcessOptions;", "getProcessOptions", "()Lcom/embabel/agent/core/ProcessOptions;", "planner", "Lcom/embabel/plan/Planner;", "getPlanner", "()Lcom/embabel/plan/Planner;", "history", "", "Lcom/embabel/agent/core/ActionInvocation;", "getHistory", "()Ljava/util/List;", "goal", "Lcom/embabel/plan/Goal;", "getGoal", "()Lcom/embabel/plan/Goal;", "finished", "", "getFinished", "()Z", "statusReport", "Lcom/embabel/agent/core/AgentProcessStatusReport;", "kill", "Lcom/embabel/agent/api/event/ProcessKilledEvent;", "failureInfo", "", "getFailureInfo", "()Ljava/lang/Object;", "lastWorldState", "Lcom/embabel/plan/WorldState;", "getLastWorldState", "()Lcom/embabel/plan/WorldState;", "processContext", "Lcom/embabel/agent/core/ProcessContext;", "getProcessContext", "()Lcom/embabel/agent/core/ProcessContext;", "agent", "Lcom/embabel/agent/core/Agent;", "getAgent", "()Lcom/embabel/agent/core/Agent;", "recordLlmInvocation", "", "llmInvocation", "Lcom/embabel/agent/core/LlmInvocation;", "tick", "run", "runningTime", "Ljava/time/Duration;", "getRunningTime", "()Ljava/time/Duration;", "resultOfType", "O", "outputClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "getValue", "variable", "type", "Companion", "embabel-agent-api"})
public interface AgentProcess
extends Blackboard,
Timestamped,
Timed,
OperationStatus<AgentProcessStatusCode>,
LlmInvocationHistory {
    @NotNull
    public static final Companion Companion = com.embabel.agent.core.AgentProcess$Companion.$$INSTANCE;

    @NotNull
    public String getId();

    @NotNull
    public Blackboard getBlackboard();

    @Nullable
    public String getParentId();

    @NotNull
    public ProcessOptions getProcessOptions();

    @NotNull
    public Planner<?, ?, ?> getPlanner();

    @NotNull
    public List<ActionInvocation> getHistory();

    @Nullable
    public Goal getGoal();

    default public boolean getFinished() {
        AgentProcessStatusCode[] agentProcessStatusCodeArray = new AgentProcessStatusCode[]{AgentProcessStatusCode.COMPLETED, AgentProcessStatusCode.FAILED, AgentProcessStatusCode.KILLED, AgentProcessStatusCode.TERMINATED};
        return SetsKt.setOf((Object[])agentProcessStatusCodeArray).contains(this.getStatus());
    }

    @NotNull
    default public AgentProcessStatusReport statusReport() {
        return new AgentProcessStatusReport(this.getId(), (AgentProcessStatusCode)this.getStatus(), this.getTimestamp(), this.getRunningTime());
    }

    @Nullable
    public ProcessKilledEvent kill();

    @Nullable
    public Object getFailureInfo();

    @Nullable
    public WorldState getLastWorldState();

    @NotNull
    public ProcessContext getProcessContext();

    @NotNull
    public Agent getAgent();

    public void recordLlmInvocation(@NotNull LlmInvocation var1);

    @NotNull
    public AgentProcess tick();

    @NotNull
    public AgentProcess run();

    @NotNull
    default public Duration getRunningTime() {
        Duration duration;
        if (this.getStatus() == AgentProcessStatusCode.NOT_STARTED) {
            Duration duration2 = Duration.ZERO;
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
        } else {
            Duration duration3 = Duration.between(this.getTimestamp(), Instant.now());
            duration = duration3;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"between(...)");
        }
        return duration;
    }

    default public <O> O resultOfType(@NotNull Class<O> outputClass) {
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        if (!(this.getStatus() == AgentProcessStatusCode.COMPLETED)) {
            boolean bl = false;
            String string = "Cannot get result of process that is not completed: Status=" + this.getStatus();
            throw new IllegalArgumentException(string.toString());
        }
        String string = outputClass.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        Object object = this.getValue("it", string);
        if (object == null) {
            throw new IllegalStateException(("No result of type " + outputClass.getName() + " found in process status").toString());
        }
        return (O)object;
    }

    @Nullable
    default public Object getValue(@NotNull String variable, @NotNull String type2) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return this.getBlackboard().getValue(variable, type2, this.getAgent());
    }

    @JvmStatic
    @Nullable
    public static AgentProcess get() {
        return Companion.get();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0001J\b\u0010\n\u001a\u00020\bH\u0001J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0007J)\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r*\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0011"}, d2={"Lcom/embabel/agent/core/AgentProcess$Companion;", "", "<init>", "()V", "threadLocalAgentProcess", "Ljava/lang/ThreadLocal;", "Lcom/embabel/agent/core/AgentProcess;", "set", "", "agentProcess", "remove", "get", "withCurrent", "T", "block", "Lkotlin/Function0;", "(Lcom/embabel/agent/core/AgentProcess;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "embabel-agent-api"})
    @SourceDebugExtension(value={"SMAP\nAgentProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentProcess.kt\ncom/embabel/agent/core/AgentProcess$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n1#2:245\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final ThreadLocal<AgentProcess> threadLocalAgentProcess;

        private Companion() {
        }

        @PublishedApi
        public final void set(@NotNull AgentProcess agentProcess) {
            Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
            threadLocalAgentProcess.set(agentProcess);
        }

        @PublishedApi
        public final void remove() {
            threadLocalAgentProcess.remove();
        }

        @JvmStatic
        @Nullable
        public final AgentProcess get() {
            AgentProcess agentProcess = threadLocalAgentProcess.get();
            if (agentProcess != null) {
                AgentProcess it = agentProcess;
                boolean bl = false;
                return it;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T withCurrent(@NotNull AgentProcess $this$withCurrent, @NotNull Function0<? extends T> block) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$withCurrent, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$withCurrent = false;
            AgentProcess previous = this.get();
            try {
                this.set($this$withCurrent);
                object = block.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                if (previous != null) {
                    this.set(previous);
                } else {
                    this.remove();
                }
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }

        static {
            $$INSTANCE = new Companion();
            threadLocalAgentProcess = new ThreadLocal();
        }
    }
}

