/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core;

import com.embabel.agent.api.tool.ToolControlFlowSignal;
import com.embabel.agent.core.ActionStatus;
import com.embabel.agent.core.ActionStatusCode;
import com.embabel.agent.core.ProcessContext;
import com.embabel.agent.core.ReplanRequestedException;
import com.embabel.agent.core.hitl.AwaitableResponseException;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.util.TimeKt;
import java.time.Duration;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u0000 \n2\u00020\u0001:\u0001\nJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/embabel/agent/core/ActionRunner;", "", "execute", "Lcom/embabel/agent/core/ActionStatus;", "processContext", "Lcom/embabel/agent/core/ProcessContext;", "referencedInputProperties", "", "", "variable", "Companion", "embabel-agent-api"})
public interface ActionRunner {
    @NotNull
    public static final Companion Companion = com.embabel.agent.core.ActionRunner$Companion.$$INSTANCE;

    @NotNull
    public ActionStatus execute(@NotNull ProcessContext var1);

    @NotNull
    public Set<String> referencedInputProperties(@NotNull String var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/embabel/agent/core/ActionRunner$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "execute", "Lcom/embabel/agent/core/ActionStatus;", "processContext", "Lcom/embabel/agent/core/ProcessContext;", "block", "Lkotlin/Function0;", "", "embabel-agent-api"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final Logger logger;

        private Companion() {
        }

        @NotNull
        public final ActionStatus execute(@NotNull ProcessContext processContext, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)processContext, (String)"processContext");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Pair pair = TimeKt.time(() -> Companion.execute$lambda$0(block, processContext));
            ActionStatusCode status = (ActionStatusCode)((Object)pair.component1());
            long ms = ((Number)pair.component2()).longValue();
            Duration duration = Duration.ofMillis(ms);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            Duration duration2 = duration;
            return new ActionStatus(duration2, status);
        }

        private static final ActionStatusCode execute$lambda$0(Function0 $block, ProcessContext $processContext) {
            ActionStatusCode actionStatusCode;
            try {
                $block.invoke();
                actionStatusCode = ActionStatusCode.SUCCEEDED;
            }
            catch (AwaitableResponseException are) {
                logger.debug("{} adding awaitable to blackboard: {}", (Object)$processContext.getAgentProcess().getId(), (Object)HasInfoString.infoString$default((HasInfoString)are.getAwaitable(), (Boolean)false, (int)0, (int)2, null));
                $processContext.getBlackboard().addObject(are.getAwaitable());
                actionStatusCode = ActionStatusCode.WAITING;
            }
            catch (ReplanRequestedException rpe) {
                throw rpe;
            }
            catch (Throwable t) {
                if (t instanceof ToolControlFlowSignal) {
                    throw t;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Unexpected error invoking action", t);
                } else {
                    logger.warn("Unexpected error invoking action: {}", (Object)t.getMessage());
                }
                throw t;
            }
            return actionStatusCode;
        }

        static {
            $$INSTANCE = new Companion();
            logger = LoggerFactory.getLogger(ActionRunner.class);
        }
    }
}

