/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.tool.agentic.playbook;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.agentic.DomainToolTracker;
import com.embabel.agent.api.tool.agentic.playbook.PlaybookContext;
import com.embabel.agent.core.Blackboard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eJ\u000e\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0001J\u0006\u0010'\u001a\u00020(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u001a8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001c\u00a8\u0006)"}, d2={"Lcom/embabel/agent/api/tool/agentic/playbook/PlaybookState;", "", "blackboard", "Lcom/embabel/agent/core/Blackboard;", "domainToolTracker", "Lcom/embabel/agent/api/tool/agentic/DomainToolTracker;", "<init>", "(Lcom/embabel/agent/core/Blackboard;Lcom/embabel/agent/api/tool/agentic/DomainToolTracker;)V", "getBlackboard", "()Lcom/embabel/agent/core/Blackboard;", "getDomainToolTracker", "()Lcom/embabel/agent/api/tool/agentic/DomainToolTracker;", "_calledToolNames", "", "", "_artifacts", "", "_dynamicTools", "Lcom/embabel/agent/api/tool/Tool;", "_iterationCount", "", "calledToolNames", "", "getCalledToolNames", "()Ljava/util/Set;", "artifacts", "", "getArtifacts", "()Ljava/util/List;", "iterationCount", "getIterationCount", "()I", "dynamicTools", "getDynamicTools", "recordToolCall", "", "toolName", "recordArtifact", "artifact", "toContext", "Lcom/embabel/agent/api/tool/agentic/playbook/PlaybookContext;", "embabel-agent-api"})
public final class PlaybookState {
    @NotNull
    private final Blackboard blackboard;
    @Nullable
    private final DomainToolTracker domainToolTracker;
    @NotNull
    private final Set<String> _calledToolNames;
    @NotNull
    private final List<Object> _artifacts;
    @NotNull
    private final List<Tool> _dynamicTools;
    private int _iterationCount;

    public PlaybookState(@NotNull Blackboard blackboard, @Nullable DomainToolTracker domainToolTracker) {
        Intrinsics.checkNotNullParameter((Object)blackboard, (String)"blackboard");
        this.blackboard = blackboard;
        this.domainToolTracker = domainToolTracker;
        this._calledToolNames = new LinkedHashSet();
        this._artifacts = new ArrayList();
        this._dynamicTools = new ArrayList();
    }

    public /* synthetic */ PlaybookState(Blackboard blackboard, DomainToolTracker domainToolTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            domainToolTracker = null;
        }
        this(blackboard, domainToolTracker);
    }

    @NotNull
    public final Blackboard getBlackboard() {
        return this.blackboard;
    }

    @Nullable
    public final DomainToolTracker getDomainToolTracker() {
        return this.domainToolTracker;
    }

    @NotNull
    public final Set<String> getCalledToolNames() {
        return CollectionsKt.toSet((Iterable)this._calledToolNames);
    }

    @NotNull
    public final List<Object> getArtifacts() {
        return CollectionsKt.toList((Iterable)this._artifacts);
    }

    public final int getIterationCount() {
        return this._iterationCount;
    }

    @NotNull
    public final List<Tool> getDynamicTools() {
        return CollectionsKt.toList((Iterable)this._dynamicTools);
    }

    public final void recordToolCall(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        this._calledToolNames.add(toolName);
        int n = this._iterationCount;
        this._iterationCount = n + 1;
    }

    public final void recordArtifact(@NotNull Object artifact) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            this._artifacts.add(artifact);
            DomainToolTracker domainToolTracker = this.domainToolTracker;
            if (domainToolTracker == null) break block0;
            DomainToolTracker tracker = domainToolTracker;
            boolean bl = false;
            List<Tool> newTools = tracker.tryBindArtifact(artifact);
            this._dynamicTools.addAll((Collection<Tool>)newTools);
        }
    }

    @NotNull
    public final PlaybookContext toContext() {
        return new PlaybookContext(this.getCalledToolNames(), this.getArtifacts(), this.getIterationCount(), this.blackboard);
    }
}

