/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.tool.agentic.playbook;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.agentic.playbook.PlaybookContext;
import com.embabel.agent.api.tool.agentic.playbook.PlaybookState;
import com.embabel.agent.api.tool.agentic.playbook.UnlockCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/embabel/agent/api/tool/agentic/playbook/ConditionalTool;", "Lcom/embabel/agent/api/tool/Tool;", "delegate", "condition", "Lcom/embabel/agent/api/tool/agentic/playbook/UnlockCondition;", "state", "Lcom/embabel/agent/api/tool/agentic/playbook/PlaybookState;", "<init>", "(Lcom/embabel/agent/api/tool/Tool;Lcom/embabel/agent/api/tool/agentic/playbook/UnlockCondition;Lcom/embabel/agent/api/tool/agentic/playbook/PlaybookState;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "definition", "Lcom/embabel/agent/api/tool/Tool$Definition;", "getDefinition", "()Lcom/embabel/agent/api/tool/Tool$Definition;", "metadata", "Lcom/embabel/agent/api/tool/Tool$Metadata;", "getMetadata", "()Lcom/embabel/agent/api/tool/Tool$Metadata;", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "input", "", "buildLockedMessage", "context", "Lcom/embabel/agent/api/tool/agentic/playbook/PlaybookContext;", "toString", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nPlaybookToolInjectionStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaybookToolInjectionStrategy.kt\ncom/embabel/agent/api/tool/agentic/playbook/ConditionalTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1863#2,2:180\n774#2:182\n865#2,2:183\n*S KotlinDebug\n*F\n+ 1 PlaybookToolInjectionStrategy.kt\ncom/embabel/agent/api/tool/agentic/playbook/ConditionalTool\n*L\n147#1:180,2\n158#1:182\n158#1:183,2\n*E\n"})
public final class ConditionalTool
implements Tool {
    @NotNull
    private final Tool delegate;
    @NotNull
    private final UnlockCondition condition;
    @NotNull
    private final PlaybookState state;
    private final Logger logger;
    @NotNull
    private final Tool.Definition definition;
    @NotNull
    private final Tool.Metadata metadata;

    public ConditionalTool(@NotNull Tool delegate, @NotNull UnlockCondition condition2, @NotNull PlaybookState state) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)condition2, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.delegate = delegate;
        this.condition = condition2;
        this.state = state;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.definition = new Tool.Definition(this){
            private final String name;
            private final String description;
            private final Tool.InputSchema inputSchema;
            {
                this.name = ConditionalTool.access$getDelegate$p($receiver).getDefinition().getName();
                this.description = ConditionalTool.access$getDelegate$p($receiver).getDefinition().getDescription() + "\n\nNote: This tool may require certain prerequisites before it becomes available.";
                this.inputSchema = ConditionalTool.access$getDelegate$p($receiver).getDefinition().getInputSchema();
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public Tool.InputSchema getInputSchema() {
                return this.inputSchema;
            }
        };
        this.metadata = this.delegate.getMetadata();
    }

    @Override
    @NotNull
    public Tool.Definition getDefinition() {
        return this.definition;
    }

    @Override
    @NotNull
    public Tool.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public Tool.Result call(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        PlaybookContext context = this.state.toContext();
        if (!this.condition.isSatisfied(context)) {
            this.logger.debug("Tool '{}' is locked - condition not satisfied. Called tools: {}", (Object)this.delegate.getDefinition().getName(), context.getCalledToolNames());
            return Tool.Result.Companion.text(this.buildLockedMessage(context));
        }
        this.logger.info("Tool '{}' is unlocked, executing", (Object)this.delegate.getDefinition().getName());
        Tool.Result result = this.delegate.call(input);
        this.state.recordToolCall(this.delegate.getDefinition().getName());
        if (result instanceof Tool.Result.WithArtifact) {
            Object artifact = ((Tool.Result.WithArtifact)result).getArtifact();
            if (artifact instanceof Iterable) {
                Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)((Iterable)artifact));
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl = false;
                    this.state.recordArtifact(it);
                }
            } else {
                this.state.recordArtifact(artifact);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final String buildLockedMessage(PlaybookContext context) {
        Object object;
        UnlockCondition unlockCondition = this.condition;
        if (unlockCondition instanceof UnlockCondition.AfterTools) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ((UnlockCondition.AfterTools)this.condition).getPrerequisites();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!context.getCalledToolNames().contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List missing = (List)destination$iv$iv;
            object = "You must first use: " + CollectionsKt.joinToString$default((Iterable)missing, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        } else if (unlockCondition instanceof UnlockCondition.OnArtifact) {
            object = "You must first produce an artifact of type: " + ((UnlockCondition.OnArtifact)this.condition).getArtifactType().getSimpleName();
        } else if (unlockCondition instanceof UnlockCondition.AllOf) {
            object = "Multiple conditions must be met before this tool is available.";
        } else if (unlockCondition instanceof UnlockCondition.AnyOf) {
            object = "At least one prerequisite condition must be met.";
        } else if (unlockCondition instanceof UnlockCondition.WhenPredicate) {
            object = "Prerequisites have not been met yet.";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Object hint = object;
        return "This tool is not yet available. " + (String)hint;
    }

    @NotNull
    public String toString() {
        return "ConditionalTool(" + this.delegate.getDefinition().getName() + ")";
    }

    public static final /* synthetic */ Tool access$getDelegate$p(ConditionalTool $this) {
        return $this.delegate;
    }
}

