/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.tool.agentic;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.agentic.DomainBoundTool;
import com.embabel.agent.api.tool.agentic.DomainToolFactory;
import com.embabel.agent.api.tool.agentic.DomainToolSource;
import com.embabel.agent.api.tool.agentic.DomainToolTracker;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/embabel/agent/api/tool/agentic/DomainToolFactory;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "createPlaceholderTools", "", "Lcom/embabel/agent/api/tool/Tool;", "source", "Lcom/embabel/agent/api/tool/agentic/DomainToolSource;", "tracker", "Lcom/embabel/agent/api/tool/agentic/DomainToolTracker;", "extractToolDefinitions", "Lcom/embabel/agent/api/tool/Tool$Definition;", "type", "Ljava/lang/Class;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nDomainToolSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DomainToolSource.kt\ncom/embabel/agent/api/tool/agentic/DomainToolFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n1557#2:347\n1628#2,3:348\n774#2:351\n865#2:352\n1755#2,3:353\n866#2:356\n1611#2,9:357\n1863#2:366\n1864#2:369\n1620#2:370\n1#3:367\n1#3:368\n*S KotlinDebug\n*F\n+ 1 DomainToolSource.kt\ncom/embabel/agent/api/tool/agentic/DomainToolFactory\n*L\n312#1:347\n312#1:348,3\n330#1:351\n330#1:352\n331#1:353,3\n330#1:356\n333#1:357,9\n333#1:366\n333#1:369\n333#1:370\n333#1:368\n*E\n"})
public final class DomainToolFactory {
    @NotNull
    public static final DomainToolFactory INSTANCE = new DomainToolFactory();
    private static final Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());

    private DomainToolFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Tool> createPlaceholderTools(@NotNull DomainToolSource<?> source, @NotNull DomainToolTracker tracker) {
        void $this$mapTo$iv$iv;
        List<Tool.Definition> list;
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        try {
            list = this.extractToolDefinitions(source.getType());
        }
        catch (Exception e) {
            logger.warn("Cannot extract tool definitions from {}: {}", (Object)source.getType().getSimpleName(), (Object)e.getMessage());
            return CollectionsKt.emptyList();
        }
        List<Tool.Definition> tools = list;
        Iterable $this$map$iv = tools;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void toolDef;
            Tool.Definition definition2 = (Tool.Definition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DomainBoundTool(source.getType(), toolDef.getName(), toolDef.getDescription(), toolDef.getInputSchema(), tracker));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Tool.Definition> extractToolDefinitions(Class<?> type2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Class<LlmTool> annotation = LlmTool.class;
        Iterable $this$filter$iv = JvmClassMappingKt.getKotlinClass(type2).getMembers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                KCallable member = (KCallable)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = member.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Annotation it = (Annotation)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)it)), annotation)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Tool.Definition definition2;
            Object var21_25;
            KCallable member;
            block9: {
                Object v1;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                member = (KCallable)element$iv$iv;
                boolean bl4 = false;
                Iterable iterable2 = member.getAnnotations();
                for (Object t : iterable2) {
                    Annotation it = (Annotation)t;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)it)), annotation)) continue;
                    v1 = t;
                    break block9;
                }
                v1 = var21_25 = null;
            }
            if ((var21_25 instanceof LlmTool ? (LlmTool)var21_25 : null) == null) {
                definition2 = null;
            } else {
                LlmTool llmToolAnnotation;
                llmToolAnnotation = llmToolAnnotation;
                definition2 = new Tool.Definition(llmToolAnnotation, member){
                    private final String name;
                    private final String description;
                    private final Tool.InputSchema inputSchema;
                    {
                        CharSequence charSequence;
                        extractToolDefinitions.2.1 v0 = this;
                        CharSequence charSequence2 = $llmToolAnnotation.name();
                        if (charSequence2.length() == 0) {
                            extractToolDefinitions.2.1 var5_4 = v0;
                            boolean bl = false;
                            charSequence = $member.getName();
                            v0 = var5_4;
                        } else {
                            charSequence = charSequence2;
                        }
                        v0.name = (String)charSequence;
                        this.description = $llmToolAnnotation.description();
                        this.inputSchema = Tool.InputSchema.Companion.empty();
                    }

                    public String getName() {
                        return this.name;
                    }

                    public String getDescription() {
                        return this.description;
                    }

                    public Tool.InputSchema getInputSchema() {
                        return this.inputSchema;
                    }
                };
            }
            if (definition2 == null) continue;
            Tool.Definition it$iv$iv = definition2;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

