/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.tool.agentic;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.agentic.DomainToolTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B3\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/embabel/agent/api/tool/agentic/DomainBoundTool;", "Lcom/embabel/agent/api/tool/Tool;", "sourceType", "Ljava/lang/Class;", "methodName", "", "methodDescription", "inputSchema", "Lcom/embabel/agent/api/tool/Tool$InputSchema;", "tracker", "Lcom/embabel/agent/api/tool/agentic/DomainToolTracker;", "<init>", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;Lcom/embabel/agent/api/tool/Tool$InputSchema;Lcom/embabel/agent/api/tool/agentic/DomainToolTracker;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "definition", "Lcom/embabel/agent/api/tool/Tool$Definition;", "getDefinition", "()Lcom/embabel/agent/api/tool/Tool$Definition;", "metadata", "Lcom/embabel/agent/api/tool/Tool$Metadata;", "getMetadata", "()Lcom/embabel/agent/api/tool/Tool$Metadata;", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "input", "toString", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nDomainToolSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DomainToolSource.kt\ncom/embabel/agent/api/tool/agentic/DomainBoundTool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n1#2:347\n*E\n"})
public final class DomainBoundTool
implements Tool {
    @NotNull
    private final Class<?> sourceType;
    @NotNull
    private final String methodName;
    @NotNull
    private final String methodDescription;
    @NotNull
    private final Tool.InputSchema inputSchema;
    @NotNull
    private final DomainToolTracker tracker;
    private final Logger logger;
    @NotNull
    private final Tool.Definition definition;
    @NotNull
    private final Tool.Metadata metadata;

    public DomainBoundTool(@NotNull Class<?> sourceType, @NotNull String methodName, @NotNull String methodDescription, @NotNull Tool.InputSchema inputSchema, @NotNull DomainToolTracker tracker) {
        Intrinsics.checkNotNullParameter(sourceType, (String)"sourceType");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)methodDescription, (String)"methodDescription");
        Intrinsics.checkNotNullParameter((Object)inputSchema, (String)"inputSchema");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        this.sourceType = sourceType;
        this.methodName = methodName;
        this.methodDescription = methodDescription;
        this.inputSchema = inputSchema;
        this.tracker = tracker;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.definition = new Tool.Definition(this){
            private final String name;
            private final String description;
            private final Tool.InputSchema inputSchema;
            {
                this.name = DomainBoundTool.access$getMethodName$p($receiver);
                this.description = DomainBoundTool.access$getMethodDescription$p($receiver) + "\n\nNote: This tool requires a " + DomainBoundTool.access$getSourceType$p($receiver).getSimpleName() + " instance to be retrieved first.";
                this.inputSchema = DomainBoundTool.access$getInputSchema$p($receiver);
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public Tool.InputSchema getInputSchema() {
                return this.inputSchema;
            }
        };
        this.metadata = Tool.Metadata.DEFAULT;
    }

    @Override
    @NotNull
    public Tool.Definition getDefinition() {
        return this.definition;
    }

    @Override
    @NotNull
    public Tool.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public Tool.Result call(@NotNull String input) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Object instance = this.tracker.getBoundInstance(this.sourceType);
            if (instance == null) {
                this.logger.debug("Tool '{}' called but no {} instance is bound", (Object)this.methodName, (Object)this.sourceType.getSimpleName());
                return Tool.Result.Companion.text("This tool is not yet available. You must first retrieve a single " + this.sourceType.getSimpleName() + " instance.");
            }
            List<Tool> tools = Tool.Companion.safelyFromInstance(instance);
            Iterable iterable = tools;
            for (Object t : iterable) {
                Tool it = (Tool)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDefinition().getName(), (Object)this.methodName)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Tool delegateTool = v0;
        if (delegateTool == null) {
            this.logger.error("Tool '{}' not found on {} instance", (Object)this.methodName, (Object)this.sourceType.getSimpleName());
            return Tool.Result.Companion.error$default(Tool.Result.Companion, "Tool '" + this.methodName + "' not found on " + this.sourceType.getSimpleName(), null, 2, null);
        }
        this.logger.info("Executing domain tool '{}' on {} instance", (Object)this.methodName, (Object)this.sourceType.getSimpleName());
        return delegateTool.call(input);
    }

    @NotNull
    public String toString() {
        return "DomainBoundTool(" + this.methodName + " on " + this.sourceType.getSimpleName() + ")";
    }

    public static final /* synthetic */ String access$getMethodName$p(DomainBoundTool $this) {
        return $this.methodName;
    }

    public static final /* synthetic */ String access$getMethodDescription$p(DomainBoundTool $this) {
        return $this.methodDescription;
    }

    public static final /* synthetic */ Class access$getSourceType$p(DomainBoundTool $this) {
        return $this.sourceType;
    }

    public static final /* synthetic */ Tool.InputSchema access$getInputSchema$p(DomainBoundTool $this) {
        return $this.inputSchema;
    }
}

