/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.tool.agentic;

import com.embabel.agent.api.common.Ai;
import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.agentic.AgenticExecutionConfig;
import com.embabel.agent.api.tool.agentic.AgenticExecutionResult;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.spi.config.spring.InfrastructureInjectionConfigurationKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u001c\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/embabel/agent/api/tool/agentic/AgenticToolSupport;", "", "<init>", "()V", "getAgentProcessOrError", "Lkotlin/Pair;", "Lcom/embabel/agent/core/AgentProcess;", "Lcom/embabel/agent/api/tool/Tool$Result;", "toolName", "", "logger", "Lorg/slf4j/Logger;", "execute", "Lcom/embabel/agent/api/tool/agentic/AgenticExecutionResult;", "config", "Lcom/embabel/agent/api/tool/agentic/AgenticExecutionConfig;", "agentProcess", "createResult", "output", "artifacts", "", "embabel-agent-api"})
public final class AgenticToolSupport {
    @NotNull
    public static final AgenticToolSupport INSTANCE = new AgenticToolSupport();

    private AgenticToolSupport() {
    }

    @NotNull
    public final Pair<AgentProcess, Tool.Result> getAgentProcessOrError(@NotNull String toolName, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        AgentProcess agentProcess = AgentProcess.Companion.get();
        if (agentProcess == null) {
            logger.error("No AgentProcess context available for '{}'", (Object)toolName);
            return TuplesKt.to(null, (Object)Tool.Result.Companion.error$default(Tool.Result.Companion, "No AgentProcess context available", null, 2, null));
        }
        return TuplesKt.to((Object)agentProcess, null);
    }

    @NotNull
    public final AgenticExecutionResult execute(@NotNull AgenticExecutionConfig config, @NotNull AgentProcess agentProcess) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        Ai ai = InfrastructureInjectionConfigurationKt.executingOperationContextFor(agentProcess).ai();
        String output = ai.withLlm(config.getLlm()).withId("agentic-tool-" + config.getToolName()).withTools(config.getTools()).withSystemPrompt(config.getSystemPrompt()).generateText("");
        return new AgenticExecutionResult(output, CollectionsKt.emptyList());
    }

    @NotNull
    public final Tool.Result createResult(@NotNull String output, @NotNull List<? extends Object> artifacts) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        return switch (artifacts.size()) {
            case 0 -> Tool.Result.Companion.text(output);
            case 1 -> Tool.Result.Companion.withArtifact(output, CollectionsKt.single(artifacts));
            default -> Tool.Result.Companion.withArtifact(output, CollectionsKt.toList((Iterable)artifacts));
        };
    }
}

