/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.tool;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.VictoolsSchemaGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/embabel/agent/api/tool/TypeBasedInputSchema;", "Lcom/embabel/agent/api/tool/Tool$InputSchema;", "type", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "parameters", "", "Lcom/embabel/agent/api/tool/Tool$Parameter;", "getParameters", "()Ljava/util/List;", "parameters$delegate", "Lkotlin/Lazy;", "toJsonSchema", "", "extractParameters", "Companion", "embabel-agent-api"})
public final class TypeBasedInputSchema
implements Tool.InputSchema {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<?> type;
    @NotNull
    private final Lazy parameters$delegate;
    @NotNull
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public TypeBasedInputSchema(@NotNull Class<?> type2) {
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        this.type = type2;
        this.parameters$delegate = LazyKt.lazy(() -> TypeBasedInputSchema.parameters_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public List<Tool.Parameter> getParameters() {
        Lazy lazy = this.parameters$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public String toJsonSchema() {
        List parameterInfos = new ArrayList();
        try {
            if (this.type.isRecord()) {
                throw new UnsupportedOperationException("Java records require fallback reflection");
            }
            KClass kClass = JvmClassMappingKt.getKotlinClass(this.type);
            for (KProperty1 prop : KClasses.getMemberProperties((KClass)kClass)) {
                Type javaType = ReflectJvmMapping.getJavaType((KType)prop.getReturnType());
                parameterInfos.add(new VictoolsSchemaGenerator.ParameterInfo(prop.getName(), javaType, prop.getName(), !prop.getReturnType().isMarkedNullable()));
            }
        }
        catch (Exception e) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])this.type.getDeclaredFields());
            while (iterator.hasNext()) {
                Field field = (Field)iterator.next();
                if (Modifier.isStatic(field.getModifiers())) continue;
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Type type2 = field.getGenericType();
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getGenericType(...)");
                String string2 = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                parameterInfos.add(new VictoolsSchemaGenerator.ParameterInfo(string, type2, string2, true));
            }
        }
        return VictoolsSchemaGenerator.INSTANCE.generateToolInputSchema(parameterInfos);
    }

    private final List<Tool.Parameter> extractParameters() {
        List params = new ArrayList();
        try {
            if (this.type.isRecord()) {
                throw new UnsupportedOperationException("Java records require fallback reflection");
            }
            KClass kClass = JvmClassMappingKt.getKotlinClass(this.type);
            for (KProperty1 prop : KClasses.getMemberProperties((KClass)kClass)) {
                Type type2 = ReflectJvmMapping.getJavaType((KType)prop.getReturnType());
                Class<Object> clazz = type2 instanceof Class ? (Class<Object>)((Object)type2) : null;
                if (clazz == null) {
                    clazz = Object.class;
                }
                Class<Object> propType = clazz;
                params.add(new Tool.Parameter(prop.getName(), TypeBasedInputSchema.Companion.mapPropertyTypeToParameterType(propType), prop.getName(), !prop.getReturnType().isMarkedNullable(), null, null, null, 112, null));
            }
        }
        catch (Exception e) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])this.type.getDeclaredFields());
            while (iterator.hasNext()) {
                Field field = (Field)iterator.next();
                if (Modifier.isStatic(field.getModifiers())) continue;
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Class<?> clazz = field.getType();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getType(...)");
                Tool.ParameterType parameterType = TypeBasedInputSchema.Companion.mapPropertyTypeToParameterType(clazz);
                String string2 = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                params.add(new Tool.Parameter(string, parameterType, string2, true, null, null, null, 112, null));
            }
        }
        return params;
    }

    private static final List parameters_delegate$lambda$0(TypeBasedInputSchema this$0) {
        return this$0.extractParameters();
    }

    @JvmStatic
    @NotNull
    public static final TypeBasedInputSchema of(@NotNull Class<?> type2) {
        return Companion.of(type2);
    }

    @JvmStatic
    @NotNull
    public static final TypeBasedInputSchema of(@NotNull KClass<?> type2) {
        return Companion.of(type2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0007J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\nH\u0007J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/embabel/agent/api/tool/TypeBasedInputSchema$Companion;", "", "<init>", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "of", "Lcom/embabel/agent/api/tool/TypeBasedInputSchema;", "type", "Ljava/lang/Class;", "Lkotlin/reflect/KClass;", "mapPropertyTypeToParameterType", "Lcom/embabel/agent/api/tool/Tool$ParameterType;", "embabel-agent-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TypeBasedInputSchema of(@NotNull Class<?> type2) {
            Intrinsics.checkNotNullParameter(type2, (String)"type");
            return new TypeBasedInputSchema(type2);
        }

        @JvmStatic
        @NotNull
        public final TypeBasedInputSchema of(@NotNull KClass<?> type2) {
            Intrinsics.checkNotNullParameter(type2, (String)"type");
            return new TypeBasedInputSchema(JvmClassMappingKt.getJavaClass(type2));
        }

        private final Tool.ParameterType mapPropertyTypeToParameterType(Class<?> type2) {
            return Intrinsics.areEqual(type2, String.class) || Intrinsics.areEqual(type2, String.class) ? Tool.ParameterType.STRING : (Intrinsics.areEqual(type2, Integer.TYPE) || Intrinsics.areEqual(type2, Integer.class) || Intrinsics.areEqual(type2, Long.TYPE) || Intrinsics.areEqual(type2, Long.class) ? Tool.ParameterType.INTEGER : (Intrinsics.areEqual(type2, Double.TYPE) || Intrinsics.areEqual(type2, Double.class) || Intrinsics.areEqual(type2, Float.TYPE) || Intrinsics.areEqual(type2, Float.class) ? Tool.ParameterType.NUMBER : (Intrinsics.areEqual(type2, Boolean.TYPE) || Intrinsics.areEqual(type2, Boolean.class) ? Tool.ParameterType.BOOLEAN : (type2.isArray() || List.class.isAssignableFrom(type2) ? Tool.ParameterType.ARRAY : Tool.ParameterType.OBJECT))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

